/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelUtil;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiUnderModel;
import com.maplesoft.mathdoc.view.WmiAdjustableTextBounds;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMathPaddedView;
import com.maplesoft.mathdoc.view.math.WmiSubscriptView;
import com.maplesoft.mathdoc.view.math.WmiTraversableCompositeMathView;
import com.maplesoft.mathdoc.view.math.renderers.WmiHorizontalStretchyRenderer;
import java.awt.Point;

public class WmiUnderView
extends WmiTraversableCompositeMathView {
    public static final int CENTER_INDEX = 0;
    public static final int UNDER_INDEX = 1;

    public WmiUnderView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            WmiPositionedView under = (WmiPositionedView)this.getChild(1);
            WmiPositionedView center = (WmiPositionedView)this.getChild(0);
            if (WmiHorizontalStretchyRenderer.resetStretchyOperator(under)) {
                ((WmiGenericView)under).markInvalid(1);
            } else {
                under.layoutView();
            }
            if (WmiHorizontalStretchyRenderer.resetStretchyOperator(center)) {
                ((WmiGenericView)center).markInvalid(1);
            } else {
                center.layoutView();
            }
            super.layoutView();
            boolean layoutAsSubscript = false;
            WmiUnderModel model = (WmiUnderModel)this.getModel();
            WmiModel centerModel = model.getChild(0);
            WmiMathOperatorModel operator = WmiMathModelUtil.getEmbellishedOperator(centerModel);
            if (operator != null) {
                WmiMathOperatorModel.WmiMathOperatorAttributeSet opAttrs = (WmiMathOperatorModel.WmiMathOperatorAttributeSet)operator.getAttributesForRead();
                if (opAttrs.hasMovableLimits()) {
                    layoutAsSubscript = true;
                }
                boolean displayStyle = false;
                if (layoutAsSubscript && !displayStyle) {
                    layoutAsSubscript = false;
                }
            }
            center.setVerticalOffset(0);
            int centerHeight = center.getHeight();
            this.width = center.getWidth();
            if (!layoutAsSubscript) {
                if (!(center instanceof WmiMathPaddedView)) {
                    int adjust;
                    if (center instanceof WmiAdjustableTextBounds && center.getWidth() > 0 && (adjust = ((WmiAdjustableTextBounds)((Object)center)).computeSpaceBelow()) > 1) {
                        centerHeight -= adjust - 1;
                    }
                    if (under instanceof WmiAdjustableTextBounds && under.getWidth() > 0 && (adjust = ((WmiAdjustableTextBounds)((Object)under)).computeSpaceAbove()) > 1) {
                        centerHeight -= adjust - 1;
                    }
                }
                under.setVerticalOffset(centerHeight);
                this.width = under.getWidth() > this.width ? under.getWidth() : this.width;
                center.setHorizontalOffset(this.width / 2 - center.getWidth() / 2);
                under.setHorizontalOffset(this.width / 2 - under.getWidth() / 2);
                this.height = centerHeight + under.getHeight();
            } else {
                int subscriptWidth = under.getWidth();
                int hoffs = center.getWidth();
                under.setHorizontalOffset(hoffs);
                WmiFontMetrics metrics = WmiViewUtil.getFontMetrics(this);
                int subsVoffs = WmiSubscriptView.getSubscriptVOffset(this, center, under, metrics);
                under.setVerticalOffset(subsVoffs);
                this.height = subsVoffs + under.getHeight();
                this.width = hoffs + subscriptWidth;
            }
            if (under.getWidth() > center.getWidth()) {
                if (WmiHorizontalStretchyRenderer.isStretchyOperator(centerModel)) {
                    center.setWidth(under.getWidth());
                }
                int offset = (under.getWidth() - center.getWidth()) / 2;
                center.setHorizontalOffset(offset);
            }
            this.baseline = center.getBaseline();
            this.addNavigationLinks();
        }
    }

    @Override
    public void addNavigationLinks() {
        WmiPositionedView base = (WmiPositionedView)this.getChild(0);
        WmiPositionedView under = (WmiPositionedView)this.getChild(1);
        if (base != null) {
            base.setNextView(under, 1);
            under.setNextView(base, 0);
            this.setNextView(base, -2);
            this.setNextView(under, -1);
            this.setNextView(base, -4);
            this.setNextView(base, -3);
        }
    }

    @Override
    public WmiPositionedView getViewForNavigation(int location, Point pt) {
        WmiPositionedView view = this.getNextView(location);
        if (view == null) {
            return this.getNearestChildView(pt);
        }
        return view;
    }

    @Override
    public int getNearestSearchRule() {
        return 1;
    }
}

