/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.linebreaker;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiLinebrokenView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.math.WmiMathIdentifierView;
import com.maplesoft.mathdoc.view.math.WmiMathTextView;
import com.maplesoft.mathdoc.view.math.WmiUnderOverView;
import com.maplesoft.mathdoc.view.math.linebreaker.WmiForceBreakSet;
import com.maplesoft.mathdoc.view.math.linebreaker.WmiSpecialFunctionLineBreaker;

public abstract class WmiCentralGlyphLineBreaker
extends WmiSpecialFunctionLineBreaker {
    private static int UNDER_OVER = 0;
    private static int FUNCTION = 2;
    private static final int UNDER_INDEX = 1;
    private static final int OVER_INDEX = 2;
    private static final int INLINE_NORMAL_LENGTH = 3;

    @Override
    public void linebreak(WmiLinebrokenView target, WmiView source, WmiForceBreakSet forceSet, int widthHint, boolean forceLine) throws WmiNoReadAccessException {
        if (this.keepOnLine(target, source, forceSet, widthHint)) {
            this.addChild(target, source);
        } else if (source instanceof WmiInlineView) {
            WmiInlineView oldInline = (WmiInlineView)source;
            WmiSpecialFunctionLineBreaker.WmiSpecialFunctionList views = new WmiSpecialFunctionLineBreaker.WmiSpecialFunctionList();
            if (oldInline.getChildCount() == 3 && oldInline.getChild(UNDER_OVER) instanceof WmiUnderOverView && oldInline.getChild(FUNCTION) instanceof WmiPositionedView) {
                WmiUnderOverView underOver = (WmiUnderOverView)oldInline.getChild(UNDER_OVER);
                WmiPositionedView funcView = (WmiPositionedView)oldInline.getChild(FUNCTION);
                views = this.keepOnLine(target, underOver, forceSet, widthHint) ? this.buildPreserveOverUnder(underOver, funcView) : this.buildFlatViewList(underOver, funcView);
            }
            if (views.size() > 0) {
                this.addViewsToTarget(views, target, forceSet, widthHint, forceLine);
            } else {
                this.addChild(target, source);
            }
        }
    }

    private WmiSpecialFunctionLineBreaker.WmiSpecialFunctionList buildPreserveOverUnder(WmiUnderOverView underOver, WmiPositionedView funcView) {
        WmiSpecialFunctionLineBreaker.WmiSpecialFunctionList views = new WmiSpecialFunctionLineBreaker.WmiSpecialFunctionList();
        views.add(underOver, false);
        views.add(funcView, false);
        return views;
    }

    private WmiSpecialFunctionLineBreaker.WmiSpecialFunctionList buildFlatViewList(WmiUnderOverView underOver, WmiPositionedView function) throws WmiNoReadAccessException {
        WmiSpecialFunctionLineBreaker.WmiSpecialFunctionList views = new WmiSpecialFunctionLineBreaker.WmiSpecialFunctionList();
        WmiPositionedView under = (WmiPositionedView)underOver.getChild(1);
        WmiPositionedView over = (WmiPositionedView)underOver.getChild(2);
        int stretchHeight = Math.max(Math.max(under.getHeight(), over.getHeight()), function.getHeight());
        WmiCompositeModel attrsSrc = WmiModelUtil.findAncestorOfTag(underOver.getModel(), WmiModelTag.MATH);
        WmiMathContext context = null;
        if (attrsSrc != null && attrsSrc.getAttributes() instanceof WmiFontAttributeSet) {
            context = new WmiMathContext((WmiFontAttributeSet)attrsSrc.getAttributes());
        }
        WmiMathTextView temp = null;
        if (context == null) {
            temp = this.constructMathOperatorView(this.getOperatorText(), 0, over);
        } else {
            WmiIdentifierModel idModel = new WmiIdentifierModel(attrsSrc.getDocument(), this.getOperatorText(), this.getOperatorText(), context, false);
            temp = new WmiMathIdentifierView(idModel, under.getDocumentView());
        }
        views.add(temp, true);
        temp = this.constructMathOperatorView("(", stretchHeight, function);
        views.add(temp, true);
        views.add(function, false);
        temp = this.constructMathOperatorView(",", 0, over);
        views.add(temp, true);
        views.add(under, false);
        temp = this.constructMathOperatorView("..", 0, over);
        views.add(temp, true);
        views.add(over, false);
        temp = this.constructMathOperatorView(")", stretchHeight, function);
        views.add(temp, true);
        return views;
    }

    public static class WmiProductLineBreaker
    extends WmiCentralGlyphLineBreaker {
        private static String OPERATOR_TEXT = "Product";

        @Override
        protected String getOperatorText() {
            return OPERATOR_TEXT;
        }
    }

    public static class WmiSumLineBreaker
    extends WmiCentralGlyphLineBreaker {
        private static String OPERATOR_TEXT = "Sum";

        @Override
        protected String getOperatorText() {
            return OPERATOR_TEXT;
        }
    }
}

