/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.linebreaker;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiLinebrokenView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.linebreaker.WmiDefaultLineBreaker;
import com.maplesoft.mathdoc.view.math.linebreaker.WmiForceBreakSet;
import java.util.Vector;

public abstract class WmiSpecialFunctionLineBreaker
extends WmiDefaultLineBreaker {
    protected abstract String getOperatorText();

    protected WmiMathOperatorView constructMathOperatorView(String symbol, int stretchHeight, WmiPositionedView base) throws WmiNoReadAccessException {
        WmiMathTokenModel operator = null;
        WmiMathOperatorView opView = null;
        WmiMathDocumentView docView = base.getDocumentView();
        WmiMathDocumentModel docModel = docView.getModel().getDocument();
        WmiMathContext context = this.manufactureContext(base);
        operator = WmiMathFactory.createMathOperatorToken(docModel, symbol, context);
        opView = new WmiMathOperatorView(operator, docView);
        opView.setHeight(stretchHeight);
        opView.setStretchHeight(stretchHeight);
        return opView;
    }

    protected WmiMathContext manufactureContext(WmiView view) throws WmiNoReadAccessException {
        WmiMathContext context = null;
        WmiModel model = view.getModel();
        while (model instanceof WmiCompositeModel) {
            if (((WmiCompositeModel)model).getChildCount() <= 0) break;
            model = ((WmiCompositeModel)model).getChild(0);
        }
        WmiAttributeSet attrs = model.getAttributes();
        WmiMathAttributeSet mattr = new WmiMathAttributeSet();
        mattr.addAttributes(attrs);
        mattr.addAttribute("italic", "false");
        context = new WmiMathContext(mattr);
        return context;
    }

    protected void addViewsToTarget(WmiSpecialFunctionList views, WmiLinebrokenView target, WmiForceBreakSet forceSet, int widthHint, boolean forceLine) throws WmiNoReadAccessException {
        if (views != null) {
            int i = 0;
            while (i < views.size()) {
                if (views.getView(i) != null) {
                    if (views.isCreatedHere(i)) {
                        views.getView(i).layoutView();
                    }
                    if (this.keepOnLine(target, views.getView(i), forceSet, widthHint)) {
                        this.addChild(target, views.getView(i));
                    } else {
                        if (views.isCreatedHere(i) || !(views.getView(i) instanceof WmiCompositeView)) {
                            this.finishCurrentRow(target, forceSet);
                            this.createNewRow(target);
                        }
                        WmiSpecialFunctionLineBreaker.nextLinebreak(target, views.getView(i), forceSet, widthHint, true);
                    }
                }
                ++i;
            }
        }
    }

    private static final class WmiSpecialFunctionElementWrapper {
        private WmiPositionedView view;
        private boolean createdHere;

        private WmiSpecialFunctionElementWrapper(WmiPositionedView view, boolean createdHere) {
            this.view = view;
            this.createdHere = createdHere;
        }

        private boolean isCreatedHere() {
            return this.createdHere;
        }

        private WmiPositionedView getView() {
            return this.view;
        }

        public String toString() {
            return "{" + this.view + "|" + this.createdHere + "}";
        }
    }

    protected static class WmiSpecialFunctionList {
        private Vector data = new Vector();

        protected WmiSpecialFunctionList() {
        }

        public void add(WmiPositionedView view, boolean createdHere) {
            this.data.addElement(new WmiSpecialFunctionElementWrapper(view, createdHere));
        }

        public void remove(int index) {
            this.data.removeElementAt(index);
        }

        public void clear() {
            this.data.clear();
        }

        public WmiPositionedView getView(int index) {
            if (this.data.elementAt(index) instanceof WmiSpecialFunctionElementWrapper) {
                WmiSpecialFunctionElementWrapper element = (WmiSpecialFunctionElementWrapper)this.data.elementAt(index);
                return element.getView();
            }
            return null;
        }

        public boolean isCreatedHere(int index) {
            if (this.data.elementAt(index) instanceof WmiSpecialFunctionElementWrapper) {
                WmiSpecialFunctionElementWrapper element = (WmiSpecialFunctionElementWrapper)this.data.elementAt(index);
                return element.isCreatedHere();
            }
            return false;
        }

        public int size() {
            return this.data.size();
        }
    }
}

