/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.renderers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class WmiGlyphBuilder
extends JDialog {
    private static final String[] QUAD_TYPE_TABLE = new String[]{"MOVE_UP", "MOVE_FIXED_UP", "MOVE_DOWN_UP", "ERROR", "MOVE_UP_FIXED", "FIXED_POS", "MOVE_DOWN_FIXED", "ERROR", "MOVE_UP_DOWN", "MOVE_FIXED_DOWN", "MOVE_DOWN"};
    private static final String[] HORIZ_QUAD_TYPE_TABLE = new String[]{"MOVE_LEFT", "MOVE_FIXED_LEFT", "MOVE_RIGHT_LEFT", "ERROR", "MOVE_LEFT_FIXED", "FIXED_POS", "MOVE_RIGHT_FIXED", "ERROR", "MOVE_LEFT_RIGHT", "MOVE_FIXED_RIGHT", "MOVE_RIGHT"};
    JTextField fontField;
    JTextField glyphField;
    JTextField stretchUpField;
    JTextField stretchDownField;
    JTextField stretchLeftField;
    JTextField stretchRightField;
    GlyphRenderPane renderer;
    JButton loadButton;
    JButton updateButton;
    JButton codeButton;
    Rectangle2D.Float bounds;
    ArrayList glyphOutline = new ArrayList();

    public WmiGlyphBuilder() {
        Container contents = this.getContentPane();
        contents.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        JPanel row1 = new JPanel();
        JPanel row2 = new JPanel();
        row1.setLayout(new FlowLayout());
        row2.setLayout(new FlowLayout());
        topPanel.add((Component)row1, "North");
        topPanel.add((Component)row2, "South");
        row1.add(new JLabel("font"));
        this.fontField = new JTextField(30);
        this.fontField.setText("ESSTIXSix");
        row1.add(this.fontField);
        row1.add(new JLabel("Character"));
        this.glyphField = new JTextField(5);
        this.glyphField.setText("E");
        row1.add(this.glyphField);
        this.loadButton = new JButton("Load");
        row1.add(this.loadButton);
        row2.add(new JLabel("Stretch up "));
        this.stretchUpField = new JTextField(6);
        this.stretchUpField.setText("0");
        row2.add(this.stretchUpField);
        row2.add(new JLabel("Stretch down "));
        this.stretchDownField = new JTextField(6);
        this.stretchDownField.setText("1");
        row2.add(this.stretchDownField);
        row2.add(new JLabel("Stretch left "));
        this.stretchLeftField = new JTextField(6);
        this.stretchLeftField.setText("0");
        row2.add(this.stretchLeftField);
        row2.add(new JLabel("Stretch right "));
        this.stretchRightField = new JTextField(6);
        this.stretchRightField.setText("1");
        row2.add(this.stretchRightField);
        this.updateButton = new JButton("Update");
        row2.add(this.updateButton);
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WmiGlyphBuilder.this.loadGlyph(WmiGlyphBuilder.this.fontField.getText(), WmiGlyphBuilder.this.glyphField.getText());
            }
        });
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WmiGlyphBuilder.this.repaint();
            }
        });
        this.codeButton = new JButton("Generate Code");
        this.codeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WmiGlyphBuilder.this.generateCode();
            }
        });
        row2.add(this.codeButton);
        contents.add((Component)topPanel, "North");
        this.renderer = new GlyphRenderPane();
        contents.add((Component)this.renderer, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.pack();
        this.show();
    }

    public void loadGlyph(String fontName, String contents) {
        Font f = new Font(fontName, 0, 1);
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
        GlyphVector v = f.createGlyphVector(frc, contents);
        Shape s = v.getGlyphOutline(0);
        PathIterator it = s.getPathIterator(new AffineTransform());
        float[] coords = new float[6];
        this.glyphOutline.clear();
        while (!it.isDone()) {
            float[] segment;
            Arrays.fill(coords, 0.0f);
            int type = it.currentSegment(coords);
            switch (type) {
                case 0: 
                case 1: {
                    segment = new float[2];
                    System.arraycopy(coords, 0, segment, 0, 2);
                    break;
                }
                case 2: {
                    segment = new float[4];
                    System.arraycopy(coords, 0, segment, 0, 4);
                    break;
                }
                case 3: {
                    segment = new float[6];
                    System.arraycopy(coords, 0, segment, 0, 6);
                    break;
                }
                default: {
                    segment = new float[]{};
                }
            }
            this.glyphOutline.add(segment);
            it.next();
        }
        this.updateBounds();
    }

    public void updateBounds() {
        boolean init = false;
        int size = this.glyphOutline.size();
        float xmin = 0.0f;
        float xmax = 0.0f;
        float ymin = 0.0f;
        float ymax = 0.0f;
        int i = 0;
        while (i < size) {
            float[] segment = (float[])this.glyphOutline.get(i);
            int segLength = segment.length;
            int j = 0;
            while (j < segLength) {
                float x = segment[j];
                float y = segment[j + 1];
                if (init) {
                    if (x < xmin) {
                        xmin = x;
                    } else if (x > xmax) {
                        xmax = x;
                    }
                    if (y < ymin) {
                        ymin = y;
                    } else if (y > ymax) {
                        ymax = y;
                    }
                } else {
                    xmin = xmax = x;
                    ymin = ymax = y;
                    init = true;
                }
                j += 2;
            }
            ++i;
        }
        this.bounds = new Rectangle2D.Float(xmin, ymin, xmax - xmin, ymax - ymin);
        System.out.println("xmin = " + xmin);
        System.out.println("xmax = " + xmax);
        System.out.println("ymin = " + ymin);
        System.out.println("ymax = " + ymax);
        this.repaint();
    }

    public void generateCode() {
        if (this.bounds != null && this.glyphOutline.size() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("private static final float[][] OUTLINE = {\n");
            float scale = this.bounds.height > this.bounds.width ? 1.0f / this.bounds.height : 1.0f / this.bounds.width;
            float xmin = this.bounds.x;
            float ymin = this.bounds.y;
            float stretchUpLine = Float.parseFloat(this.stretchUpField.getText());
            float stretchDownLine = Float.parseFloat(this.stretchDownField.getText());
            float stretchLeftLine = Float.parseFloat(this.stretchLeftField.getText());
            float stretchRightLine = Float.parseFloat(this.stretchRightField.getText());
            int size = this.glyphOutline.size();
            String[] types = new String[size];
            int i = 0;
            while (i < size) {
                float[] segment = (float[])this.glyphOutline.get(i);
                int segLength = segment.length;
                int index = 0;
                switch (segLength) {
                    case 2: {
                        float x1 = scale * (segment[0] - xmin);
                        float y1 = scale * (segment[1] - ymin);
                        sb.append("    {");
                        sb.append(x1);
                        sb.append("f, ");
                        sb.append(y1);
                        if (i < size - 1) {
                            sb.append("f}, //");
                        } else {
                            sb.append("f} //");
                        }
                        sb.append(i);
                        sb.append("\n");
                        if (stretchUpLine > 0.0f) {
                            if (y1 < stretchUpLine) {
                                types[i] = "MOVE_UP";
                                break;
                            }
                            if (y1 > stretchDownLine) {
                                types[i] = "MOVE_DOWN";
                                break;
                            }
                            types[i] = "FIXED_POS";
                            break;
                        }
                        if (x1 < stretchLeftLine) {
                            types[i] = "MOVE_LEFT";
                            break;
                        }
                        if (x1 > stretchRightLine) {
                            types[i] = "MOVE_RIGHT";
                            break;
                        }
                        types[i] = "FIXED_POS";
                        break;
                    }
                    case 4: {
                        float x1 = scale * (segment[0] - xmin);
                        float y1 = scale * (segment[1] - ymin);
                        float x2 = scale * (segment[2] - xmin);
                        float y2 = scale * (segment[3] - ymin);
                        sb.append("    {");
                        sb.append(x1);
                        sb.append("f, ");
                        sb.append(y1);
                        sb.append("f, ");
                        sb.append(x2);
                        sb.append("f, ");
                        sb.append(y2);
                        if (i < size - 1) {
                            sb.append("f}, //");
                        } else {
                            sb.append("f} //");
                        }
                        sb.append(i);
                        sb.append("\n");
                        if (stretchUpLine > 0.0f) {
                            if (y1 > stretchDownLine) {
                                index += 2;
                            } else if (y1 > stretchUpLine) {
                                ++index;
                            }
                            if (y2 > stretchDownLine) {
                                index += 8;
                            } else if (y2 > stretchUpLine) {
                                index += 4;
                            }
                            types[i] = QUAD_TYPE_TABLE[index];
                            break;
                        }
                        if (x1 > stretchRightLine) {
                            index += 2;
                        } else if (x1 > stretchLeftLine) {
                            ++index;
                        }
                        if (x2 > stretchRightLine) {
                            index += 8;
                        } else if (x2 > stretchLeftLine) {
                            index += 4;
                        }
                        types[i] = HORIZ_QUAD_TYPE_TABLE[index];
                        break;
                    }
                    case 6: {
                        sb.append("    {");
                        float x1 = scale * (segment[0] - xmin);
                        float y1 = scale * (segment[1] - ymin);
                        float x2 = scale * (segment[2] - xmin);
                        float y2 = scale * (segment[3] - ymin);
                        float x3 = scale * (segment[4] - xmin);
                        float y3 = scale * (segment[5] - ymin);
                        sb.append(x1);
                        sb.append("f, ");
                        sb.append(y1);
                        sb.append("f, ");
                        sb.append(x2);
                        sb.append("f, ");
                        sb.append(y2);
                        sb.append("f, ");
                        sb.append(x3);
                        sb.append("f, ");
                        sb.append(y3);
                        if (i < size - 1) {
                            sb.append("f}, //");
                        } else {
                            sb.append("f} //");
                        }
                        this.pack();
                        this.show();
                        sb.append(i);
                        sb.append("\n");
                        types[i] = "ERROR";
                        break;
                    }
                    default: {
                        if (i < size - 1) {
                            sb.append("    {}, //");
                        } else {
                            sb.append("    {} //");
                        }
                        sb.append(i);
                        sb.append("\n");
                        types[i] = "FIXED_POS";
                    }
                }
                ++i;
            }
            sb.append("};\n\nprivate static final int[] MORPH_RULES = {\n");
            i = 0;
            while (i < size) {
                if (types[i].length() > 0) {
                    sb.append("    ");
                    sb.append(types[i]);
                    if (i < size - 1) {
                        sb.append(", // ");
                    } else {
                        sb.append(" //");
                    }
                    sb.append(i);
                    sb.append("\n");
                }
                ++i;
            }
            sb.append("};\n");
            new CodeDialog(sb.toString());
        }
    }

    public static void main(String[] args) {
        new WmiGlyphBuilder();
    }

    public class CodeDialog
    extends JDialog {
        public CodeDialog(String contents) {
            Container pane = this.getContentPane();
            JScrollPane scroller = new JScrollPane();
            pane.add(scroller);
            JTextArea area = new JTextArea(100, 80);
            area.setText(contents);
            scroller.getViewport().add(area);
            this.pack();
            this.show();
        }
    }

    public class GlyphRenderPane
    extends JPanel {
        private static final int WINDOW_SIZE = 500;
        private static final int DRAW_SIZE = 450;

        public GlyphRenderPane() {
            this.setBackground(Color.WHITE);
            Dimension size = new Dimension(500, 500);
            this.setMinimumSize(size);
            this.setMaximumSize(size);
            this.setPreferredSize(size);
            this.setBorder(BorderFactory.createEtchedBorder());
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            Color saveColor = g.getColor();
            if (WmiGlyphBuilder.this.bounds != null && WmiGlyphBuilder.this.glyphOutline.size() > 0) {
                float hw = WmiGlyphBuilder.this.bounds.height > WmiGlyphBuilder.this.bounds.width ? WmiGlyphBuilder.this.bounds.height : WmiGlyphBuilder.this.bounds.width;
                float scale = 450.0f / hw;
                float xpad = 0.5f * (500.0f - scale * WmiGlyphBuilder.this.bounds.width);
                float ypad = 0.5f * (500.0f - scale * WmiGlyphBuilder.this.bounds.height);
                float xmin = WmiGlyphBuilder.this.bounds.x;
                float ymin = WmiGlyphBuilder.this.bounds.y;
                g.setColor(Color.GREEN);
                float stretchUpLine = Float.parseFloat(WmiGlyphBuilder.this.stretchUpField.getText());
                float stretchDownLine = Float.parseFloat(WmiGlyphBuilder.this.stretchDownField.getText());
                float stretchLeftLine = Float.parseFloat(WmiGlyphBuilder.this.stretchLeftField.getText());
                float stretchRightLine = Float.parseFloat(WmiGlyphBuilder.this.stretchRightField.getText());
                float topLine = scale * hw * stretchUpLine + ypad;
                float bottomLine = scale * hw * stretchDownLine + ypad;
                float leftLine = scale * hw * stretchLeftLine + xpad;
                float rightLine = scale * hw * stretchRightLine + xpad;
                g2.draw(new Line2D.Float(0.0f, topLine, 500.0f, topLine));
                g2.draw(new Line2D.Float(0.0f, bottomLine, 500.0f, bottomLine));
                g2.draw(new Line2D.Float(leftLine, 0.0f, leftLine, 500.0f));
                g2.draw(new Line2D.Float(rightLine, 0.0f, rightLine, 500.0f));
                g.setColor(Color.BLUE);
                GeneralPath gp = new GeneralPath();
                GeneralPath gpLine = new GeneralPath();
                boolean doMove = true;
                int size = WmiGlyphBuilder.this.glyphOutline.size();
                int i = 0;
                while (i < size) {
                    float[] segment = (float[])WmiGlyphBuilder.this.glyphOutline.get(i);
                    int segLength = segment.length;
                    switch (segLength) {
                        case 2: {
                            float y1;
                            float x1;
                            if (doMove) {
                                x1 = xpad + scale * (segment[0] - xmin);
                                y1 = ypad + scale * (segment[1] - ymin);
                                gp.moveTo(x1, y1);
                                gpLine.moveTo(x1, y1);
                                this.drawRect(g2, x1, y1, true, i);
                                doMove = false;
                                break;
                            }
                            x1 = xpad + scale * (segment[0] - xmin);
                            y1 = ypad + scale * (segment[1] - ymin);
                            gp.lineTo(x1, y1);
                            gpLine.lineTo(x1, y1);
                            this.drawRect(g2, x1, y1, true, i);
                            break;
                        }
                        case 4: {
                            float x1 = xpad + scale * (segment[0] - xmin);
                            float y1 = ypad + scale * (segment[1] - ymin);
                            float x2 = xpad + scale * (segment[2] - xmin);
                            float y2 = ypad + scale * (segment[3] - ymin);
                            gp.quadTo(x1, y1, x2, y2);
                            gpLine.lineTo(x1, y1);
                            gpLine.lineTo(x2, y2);
                            this.drawRect(g2, x1, y1, false, i);
                            this.drawRect(g2, x2, y2, true, i);
                            break;
                        }
                        case 6: {
                            float x1 = xpad + scale * (segment[0] - xmin);
                            float y1 = ypad + scale * (segment[1] - ymin);
                            float x2 = xpad + scale * (segment[2] - xmin);
                            float y2 = ypad + scale * (segment[3] - ymin);
                            float x3 = xpad + scale * (segment[4] - xmin);
                            float y3 = ypad + scale * (segment[5] - ymin);
                            gp.curveTo(x1, y1, x2, y2, x3, y3);
                            gpLine.lineTo(x1, y1);
                            gpLine.lineTo(x2, y2);
                            gpLine.lineTo(x3, y3);
                            this.drawRect(g2, x1, y1, false, i);
                            this.drawRect(g2, x2, y2, false, i);
                            this.drawRect(g2, x3, y3, true, i);
                            break;
                        }
                        default: {
                            gp.closePath();
                            gpLine.closePath();
                            doMove = true;
                        }
                    }
                    ++i;
                }
                ((Graphics2D)g).draw(gpLine);
                g.setColor(Color.BLACK);
                ((Graphics2D)g).draw(gp);
                g.setColor(saveColor);
            }
        }

        private void drawRect(Graphics2D g, float x, float y, boolean fill, int num) {
            Rectangle2D.Float s = new Rectangle2D.Float(x - 2.0f, y - 2.0f, 4.0f, 4.0f);
            if (fill) {
                g.fill(s);
            } else {
                g.draw(s);
            }
            g.drawString(Integer.toString(num), x + 4.0f, y + 4.0f);
        }
    }
}

