/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.renderers;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiTextLayout;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.renderers.WmiAbstractOperatorRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;

public abstract class WmiGlyphRenderer
extends WmiAbstractOperatorRenderer {
    protected static final int FIXED_POS = 0;
    protected static final int MOVE_UP = 1;
    protected static final int STRETCH_UP = 2;
    protected static final int MOVE_FIXED_UP = 2;
    protected static final int MOVE_DOWN = 3;
    protected static final int STRETCH_DOWN = 4;
    protected static final int MOVE_FIXED_DOWN = 4;
    protected static final int MOVE_UP_DOWN = 5;
    protected static final int MOVE_UP_FIXED = 6;
    protected static final int MOVE_DOWN_FIXED = 7;
    protected static final int MOVE_LEFT = 8;
    protected static final int MOVE_RIGHT = 9;
    protected static final int MOVE_UPHALF = 10;
    protected static final int MOVE_RIGHT_FIXED = 11;
    protected static final int MOVE_LEFT_FIXED = 12;
    protected static final int MOVE_FIXED_RIGHT = 13;
    protected static final int MOVE_FIXED_LEFT = 14;
    protected static final int MOVE_RIGHT_LEFT = 15;
    protected static final int MOVE_LEFT_LEFT_FIXED = 16;
    protected static final int MOVE_FIXED_RIGHT_RIGHT = 17;
    protected static final int MOVE_FIXED_LEFT_LEFT = 18;
    protected static final int MOVE_RIGHT_RIGHT_FIXED = 19;
    protected static final int MOVE_RIGHT_RIGHT_RIGHT = 20;
    protected static final int MOVE_LEFT_LEFT_LEFT = 21;
    protected static final int MOVE_LEFTHALF = 22;
    protected static final int MOVE_UPRIGHT = 23;
    private static final float BRACKET_SHIFT_FACTOR = 0.25f;
    protected GlyphCache cache = new GlyphCache();

    protected int getStretchySize(WmiPositionedView source) {
        return source.getHeight();
    }

    protected boolean isBracket() {
        return false;
    }

    protected float getBracketShiftFactor() {
        return 0.25f;
    }

    public RenderedGlyph createGlyph(Font font, int size) {
        float[][] source = this.getGlyphOutline();
        float[][] clone = new float[source.length][];
        int i = 0;
        while (i < source.length) {
            float[] segment = source[i];
            clone[i] = new float[segment.length];
            System.arraycopy(segment, 0, clone[i], 0, segment.length);
            ++i;
        }
        this.morphGlyph(clone, font, size);
        return new RenderedGlyph(clone);
    }

    protected abstract float[][] getGlyphOutline();

    protected void morphGlyph(float[][] data, Font f, int size) {
    }

    protected int[] getStretchRules() {
        return null;
    }

    protected void uniformScale(float[][] data, float scale) {
        int i = 0;
        while (i < data.length) {
            float[] segment = data[i];
            int j = 0;
            while (j < segment.length) {
                float[] fArray = data[i];
                int n = j++;
                fArray[n] = fArray[n] * scale;
            }
            ++i;
        }
    }

    protected void nonuniformScale(float[][] data, float scaleX, float scaleY) {
        int i = 0;
        while (i < data.length) {
            float[] segment = data[i];
            int j = 0;
            while (j < segment.length) {
                float[] fArray = data[i];
                int n = j;
                fArray[n] = fArray[n] * scaleX;
                float[] fArray2 = data[i];
                int n2 = j + 1;
                fArray2[n2] = fArray2[n2] * scaleY;
                j += 2;
            }
            ++i;
        }
    }

    protected void horizontalReflection(float[][] data) {
        float reference = 0.0f;
        int i = 0;
        while (i < data.length) {
            float[] segment = data[i];
            int j = 0;
            while (j < segment.length) {
                if (reference < data[i][j]) {
                    reference = data[i][j];
                }
                j += 2;
            }
            ++i;
        }
        int segments = data.length;
        int i2 = 0;
        while (i2 < segments) {
            float[] segment = data[i2];
            int segmentSize = segment.length;
            int j = 0;
            while (j < segmentSize) {
                segment[j] = reference - segment[j];
                j += 2;
            }
            ++i2;
        }
    }

    protected float[] findBounds(float[][] data) {
        float xReference = 0.0f;
        float yReference = 0.0f;
        int segments = data.length;
        int i = 0;
        while (i < segments) {
            float[] segment = data[i];
            int j = 0;
            while (j < segment.length) {
                if (xReference < segment[j]) {
                    xReference = segment[j];
                }
                if (yReference < segment[j + 1]) {
                    yReference = segment[j + 1];
                }
                j += 2;
            }
            ++i;
        }
        float[] result = new float[]{xReference, yReference};
        return result;
    }

    protected void rotate180(float[][] data) {
        float[] bounds = this.findBounds(data);
        float xReference = bounds[0];
        float yReference = bounds[1];
        int segments = data.length;
        int i = 0;
        while (i < segments) {
            float[] segment = data[i];
            int segmentSize = segment.length;
            int j = 0;
            while (j < segmentSize) {
                segment[j] = xReference - segment[j];
                segment[j + 1] = yReference - segment[j + 1];
                j += 2;
            }
            ++i;
        }
    }

    protected void verticalReflection(float[][] data) {
        int j;
        float[] segment;
        float reference = 0.0f;
        int i = 0;
        while (i < data.length) {
            segment = data[i];
            j = 0;
            while (j < segment.length) {
                if (reference < data[i][j + 1]) {
                    reference = data[i][j + 1];
                }
                j += 2;
            }
            ++i;
        }
        i = 0;
        while (i < data.length) {
            segment = data[i];
            j = 0;
            while (j < segment.length) {
                data[i][j + 1] = reference - data[i][j + 1];
                j += 2;
            }
            ++i;
        }
    }

    protected void xyReflection(float[][] data) {
        int i = 0;
        while (i < data.length) {
            float[] segment = data[i];
            int j = 0;
            while (j < segment.length) {
                float temp = segment[j];
                segment[j] = segment[j + 1];
                segment[j + 1] = temp;
                j += 2;
            }
            ++i;
        }
    }

    protected void rotate90AboutCenter(float[][] data) {
        float[] bounds = this.findBounds(data);
        float xReference = bounds[0] / 2.0f;
        float yReference = bounds[1] / 2.0f;
        int i = 0;
        while (i < data.length) {
            float[] segment = data[i];
            int j = 0;
            while (j < segment.length) {
                float temp = segment[j];
                segment[j] = xReference + yReference - segment[j + 1];
                segment[j + 1] = temp - xReference + yReference;
                j += 2;
            }
            ++i;
        }
    }

    protected void rotate90(float[][] data) {
        int i = 0;
        while (i < data.length) {
            float[] segment = data[i];
            int j = 0;
            while (j < segment.length) {
                float temp = segment[j];
                segment[j] = 1.0f - segment[j + 1];
                segment[j + 1] = temp;
                j += 2;
            }
            ++i;
        }
    }

    protected void stretchScale(float[][] data, float uniformScale, float stretchScale, int[] rules) {
        int j;
        float[] segment;
        this.uniformScale(data, uniformScale);
        float shift = 0.5f * (stretchScale - uniformScale);
        int i = 0;
        while (i < data.length) {
            float[] segment2 = data[i];
            switch (rules[i]) {
                case 1: {
                    int j2 = 0;
                    while (j2 < segment2.length) {
                        int n = j2 + 1;
                        segment2[n] = segment2[n] - shift;
                        j2 += 2;
                    }
                    break;
                }
                case 2: {
                    segment2[3] = segment2[3] - shift;
                    break;
                }
                case 6: {
                    segment2[1] = segment2[1] - shift;
                    break;
                }
                case 3: {
                    int j2 = 0;
                    while (j2 < segment2.length) {
                        int n = j2 + 1;
                        segment2[n] = segment2[n] + shift;
                        j2 += 2;
                    }
                    break;
                }
                case 7: {
                    segment2[1] = segment2[1] + shift;
                    break;
                }
                case 4: {
                    segment2[3] = segment2[3] + shift;
                    break;
                }
                case 5: {
                    segment2[1] = segment2[1] - shift;
                    segment2[3] = segment2[3] + shift;
                    break;
                }
                case 8: {
                    int j2 = 0;
                    while (j2 < segment2.length) {
                        int n = j2;
                        segment2[n] = segment2[n] - shift;
                        j2 += 2;
                    }
                    break;
                }
                case 9: {
                    int j2 = 0;
                    while (j2 < segment2.length) {
                        int n = j2;
                        segment2[n] = segment2[n] + shift;
                        j2 += 2;
                    }
                    break;
                }
                case 10: {
                    int j2 = 0;
                    while (j2 < segment2.length) {
                        int n = j2 + 1;
                        segment2[n] = (float)((double)segment2[n] - Math.min(0.15 * (double)shift, 0.5 * (double)uniformScale));
                        j2 += 2;
                    }
                    break;
                }
                case 11: {
                    segment2[0] = segment2[0] + shift;
                    break;
                }
                case 12: {
                    segment2[0] = segment2[0] - shift;
                    break;
                }
                case 13: {
                    segment2[2] = segment2[2] + shift;
                    break;
                }
                case 14: {
                    segment2[2] = segment2[2] - shift;
                    break;
                }
                case 15: {
                    segment2[0] = segment2[0] + shift;
                    segment2[2] = segment2[2] - shift;
                    break;
                }
                case 16: {
                    segment2[0] = segment2[0] - shift;
                    segment2[2] = segment2[2] - shift;
                    break;
                }
                case 17: {
                    segment2[2] = segment2[2] + shift;
                    segment2[4] = segment2[4] + shift;
                    break;
                }
                case 18: {
                    segment2[2] = segment2[2] - shift;
                    segment2[4] = segment2[4] - shift;
                    break;
                }
                case 19: {
                    segment2[0] = segment2[0] + shift;
                    segment2[2] = segment2[2] + shift;
                    break;
                }
                case 21: {
                    segment2[0] = segment2[0] - shift;
                    segment2[2] = segment2[2] - shift;
                    segment2[4] = segment2[4] - shift;
                    break;
                }
                case 20: {
                    segment2[0] = segment2[0] + shift;
                    segment2[2] = segment2[2] + shift;
                    segment2[4] = segment2[4] + shift;
                    break;
                }
                case 22: {
                    int j2 = 0;
                    while (j2 < segment2.length) {
                        int n = j2;
                        segment2[n] = (float)((double)segment2[n] - Math.min(0.15 * (double)shift, 0.5 * (double)uniformScale));
                        j2 += 2;
                    }
                    break;
                }
                case 23: {
                    segment2[0] = segment2[0] + shift / 2.0f;
                    segment2[1] = segment2[1] - shift;
                }
            }
            ++i;
        }
        float minX = data[0][0];
        float minY = data[0][0];
        int i2 = 0;
        while (i2 < data.length) {
            segment = data[i2];
            j = 0;
            while (j < segment.length) {
                if (segment[j] < minX) {
                    minX = segment[j];
                }
                if (segment[j + 1] < minY) {
                    minY = segment[j + 1];
                }
                j += 2;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < data.length) {
            segment = data[i2];
            j = 0;
            while (j < segment.length) {
                int n = j;
                segment[n] = segment[n] - minX;
                int n2 = j + 1;
                segment[n2] = segment[n2] - minY;
                j += 2;
            }
            ++i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutView(WmiMathOperatorView view, int height) throws WmiNoReadAccessException {
        WmiTextLayout layout = view.getLayout();
        int paddingAbove = 0;
        int paddingBelow = 0;
        Font renderFont = this.getFont(view);
        if (this.isBracket()) {
            Font font = layout.getFont();
            paddingAbove = (int)(this.getBracketShiftFactor() * font.getSize2D());
            paddingBelow = 0;
        } else {
            paddingAbove = layout.computeSpaceAbove();
            paddingBelow = layout.computeSpaceBelow();
        }
        int minHeight = layout.getHeight();
        if (height < minHeight) {
            height = minHeight;
        }
        view.setStretchHeight(height);
        view.setHeight(height);
        GlyphCache glyphCache = this.cache;
        synchronized (glyphCache) {
            RenderedGlyph glyph = this.cache.getGlyph(renderFont, height);
            if (glyph == null && (glyph = this.createGlyph(renderFont, height - paddingAbove - paddingBelow)) != null) {
                glyph.setVerticalPadding(paddingAbove, paddingBelow);
                this.cache.setGlyph(renderFont, height, glyph);
            }
            if (glyph != null) {
                Rectangle2D.Float bounds = glyph.getBounds();
                int w = Math.round(bounds.width);
                int leftPad = view.getLeftPadding();
                int rightPad = view.getRightPadding();
                view.setWidth(w + leftPad + rightPad);
                view.setStretchWidth(w + leftPad + rightPad);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics g, WmiRenderPath path, Rectangle bounds, WmiMathOperatorView view) {
        Font renderFont = this.getFont(view);
        int xOffset = path.getHorizontalOffset();
        int yOffset = path.getVerticalOffset();
        int size = this.getStretchySize(view);
        int width = view.getWidth();
        WmiFontAttributeSet attributes = view.getFontAttributes();
        boolean highlighted = path.isMidpointSelected(view);
        if (highlighted) {
            WmiMathDocumentView docView = view.getDocumentView();
            Color foreground = docView.getColor(3);
            g.setColor(foreground);
        } else {
            if (attributes.isOpaque()) {
                g.setColor(new Color(attributes.getBackground()));
                g.fillRect(xOffset + view.getHorizontalOffset(), yOffset, width, view.getHeight());
            }
            g.setColor(new Color(attributes.getForeground()));
        }
        GlyphCache glyphCache = this.cache;
        synchronized (glyphCache) {
            RenderedGlyph glyph = this.cache.getGlyph(renderFont, size);
            if (glyph == null) {
                glyph = this.createGlyph(renderFont, size);
                this.cache.setGlyph(renderFont, size, glyph);
            }
            if (glyph != null) {
                glyph.draw((Graphics2D)g, xOffset + view.getHorizontalOffset() + view.getLeftPadding(), yOffset + view.getVerticalOffset());
            } else {
                WmiErrorLog.log(new Exception("Failed to find glyph: size = " + size));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int computeSpaceAbove(WmiMathOperatorView view) {
        int above = 0;
        Font renderFont = this.getFont(view);
        int size = this.getStretchySize(view);
        GlyphCache glyphCache = this.cache;
        synchronized (glyphCache) {
            RenderedGlyph glyph = this.cache.getGlyph(renderFont, size);
            if (glyph != null) {
                above = glyph.getSpaceAbove();
            }
        }
        return above;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int computeSpaceBelow(WmiMathOperatorView view) {
        int below = 0;
        Font renderFont = this.getFont(view);
        int size = this.getStretchySize(view);
        GlyphCache glyphCache = this.cache;
        synchronized (glyphCache) {
            RenderedGlyph glyph = this.cache.getGlyph(renderFont, size);
            if (glyph != null) {
                below = glyph.getSpaceBelow();
            }
        }
        return below;
    }

    @Override
    public int computePostKernAdjustment(WmiMathOperatorView view) {
        return 0;
    }

    @Override
    public int computePreKernAdjustment(WmiMathOperatorView view) {
        return 0;
    }

    public static class GlyphCache {
        private HashMap map = new HashMap();

        public synchronized RenderedGlyph getGlyph(Font font, int size) {
            RenderedGlyph glyph = null;
            RenderedGlyph[] value = (RenderedGlyph[])this.map.get(font);
            if (value != null && size < value.length) {
                glyph = value[size];
            }
            return glyph;
        }

        public synchronized void setGlyph(Font font, int size, RenderedGlyph bracket) {
            RenderedGlyph[] glyphs = (RenderedGlyph[])this.map.get(font);
            if (glyphs == null || glyphs.length <= size) {
                int sizeMod = size == 0 ? 2 : size * 2;
                RenderedGlyph[] newValue = new RenderedGlyph[sizeMod];
                if (glyphs != null) {
                    System.arraycopy(glyphs, 0, newValue, 0, glyphs.length);
                }
                glyphs = newValue;
            }
            glyphs[size] = bracket;
            this.map.put(font, glyphs);
        }
    }

    public class RenderedGlyph {
        private GeneralPath gp;
        private Rectangle2D.Float bounds;
        private int spaceAbove = 0;
        private int spaceBelow = 0;

        public RenderedGlyph(float[][] path) {
            this.createGeneralPath(path);
        }

        private void createGeneralPath(float[][] path) {
            float xmax = 0.0f;
            float ymax = 0.0f;
            this.gp = new GeneralPath();
            boolean doMove = true;
            int i = 0;
            while (i < path.length) {
                float[] segment = path[i];
                int j = 0;
                while (j != segment.length) {
                    float x = segment[j];
                    float y = segment[j + 1];
                    if (x > xmax) {
                        xmax = x;
                    }
                    if (y > ymax) {
                        ymax = y;
                    }
                    j += 2;
                }
                if (doMove) {
                    this.gp.moveTo(segment[0], segment[1]);
                    doMove = false;
                } else {
                    switch (segment.length) {
                        case 2: {
                            this.gp.lineTo(segment[0], segment[1]);
                            break;
                        }
                        case 4: {
                            this.gp.quadTo(segment[0], segment[1], segment[2], segment[3]);
                            break;
                        }
                        case 6: {
                            this.gp.curveTo(segment[0], segment[1], segment[2], segment[3], segment[4], segment[5]);
                            break;
                        }
                        default: {
                            this.gp.closePath();
                            doMove = true;
                        }
                    }
                }
                ++i;
            }
            this.bounds = new Rectangle2D.Float(0.0f, 0.0f, xmax, ymax);
        }

        public void draw(Graphics2D g, int x, int y) {
            g.translate(x, y + this.spaceAbove);
            Object saveAntialias = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.fill(this.gp);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, saveAntialias);
            g.translate(-x, -y - this.spaceAbove);
        }

        public Rectangle2D.Float getBounds() {
            return this.bounds;
        }

        public void setVerticalPadding(int above, int below) {
            this.spaceAbove = above;
            this.spaceBelow = below;
            this.bounds.y -= (float)above;
            this.bounds.height += (float)(above + below);
        }

        public int getSpaceAbove() {
            return this.spaceAbove;
        }

        public int getSpaceBelow() {
            return this.spaceBelow;
        }
    }
}

