/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.renderers;

import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.renderers.WmiGlyphRenderer;
import com.maplesoft.mathdoc.view.math.renderers.WmiHorizontalStretchyRenderer;

public class WmiHorizontalStretchyAccentRenderer
extends WmiHorizontalStretchyRenderer {
    public static final char OVERBAR_ACCENT_CHAR = '\u00af';
    public static final char HAT_ACCENT_CHAR = '^';
    public static final char TILDE_ACCENT_CHAR = '~';
    public static final char WEDGE_CHAR = '\u22c0';
    public static final char AND_CHAR = '\u2227';
    public static final char CIRC_CHAR = '\u02c6';
    private static final int MINIMUM_WIDTH = 20;
    private char stretchyChar;
    private boolean drawAsCharacter;
    private static final float[][] WEDGE_OUTLINE = new float[][]{{1.0f, 0.19921875f}, {0.5247396f, 0.07421875f}, {0.46614584f, 0.07421875f}, {0.0f, 0.19921875f}, {0.0f, 0.14713542f}, {0.45052084f, 0.0f}, {0.5494792f, 0.0f}, {1.0f, 0.14713542f}, {1.0f, 0.19921875f}, new float[0]};
    private static final int[] WEDGE_MORPH_RULES;
    private static final float[][] TILDE_OUTLINE;
    private static final int[] TILDE_MORPH_RULES;
    private static final float[][] OVERLINE_OUTLINE;
    private static final int[] OVERLINE_MORPH_RULES;

    static {
        int[] nArray = new int[10];
        nArray[0] = 9;
        nArray[1] = 10;
        nArray[2] = 10;
        nArray[3] = 8;
        nArray[4] = 8;
        nArray[5] = 10;
        nArray[6] = 10;
        nArray[7] = 9;
        nArray[8] = 9;
        WEDGE_MORPH_RULES = nArray;
        TILDE_OUTLINE = new float[][]{{0.99999994f, 0.12700534f}, {0.88335925f, 0.35632053f, 0.62208396f, 0.41276732f, 0.46811816f, 0.21403591f}, {0.33592534f, 0.10623629f, 0.13219284f, 0.04586303f, 0.0f, 0.30284312f}, {0.0f, 0.363594f}, {0.13219282f, 0.22225934f, 0.33592534f, 0.17639631f, 0.46811816f, 0.34043223f}, {0.62208396f, 0.4291636f, 0.88335925f, 0.5327168f, 0.99999994f, 0.22826944f}, {0.99999994f, 0.12700534f}, new float[0]};
        int[] nArray2 = new int[8];
        nArray2[0] = 9;
        nArray2[1] = 19;
        nArray2[2] = 21;
        nArray2[3] = 8;
        nArray2[4] = 16;
        nArray2[5] = 20;
        nArray2[6] = 9;
        TILDE_MORPH_RULES = nArray2;
        OVERLINE_OUTLINE = new float[][]{{1.0f, 0.115606934f}, {0.0f, 0.115606934f}, {0.0f, 0.0f}, {1.0f, 0.0f}, {1.0f, 0.115606934f}, new float[0]};
        int[] nArray3 = new int[6];
        nArray3[0] = 9;
        nArray3[1] = 8;
        nArray3[2] = 8;
        nArray3[3] = 9;
        nArray3[4] = 9;
        OVERLINE_MORPH_RULES = nArray3;
    }

    public WmiHorizontalStretchyAccentRenderer(String string) {
        this(string.charAt(0));
    }

    public WmiHorizontalStretchyAccentRenderer(char stretchyChar) {
        this.stretchyChar = stretchyChar;
        switch (stretchyChar) {
            case '^': 
            case '\u02c6': 
            case '\u2227': 
            case '\u22c0': {
                this.outline = WEDGE_OUTLINE;
                this.morphRules = WEDGE_MORPH_RULES;
                break;
            }
            case '~': {
                this.outline = TILDE_OUTLINE;
                this.morphRules = TILDE_MORPH_RULES;
                break;
            }
            case '\u00af': {
                this.outline = OVERLINE_OUTLINE;
                this.morphRules = OVERLINE_MORPH_RULES;
            }
        }
    }

    @Override
    public int extraPaddingAbove(WmiGlyphRenderer.RenderedGlyph glyph) {
        int result = 0;
        switch (this.stretchyChar) {
            case '^': 
            case '\u02c6': 
            case '\u2227': 
            case '\u22c0': {
                result = (int)Math.round(glyph.getBounds().getHeight());
                break;
            }
            case '\u00af': {
                result = (int)Math.round(1.5 * glyph.getBounds().getHeight());
                break;
            }
            default: {
                result = 0;
            }
        }
        return result;
    }

    public void minimizeStretchyOperator(WmiMathOperatorView view) {
        view.setWidth(20);
    }
}

