/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.renderers;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.font.WmiTextLayout;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.math.WmiMathInlineView;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.WmiOverView;
import com.maplesoft.mathdoc.view.math.WmiUnderOverView;
import com.maplesoft.mathdoc.view.math.WmiUnderView;
import com.maplesoft.mathdoc.view.math.renderers.WmiGlyphRenderer;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public abstract class WmiHorizontalStretchyRenderer
extends WmiGlyphRenderer {
    public static final char NULL_CHARACTER = '\u0000';
    public static final float MIN_STRETCH_SCALE = 0.7f;
    public static ArrayList stretchyOperators = new ArrayList();
    protected float[][] outline = null;
    protected int[] morphRules = null;

    static {
        stretchyOperators.add(new Character('\u00af'));
        stretchyOperators.add(new Character('^'));
        stretchyOperators.add(new Character('~'));
        stretchyOperators.add(new Character('\u2190'));
        stretchyOperators.add(new Character('\u2192'));
        stretchyOperators.add(new Character('\u2194'));
        stretchyOperators.add(new Character('\u21c0'));
        stretchyOperators.add(new Character('\u21c1'));
        stretchyOperators.add(new Character('\u21bc'));
        stretchyOperators.add(new Character('\u21bd'));
        stretchyOperators.add(new Character('\u0305'));
        stretchyOperators.add(new Character('\u21cc'));
        stretchyOperators.add(new Character('\u21cb'));
        stretchyOperators.add(new Character('\u21d0'));
        stretchyOperators.add(new Character('\u21d2'));
        stretchyOperators.add(new Character('\u21da'));
        stretchyOperators.add(new Character('\u21db'));
        stretchyOperators.add(new Character('\u219a'));
        stretchyOperators.add(new Character('\u219b'));
        stretchyOperators.add(new Character('\u21c7'));
        stretchyOperators.add(new Character('\u21c9'));
        stretchyOperators.add(new Character('\u21c6'));
        stretchyOperators.add(new Character('\u21c4'));
        stretchyOperators.add(new Character('\u21d4'));
        stretchyOperators.add(new Character('\u21cd'));
        stretchyOperators.add(new Character('\u21cf'));
        stretchyOperators.add(new Character('\u21ce'));
        stretchyOperators.add(new Character('\u21a6'));
        stretchyOperators.add(new Character('\u2905'));
        stretchyOperators.add(new Character('\u219e'));
        stretchyOperators.add(new Character('\u21a0'));
        stretchyOperators.add(new Character('\u21a2'));
        stretchyOperators.add(new Character('\u21a3'));
        stretchyOperators.add(new Character('\u21ad'));
        stretchyOperators.add(new Character('\u21dd'));
        stretchyOperators.add(new Character('\u22c0'));
        stretchyOperators.add(new Character('\u2227'));
        stretchyOperators.add(new Character('\u02c6'));
        stretchyOperators.add(new Character('\ufe37'));
        stretchyOperators.add(new Character('\ufe38'));
    }

    public static boolean isStretchyOperator(WmiModel model) throws WmiNoReadAccessException {
        String opName;
        boolean isStretchy = false;
        if (model instanceof WmiMathOperatorModel && (opName = ((WmiMathOperatorModel)model).getText()).length() == 1) {
            isStretchy = stretchyOperators.contains(new Character(opName.charAt(0)));
        }
        return isStretchy;
    }

    public static boolean resetStretchyOperator(WmiView view) throws WmiNoReadAccessException {
        boolean reset = false;
        WmiMathOperatorView operator = WmiHorizontalStretchyRenderer.getStretchyOperator(view);
        if (operator != null) {
            operator.markInvalid(1);
            operator.setWidth(0);
            reset = true;
        }
        return reset;
    }

    public static WmiMathOperatorView getStretchyOperator(WmiView view) throws WmiNoReadAccessException {
        WmiMathOperatorView operator = null;
        WmiModel model = view.getModel();
        WmiModelTag tag = model.getTag();
        if (tag == WmiModelTag.MATH_ROW) {
            WmiCompositeView composite = (WmiCompositeView)view;
            int size = composite.getChildCount();
            WmiModelTag operatorTag = null;
            WmiPositionedView operatorView = null;
            WmiModel operatorModel = null;
            int i = 0;
            while (i < size) {
                WmiPositionedView child = (WmiPositionedView)composite.getChild(i);
                model = child.getModel();
                tag = model.getTag();
                if (tag == WmiModelTag.MATH_IDENTIFIER) {
                    if (child.getWidth() > 0) {
                        operatorTag = null;
                        break;
                    }
                } else if (tag == WmiModelTag.MATH_OPERATOR) {
                    if (operatorTag != null) {
                        operatorTag = null;
                        break;
                    }
                    operatorTag = tag;
                    operatorView = child;
                    operatorModel = model;
                } else {
                    operatorTag = null;
                    break;
                }
                ++i;
            }
            tag = operatorTag;
            view = operatorView;
            model = operatorModel;
        }
        if (tag == WmiModelTag.MATH_OPERATOR && WmiHorizontalStretchyRenderer.isStretchyOperator((WmiMathModel)model)) {
            operator = (WmiMathOperatorView)view;
        }
        return operator;
    }

    public static boolean isOverElement(WmiView view) {
        WmiCompositeView parent = view.getParentView();
        WmiView child = view;
        while (!(parent == null || parent instanceof WmiOverView || parent instanceof WmiUnderView || parent instanceof WmiUnderOverView)) {
            child = parent;
            parent = parent.getParentView();
        }
        return parent instanceof WmiOverView && parent.indexOf(child) == 1;
    }

    public static boolean isUnderElement(WmiView view) {
        WmiCompositeView parent = view.getParentView();
        WmiView child = view;
        while (!(parent == null || parent instanceof WmiOverView || parent instanceof WmiUnderView || parent instanceof WmiUnderOverView)) {
            child = parent;
            parent = parent.getParentView();
        }
        return parent instanceof WmiUnderView && parent.indexOf(child) == 1 || parent instanceof WmiUnderOverView && parent.indexOf(child) == 1;
    }

    @Override
    public boolean isLayoutOnly() {
        return false;
    }

    @Override
    public void layoutView(WmiMathOperatorView view, int hint) throws WmiNoReadAccessException {
        this.layoutView(view);
    }

    public int extraPaddingAbove(WmiGlyphRenderer.RenderedGlyph glyph) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutView(WmiMathOperatorView view) throws WmiNoReadAccessException {
        Font renderFont = this.getFont(view);
        int width = this.computeStretchySize(view, renderFont);
        WmiGlyphRenderer.GlyphCache glyphCache = this.cache;
        synchronized (glyphCache) {
            Rectangle2D.Float bounds;
            WmiGlyphRenderer.RenderedGlyph glyph = this.cache.getGlyph(renderFont, width);
            if (glyph == null && (glyph = this.createGlyph(renderFont, width)) != null) {
                bounds = glyph.getBounds();
                int adjustedWidth = (int)Math.ceil(bounds.width);
                this.cache.setGlyph(renderFont, width, glyph);
                if (adjustedWidth != width) {
                    this.cache.setGlyph(renderFont, adjustedWidth, glyph);
                }
                WmiTextLayout layout = view.getLayout();
                int paddingAbove = layout.computeSpaceAbove();
                int paddingBelow = layout.computeSpaceBelow();
                glyph.setVerticalPadding(paddingAbove + this.extraPaddingAbove(glyph), paddingBelow);
            }
            if (glyph != null) {
                bounds = glyph.getBounds();
                view.setHeight((int)Math.ceil(bounds.height));
                view.setWidth((int)Math.ceil(bounds.width) + view.getLeftPadding() + view.getRightPadding());
                view.setStretchHeight((int)Math.ceil(bounds.height));
            }
        }
        view.setStretchWidth(width);
    }

    @Override
    public boolean applyRenderer(WmiMathOperatorView view, int hint) throws WmiNoReadAccessException {
        return this.applyRenderer(view);
    }

    @Override
    public boolean applyRenderer(WmiMathOperatorView view) throws WmiNoReadAccessException {
        WmiModel model;
        WmiModelTag tag;
        boolean apply = false;
        WmiCompositeView parentView = view.getParentView();
        if (parentView instanceof WmiMathInlineView && WmiHorizontalStretchyRenderer.getStretchyOperator(parentView) != null) {
            parentView = parentView.getParentView();
        }
        if ((tag = (model = parentView.getModel()).getTag()) == WmiModelTag.MATH_OVER || tag == WmiModelTag.MATH_UNDER || tag == WmiModelTag.MATH_UNDER_OVER) {
            apply = true;
        }
        return apply;
    }

    protected WmiPositionedView getBaseView(WmiView parent) {
        WmiPositionedView baseView = null;
        boolean charCount = false;
        if (parent instanceof WmiOverView) {
            baseView = (WmiPositionedView)((WmiOverView)parent).getChild(0);
        } else if (parent instanceof WmiUnderOverView) {
            baseView = (WmiPositionedView)((WmiUnderOverView)parent).getChild(0);
        } else if (parent instanceof WmiUnderView) {
            baseView = (WmiPositionedView)((WmiUnderView)parent).getChild(0);
        }
        return baseView;
    }

    protected WmiCompositeView getParentView(WmiView view) {
        WmiCompositeView parent = view.getParentView();
        while (!(parent == null || parent instanceof WmiOverView || parent instanceof WmiUnderOverView || parent instanceof WmiUnderView)) {
            parent = parent.getParentView();
        }
        return parent;
    }

    protected boolean drawAsCharacter(WmiMathOperatorView view) {
        boolean drawAsCharacter = false;
        WmiCompositeView parent = this.getParentView(view);
        WmiPositionedView baseView = this.getBaseView(parent);
        int charCount = 0;
        WmiModel model = baseView.getModel();
        if (model instanceof WmiTextModel && WmiModelLock.readLock(model, true)) {
            try {
                try {
                    char c;
                    charCount = ((WmiTextModel)model).getText().length();
                    if (charCount == 1 && !stretchyOperators.contains(new Character(c = ((WmiTextModel)model).getText().charAt(0)))) {
                        drawAsCharacter = true;
                    }
                }
                catch (WmiNoReadAccessException e) {
                    WmiErrorLog.log(e);
                    WmiModelLock.readUnlock(model);
                }
            }
            finally {
                WmiModelLock.readUnlock(model);
            }
        }
        return drawAsCharacter;
    }

    protected int getCharacterWidth(WmiMathOperatorView view, WmiTextLayout layout) {
        int charWidth = layout.getWidth();
        if (charWidth == 0) {
            char ch = layout.getMappedCharacter(0);
            Font f = layout.getMappedFont(0);
            WmiFontMetrics metrics = WmiFontResolver.getFontMetrics(f);
            charWidth = metrics.getCharacterProperty(0, ch, view.getDocumentView().isPrintView());
        }
        return charWidth;
    }

    protected int getCharacterCount(int width, int charWidth) {
        int fillCount = width / charWidth;
        if (fillCount * charWidth < width) {
            ++fillCount;
        }
        return fillCount;
    }

    @Override
    protected int getStretchySize(WmiPositionedView source) {
        int width = source.getWidth();
        if (source instanceof WmiMathOperatorView) {
            width = ((WmiMathOperatorView)source).getStretchWidth();
        }
        return width;
    }

    protected int computeStretchySize(WmiPositionedView source, Font font) throws WmiNoReadAccessException {
        int width = source.getWidth();
        WmiView view = source;
        WmiCompositeView parent = source.getParentView();
        boolean done = false;
        while (!done) {
            WmiModel model = view.getModel();
            WmiCompositeModel parentModel = (WmiCompositeModel)parent.getModel();
            WmiModelTag tag = parentModel.getTag();
            if (tag == WmiModelTag.MATH_OVER || tag == WmiModelTag.MATH_UNDER || tag == WmiModelTag.MATH_UNDER_OVER) {
                if (parentModel.getChild(0) == model) {
                    width = 0;
                    int size = parent.getChildCount();
                    int i = 1;
                    while (i < size) {
                        WmiPositionedView child = (WmiPositionedView)parent.getChild(i);
                        if (width < child.getWidth()) {
                            width = child.getWidth();
                        }
                        ++i;
                    }
                    width = (int)((float)width + font.getSize2D());
                } else {
                    WmiPositionedView reference = (WmiPositionedView)parent.getChild(0);
                    width = reference.getWidth();
                }
                done = true;
            }
            if (tag == null) break;
            view = parent;
            parent = view.getParentView();
        }
        return width;
    }

    @Override
    public int computePostKernAdjustment(WmiMathOperatorView view) {
        return 0;
    }

    @Override
    public int computePreKernAdjustment(WmiMathOperatorView view) {
        return 0;
    }

    @Override
    protected void morphGlyph(float[][] data, Font f, int size) {
        float fontSize = f.getSize2D();
        int limit = Math.round(0.7f * fontSize);
        if (size < limit) {
            size = limit;
        }
        this.stretchScale(data, fontSize, size, this.getStretchRules());
    }

    @Override
    protected float[][] getGlyphOutline() {
        return this.outline;
    }

    @Override
    protected int[] getStretchRules() {
        return this.morphRules;
    }
}

