/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.renderers;

import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.view.math.renderers.WmiBracketRenderer;
import java.awt.Font;
import java.awt.Graphics;

public class WmiScalableOperatorRenderer
extends WmiBracketRenderer {
    public WmiScalableOperatorRenderer(char[] data) {
        super(data);
    }

    @Override
    protected WmiBracketRenderer.RenderedBracket createBracket(Font font, int height) {
        ScalableRenderedBracket bracket = new ScalableRenderedBracket(this.data, font, height);
        this.cache.setBracket(font, height, bracket);
        return bracket;
    }

    public static class LeftAngleBracket
    extends WmiScalableOperatorRenderer {
        private static final char[] CHARS = new char[]{'C', ')', '6'};

        public LeftAngleBracket() {
            super(CHARS);
        }
    }

    public static class LeftDoubleAngleBracket
    extends WmiScalableOperatorRenderer {
        private static final char[] CHARS = new char[]{'I', 'I', 'I'};

        public LeftDoubleAngleBracket() {
            super(CHARS);
        }
    }

    public static class LeftWhiteSquareBracket
    extends WmiScalableOperatorRenderer {
        private static final char[] CHARS = new char[]{'E', '+', '8'};

        public LeftWhiteSquareBracket() {
            super(CHARS);
        }
    }

    public static class RightAngleBracket
    extends WmiScalableOperatorRenderer {
        private static final char[] CHARS = new char[]{'D', '*', '7'};

        public RightAngleBracket() {
            super(CHARS);
        }
    }

    public static class RightDoubleAngleBracket
    extends WmiScalableOperatorRenderer {
        private static final char[] CHARS = new char[]{'J', 'J', 'J'};

        public RightDoubleAngleBracket() {
            super(CHARS);
        }
    }

    public static class RightWhiteSquareBracket
    extends WmiScalableOperatorRenderer {
        private static final char[] CHARS = new char[]{'F', ',', '9'};

        public RightWhiteSquareBracket() {
            super(CHARS);
        }
    }

    protected static class ScalableRenderedBracket
    implements WmiBracketRenderer.RenderedBracket {
        private static final int SINGLE_HEIGHT_CHAR_INDEX = 0;
        private static final int DOUBLE_HEIGHT_CHAR_INDEX = 1;
        private static final int TRIPLE_HEIGHT_CHAR_INDEX = 2;
        private static final float DOUBLE_HEIGHT_SCALE_FACTOR = 2.0f;
        private static final float TRIPLE_HEIGHT_SCALE_FACTOR = 3.0f;
        private static final float DOUBLE_HEIGHT_SCALE_THRESHOLD = 2.0f;
        private static final float TRIPLE_HEIGHT_SCALE_THRESHOLD = 3.1f;
        private Font font;
        private char ch;
        private String value;
        private int yOffset;
        private int width;

        public ScalableRenderedBracket(char[] data, Font viewFont, int height) {
            Font baseFont = WmiBracketRenderer.getOversizedBracketFont();
            float baseHeight = viewFont.getSize2D();
            this.font = baseFont.deriveFont(0, baseHeight);
            WmiFontMetrics metrics = WmiFontResolver.getFontMetrics(this.font);
            this.ch = data[0];
            int ascent = metrics.getCharacterProperty(4, this.ch, false);
            int descent = metrics.getCharacterProperty(5, this.ch, false);
            int charHeight = ascent + descent;
            if ((float)height > 3.1f * (float)charHeight) {
                this.ch = data[2];
                baseHeight *= 3.0f;
            } else if ((float)height > 2.0f * (float)charHeight) {
                this.ch = data[1];
                baseHeight *= 2.0f;
            } else {
                this.ch = data[0];
            }
            this.value = Character.toString(this.ch);
            this.font = baseFont.deriveFont(0, baseHeight);
            metrics = WmiFontResolver.getFontMetrics(this.font);
            ascent = metrics.getCharacterProperty(4, this.ch, false);
            descent = metrics.getCharacterProperty(5, this.ch, false);
            charHeight = ascent + descent;
            int padding = Math.round(0.5f * (float)(height - charHeight));
            this.yOffset = padding + ascent;
            this.width = metrics.getCharacterProperty(0, this.ch, false);
        }

        @Override
        public void draw(Graphics g, int x, int y, boolean forPrinting) {
            Font saveFont = g.getFont();
            g.setFont(this.font);
            g.drawString(this.value, x, y + this.yOffset);
        }

        @Override
        public int getWidth(boolean forPrinting) {
            return this.width;
        }

        @Override
        public void validateLayout(boolean forPrinting) {
        }

        @Override
        public boolean singleCharacterBracketAllowed() {
            return true;
        }
    }
}

