/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.renderers;

import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.renderers.WmiGlyphRenderer;
import java.awt.Font;

public abstract class WmiSquareBracketRenderer
extends WmiGlyphRenderer {
    private static final float[][] LEFT_SQUARE_OUTLINE = new float[][]{{0.20000002f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}, {0.20000002f, 0.0f}, {0.20000002f, 0.03608248f}, {0.061855674f, 0.03608248f}, {0.061855674f, 0.96391755f}, {0.20000002f, 0.96391755f}, new float[0]};
    private static final int[] LEFT_SQUARE_MORPH_RULES;
    private static final float[][] DOUBLE_LEFT_OUTLINE;
    private static final int[] DOUBLE_LEFT_MORPH_RULES;
    private static final float[][] LEFT_FLOOR_OUTLINE;
    private static final int[] LEFT_FLOOR_MORPH_RULES;
    private static final float[][] LEFT_CEILING_OUTLINE;
    private static final int[] LEFT_CEILING_MORPH_RULES;
    private static final float[][] SINGLE_VERTICAL_BAR_OUTLINE;
    private static final int[] SINGLE_VERTICAL_BAR_MORPH_RULES;
    private static final float[][] DOUBLE_VERTICAL_BAR_OUTLINE;
    private static final int[] DOUBLE_VERTICAL_BAR_MORPH_RULES;
    private static final float[][] TRIPLE_VERTICAL_BAR_OUTLINE;
    private static final int[] TRIPLE_VERTICAL_BAR_MORPH_RULES;
    private static final float DOUBLE_BRACKET_SHIFT_FACTOR = 0.2f;

    static {
        int[] nArray = new int[9];
        nArray[0] = 3;
        nArray[1] = 3;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 3;
        nArray[7] = 3;
        LEFT_SQUARE_MORPH_RULES = nArray;
        DOUBLE_LEFT_OUTLINE = new float[][]{{0.35876292f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}, {0.35876292f, 0.0f}, {0.35876292f, 0.03608248f}, {0.22061855f, 0.03608248f}, {0.22061855f, 0.96391755f}, {0.35876292f, 0.96391755f}, new float[0], {0.1670103f, 0.96391755f}, {0.1670103f, 0.03608248f}, {0.053608246f, 0.03608248f}, {0.053608246f, 0.96391755f}, new float[0]};
        int[] nArray2 = new int[14];
        nArray2[0] = 3;
        nArray2[1] = 3;
        nArray2[2] = 1;
        nArray2[3] = 1;
        nArray2[4] = 1;
        nArray2[5] = 1;
        nArray2[6] = 3;
        nArray2[7] = 3;
        nArray2[9] = 3;
        nArray2[10] = 1;
        nArray2[11] = 1;
        nArray2[12] = 3;
        DOUBLE_LEFT_MORPH_RULES = nArray2;
        LEFT_FLOOR_OUTLINE = new float[][]{{0.20000002f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}, {0.061855674f, 0.0f}, {0.061855674f, 0.96391755f}, {0.20000002f, 0.96391755f}, new float[0]};
        int[] nArray3 = new int[7];
        nArray3[0] = 3;
        nArray3[1] = 3;
        nArray3[2] = 1;
        nArray3[3] = 1;
        nArray3[4] = 3;
        nArray3[5] = 3;
        LEFT_FLOOR_MORPH_RULES = nArray3;
        LEFT_CEILING_OUTLINE = new float[][]{{0.20000002f, 0.03608248f}, {0.061855674f, 0.03608248f}, {0.061855674f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}, {0.20000002f, 0.0f}, new float[0]};
        int[] nArray4 = new int[7];
        nArray4[0] = 1;
        nArray4[1] = 1;
        nArray4[2] = 3;
        nArray4[3] = 3;
        nArray4[4] = 1;
        nArray4[5] = 1;
        LEFT_CEILING_MORPH_RULES = nArray4;
        SINGLE_VERTICAL_BAR_OUTLINE = new float[][]{{0.053608254f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}, {0.053608254f, 0.0f}, new float[0]};
        int[] nArray5 = new int[5];
        nArray5[0] = 3;
        nArray5[1] = 3;
        nArray5[2] = 1;
        nArray5[3] = 1;
        SINGLE_VERTICAL_BAR_MORPH_RULES = nArray5;
        DOUBLE_VERTICAL_BAR_OUTLINE = new float[][]{{0.2613169f, 0.9979423f}, {0.20781894f, 0.9979423f}, {0.20781894f, 0.0f}, {0.2613169f, 0.0f}, new float[0], {0.05349794f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}, {0.05349794f, 0.0f}, new float[0]};
        int[] nArray6 = new int[10];
        nArray6[0] = 3;
        nArray6[1] = 3;
        nArray6[2] = 1;
        nArray6[3] = 1;
        nArray6[5] = 3;
        nArray6[6] = 3;
        nArray6[7] = 1;
        nArray6[8] = 1;
        DOUBLE_VERTICAL_BAR_MORPH_RULES = nArray6;
        TRIPLE_VERTICAL_BAR_OUTLINE = new float[][]{{0.46804124f, 1.0f}, {0.41443303f, 1.0f}, {0.41443303f, 0.0f}, {0.46804124f, 0.0f}, new float[0], {0.26082474f, 1.0f}, {0.20721652f, 1.0f}, {0.20721652f, 0.0f}, {0.26082474f, 0.0f}, new float[0], {0.053608246f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}, {0.053608246f, 0.0f}, new float[0]};
        int[] nArray7 = new int[15];
        nArray7[0] = 3;
        nArray7[1] = 3;
        nArray7[2] = 1;
        nArray7[3] = 1;
        nArray7[5] = 3;
        nArray7[6] = 3;
        nArray7[7] = 1;
        nArray7[8] = 1;
        nArray7[10] = 3;
        nArray7[11] = 3;
        nArray7[12] = 1;
        nArray7[13] = 1;
        TRIPLE_VERTICAL_BAR_MORPH_RULES = nArray7;
    }

    protected boolean isRightBracket() {
        return false;
    }

    @Override
    protected boolean isBracket() {
        return true;
    }

    @Override
    protected void morphGlyph(float[][] data, Font f, int size) {
        this.stretchScale(data, f.getSize2D(), size, this.getStretchRules());
        if (this.isRightBracket()) {
            this.rotate180(data);
        }
    }

    @Override
    public boolean forcePreKernAdjustment(WmiMathOperatorView view) {
        return this.isRightBracket();
    }

    @Override
    public boolean forcePostKernAdjustment(WmiMathOperatorView view) {
        return !this.isRightBracket();
    }

    public static class WmiDoubleLeftBracketRenderer
    extends WmiSquareBracketRenderer {
        @Override
        protected float[][] getGlyphOutline() {
            return DOUBLE_LEFT_OUTLINE;
        }

        @Override
        protected int[] getStretchRules() {
            return DOUBLE_LEFT_MORPH_RULES;
        }

        @Override
        protected float getBracketShiftFactor() {
            return 0.2f;
        }
    }

    public static class WmiDoubleRightBracketRenderer
    extends WmiSquareBracketRenderer {
        @Override
        protected float[][] getGlyphOutline() {
            return DOUBLE_LEFT_OUTLINE;
        }

        @Override
        protected int[] getStretchRules() {
            return DOUBLE_LEFT_MORPH_RULES;
        }

        @Override
        protected boolean isRightBracket() {
            return true;
        }

        @Override
        protected float getBracketShiftFactor() {
            return 0.2f;
        }
    }

    public static class WmiDoubleVerticalBarRenderer
    extends WmiSquareBracketRenderer {
        @Override
        protected float[][] getGlyphOutline() {
            return DOUBLE_VERTICAL_BAR_OUTLINE;
        }

        @Override
        protected int[] getStretchRules() {
            return DOUBLE_VERTICAL_BAR_MORPH_RULES;
        }

        @Override
        public boolean forcePreKernAdjustment(WmiMathOperatorView view) {
            return true;
        }

        @Override
        public boolean forcePostKernAdjustment(WmiMathOperatorView view) {
            return true;
        }
    }

    public static class WmiLeftCeilingRenderer
    extends WmiSquareBracketRenderer {
        @Override
        protected float[][] getGlyphOutline() {
            return LEFT_CEILING_OUTLINE;
        }

        @Override
        protected int[] getStretchRules() {
            return LEFT_CEILING_MORPH_RULES;
        }
    }

    public static class WmiLeftFloorRenderer
    extends WmiSquareBracketRenderer {
        @Override
        protected float[][] getGlyphOutline() {
            return LEFT_FLOOR_OUTLINE;
        }

        @Override
        protected int[] getStretchRules() {
            return LEFT_FLOOR_MORPH_RULES;
        }
    }

    public static class WmiLeftSquareBracketRenderer
    extends WmiSquareBracketRenderer {
        @Override
        protected float[][] getGlyphOutline() {
            return LEFT_SQUARE_OUTLINE;
        }

        @Override
        protected int[] getStretchRules() {
            return LEFT_SQUARE_MORPH_RULES;
        }
    }

    public static class WmiRightCeilingRenderer
    extends WmiSquareBracketRenderer {
        @Override
        protected float[][] getGlyphOutline() {
            return LEFT_FLOOR_OUTLINE;
        }

        @Override
        protected int[] getStretchRules() {
            return LEFT_FLOOR_MORPH_RULES;
        }

        @Override
        protected boolean isRightBracket() {
            return true;
        }
    }

    public static class WmiRightFloorRenderer
    extends WmiSquareBracketRenderer {
        @Override
        protected float[][] getGlyphOutline() {
            return LEFT_CEILING_OUTLINE;
        }

        @Override
        protected int[] getStretchRules() {
            return LEFT_CEILING_MORPH_RULES;
        }

        @Override
        protected boolean isRightBracket() {
            return true;
        }
    }

    public static class WmiRightSquareBracketRenderer
    extends WmiSquareBracketRenderer {
        @Override
        protected float[][] getGlyphOutline() {
            return LEFT_SQUARE_OUTLINE;
        }

        @Override
        protected int[] getStretchRules() {
            return LEFT_SQUARE_MORPH_RULES;
        }

        @Override
        protected boolean isRightBracket() {
            return true;
        }
    }

    public static class WmiSingleVerticalBarRenderer
    extends WmiSquareBracketRenderer {
        @Override
        protected float[][] getGlyphOutline() {
            return SINGLE_VERTICAL_BAR_OUTLINE;
        }

        @Override
        protected int[] getStretchRules() {
            return SINGLE_VERTICAL_BAR_MORPH_RULES;
        }

        @Override
        public boolean forcePreKernAdjustment(WmiMathOperatorView view) {
            return true;
        }

        @Override
        public boolean forcePostKernAdjustment(WmiMathOperatorView view) {
            return true;
        }
    }

    public static class WmiTripleVerticalBarRenderer
    extends WmiSquareBracketRenderer {
        @Override
        protected float[][] getGlyphOutline() {
            return TRIPLE_VERTICAL_BAR_OUTLINE;
        }

        @Override
        protected int[] getStretchRules() {
            return TRIPLE_VERTICAL_BAR_MORPH_RULES;
        }

        @Override
        public boolean forcePreKernAdjustment(WmiMathOperatorView view) {
            return true;
        }

        @Override
        public boolean forcePostKernAdjustment(WmiMathOperatorView view) {
            return true;
        }
    }
}

