/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.renderers;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiTextLayout;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.renderers.WmiAbstractOperatorRenderer;
import java.awt.Graphics;
import java.awt.Rectangle;

public class WmiUnaryMinusRenderer
extends WmiAbstractOperatorRenderer {
    private static final float WIDTH_ASPECT_RATIO = 0.7f;
    private static final float CLIP_ASPECT_RATIO = 0.8f;

    @Override
    public boolean applyRenderer(WmiMathOperatorView view, int hint) throws WmiNoReadAccessException {
        boolean apply = false;
        WmiMathOperatorModel model = (WmiMathOperatorModel)view.getModel();
        String label = model.getSemanticLabel();
        if ("&uminus0;".equals(label)) {
            apply = true;
        }
        return apply;
    }

    @Override
    public boolean isStretchy() {
        return false;
    }

    @Override
    public void layoutView(WmiMathOperatorView view, int height) throws WmiNoReadAccessException {
        WmiTextLayout layout = view.getLayout();
        height = layout.getHeight();
        int width = layout.getWidth();
        view.setWidth(Math.round(0.7f * (float)width));
        view.setStretchHeight(height);
    }

    @Override
    public void draw(Graphics g, WmiRenderPath path, Rectangle bounds, WmiMathOperatorView view) {
        Rectangle saveClip = g.getClipBounds();
        int xOffset = path.getHorizontalOffset() + view.getHorizontalOffset();
        int yOffset = path.getVerticalOffset() + view.getVerticalOffset();
        if (path.cloneGCForClip()) {
            g = g.create();
        }
        g.clipRect(xOffset, yOffset, Math.round(0.8f * (float)view.getWidth()), view.getHeight());
        view.drawText(g, path, bounds);
        if (path.cloneGCForClip()) {
            g.dispose();
        } else {
            g.setClip(saveClip);
        }
    }
}

