/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

public class Base64Encoder {
    private static final String BASIS64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final int ASCII6 = 64;
    private static final int ASCII7 = 128;
    private static char[] chEncode = new char[64];
    private static char[] chDecode = new char[128];

    static {
        int len = BASIS64.length();
        int i = 0;
        while (i < len) {
            char ch;
            Base64Encoder.chEncode[i] = ch = BASIS64.charAt(i);
            Base64Encoder.chDecode[ch] = (char)i;
            ++i;
        }
    }

    public static String decode(String input) {
        StringBuffer buffy = new StringBuffer();
        Base64Encoder.decode(input, buffy);
        return buffy.toString();
    }

    public static void decode(String input, StringBuffer output) {
        int inlen = input.length();
        char[] chOut = new char[inlen];
        int ipos = 0;
        int opos = 0;
        while (inlen > 4) {
            Base64Encoder.decode4to3(input, chOut, ipos, opos);
            ipos += 4;
            opos += 3;
            inlen -= 4;
        }
        if (inlen == 4) {
            if (input.endsWith("==")) {
                Base64Encoder.decode4to1(input, chOut, ipos, opos);
                ++opos;
            } else if (input.endsWith("=")) {
                Base64Encoder.decode4to2(input, chOut, ipos, opos);
                opos += 2;
            } else {
                Base64Encoder.decode4to3(input, chOut, ipos, opos);
                opos += 3;
            }
        }
        output.append(new String(chOut, 0, opos));
    }

    public static String encode(String input) {
        StringBuffer buffy = new StringBuffer();
        Base64Encoder.encode(input, buffy);
        return buffy.toString();
    }

    public static void encode(String input, StringBuffer output) {
        int inlen = input.length();
        char[] chOut = new char[4 * inlen / 3 + 4];
        int ipos = 0;
        int opos = 0;
        while (inlen >= 3) {
            Base64Encoder.encode3to4(input, chOut, ipos, opos);
            ipos += 3;
            opos += 4;
            inlen -= 3;
        }
        switch (inlen) {
            case 2: {
                Base64Encoder.encode2to4(input, chOut, ipos, opos);
                opos += 4;
                break;
            }
            case 1: {
                Base64Encoder.encode1to4(input, chOut, ipos, opos);
                opos += 4;
            }
        }
        output.append(new String(chOut, 0, opos));
    }

    public static String slashify(String strValue) {
        StringBuffer buffy = new StringBuffer(strValue);
        Base64Encoder.slashify(buffy);
        return buffy.toString();
    }

    public static void slashify(StringBuffer contents) {
        contents.append("\"{}");
        int i = 0;
        while (i < contents.length()) {
            char current = contents.charAt(i);
            if (current == '\"' || current == '{' || current == '}' || current == '\\') {
                contents.insert(i, '\\');
                ++i;
            }
            ++i;
        }
    }

    private static void decode4to3(String input, char[] chOut, int ipos, int opos) {
        int i = 0;
        char pos = '\u0000';
        int b32 = 0;
        i = ipos;
        while (i < ipos + 4) {
            pos = chDecode[input.charAt(i)];
            b32 <<= 6;
            b32 |= pos;
            ++i;
        }
        i = 2;
        while (i >= 0) {
            chOut[opos + i] = (char)(b32 & 0xFF);
            b32 >>= 8;
            --i;
        }
    }

    private static void decode4to2(String input, char[] chOut, int ipos, int opos) {
        char pos1 = chDecode[input.charAt(ipos)];
        char pos2 = chDecode[input.charAt(ipos + 1)];
        char pos3 = chDecode[input.charAt(ipos + 2)];
        chOut[opos] = (char)(pos1 << 2 | pos2 >> 4);
        chOut[opos + 1] = (char)((pos2 & 0xF) << 4 | pos3 >> 2);
    }

    private static void decode4to1(String input, char[] chOut, int ipos, int opos) {
        char val;
        char pos1 = chDecode[input.charAt(ipos)];
        char pos2 = chDecode[input.charAt(ipos + 1)];
        chOut[opos] = val = (char)(pos1 << 2 | pos2 >> 4);
    }

    private static void encode3to4(String input, char[] chOut, int ipos, int opos) {
        int b32 = 0;
        int i = 0;
        int j = 18;
        i = ipos;
        while (i < ipos + 3) {
            b32 <<= 8;
            b32 |= (byte)input.charAt(i);
            ++i;
        }
        i = 0;
        while (i < 4) {
            chOut[opos + i] = chEncode[b32 >> j & 0x3F];
            j -= 6;
            ++i;
        }
    }

    private static void encode2to4(String input, char[] chOut, int ipos, int opos) {
        chOut[opos] = chEncode[(byte)input.charAt(ipos) >> 2 & 0x3F];
        chOut[opos + 1] = chEncode[(byte)(input.charAt(ipos) & 3) << 4 | (byte)input.charAt(ipos + 1) >> 4 & 0xF];
        chOut[opos + 2] = chEncode[((byte)input.charAt(ipos + 1) & 0xF) << 2];
        chOut[opos + 3] = 61;
    }

    private static void encode1to4(String input, char[] chOut, int ipos, int opos) {
        chOut[opos] = chEncode[(byte)input.charAt(ipos) >> 2 & 0x3F];
        chOut[opos + 1] = chEncode[((byte)input.charAt(ipos) & 3) << 4];
        chOut[opos + 2] = 61;
        chOut[opos + 3] = 61;
    }
}

