/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import com.maplesoft.util.ConversionException;
import com.maplesoft.util.ConversionStyle;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class DOM2StringConversion
implements ConversionStyle {
    @Override
    public String getConversionSchemeID() {
        return "XMLString:";
    }

    @Override
    public ConversionStyle createWithArgument(String argument) {
        return new DOM2StringConversion();
    }

    @Override
    public Object convert(Object source, String targetFormat) throws ConversionException, IllegalArgumentException {
        if (!(targetFormat.equalsIgnoreCase("string") || targetFormat.equalsIgnoreCase("xml") || targetFormat.equals("java.lang.String"))) {
            throw new IllegalArgumentException("com.maplesoft.util.DOM2StringConversion: only supports String or XML output");
        }
        if (!(source instanceof Document)) {
            throw new IllegalArgumentException("com.maplesoft.util.DOM2StringConversion: only supports Document source");
        }
        try {
            String result = null;
            StringWriter strw = new StringWriter();
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer xform = transFactory.newTransformer();
            xform.setOutputProperty("indent", "yes");
            DOMSource src = new DOMSource((Document)source);
            StreamResult res = new StreamResult(strw);
            xform.transform(src, res);
            result = strw.toString();
            return result;
        }
        catch (Exception e1) {
            throw new ConversionException(e1);
        }
    }

    @Override
    public Object convert(InputStream source, String targetFormat) throws IllegalArgumentException {
        throw new IllegalArgumentException("com.maplesoft.util.DOM2StringConversion: does not support InputStreams");
    }
}

