/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import com.maplesoft.util.ConversionException;
import com.maplesoft.util.ConversionStyle;
import com.maplesoft.util.XSLTConversion;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import org.w3c.dom.Document;

public class FormatConverter {
    static HashMap converters = new HashMap();
    static String[] convertorclasses = new String[]{"XSLTConversion", "XMLSafeStringConversion", "XML2DotMConversion", "EntityStringConversion", "DOMBuilderConversion", "DOM2StringConversion", "XMLSafeStringConversion"};

    static {
        String utilPack = "com.maplesoft.util";
        Class[] convertorList = new Class[convertorclasses.length];
        int i = 0;
        while (i < convertorclasses.length) {
            try {
                convertorList[i] = Class.forName(String.valueOf(utilPack) + "." + convertorclasses[i]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            ++i;
        }
        if (convertorList != null) {
            i = 0;
            while (i < convertorList.length) {
                try {
                    ConversionStyle csinstance = null;
                    csinstance = (ConversionStyle)convertorList[i].newInstance();
                    String scheme = csinstance.getConversionSchemeID();
                    scheme = scheme.toLowerCase();
                    if (scheme != null) {
                        converters.put(scheme, csinstance);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    public static String toXML(Document dom) throws ConversionException {
        try {
            String xml = (String)FormatConverter.convert("XMLString:", dom, "xml");
            return xml;
        }
        catch (IllegalArgumentException e1) {
            throw new ConversionException(e1);
        }
    }

    public static Document xslTransform(String stylesheetResource, Document source) throws ConversionException {
        return (Document)FormatConverter.convert(stylesheetResource, source, "dom");
    }

    public static Object convert(String translator, Object source, String targetFormat) throws IllegalArgumentException, ConversionException {
        Object result = null;
        ConversionStyle convertor = FormatConverter.selectConvertor(translator);
        result = convertor.convert(source, targetFormat);
        return result;
    }

    public static Object convert(String translator, Document source, String targetFormat) throws IllegalArgumentException, ConversionException {
        ConversionStyle convertor = FormatConverter.selectConvertor(translator);
        return convertor.convert(source, targetFormat);
    }

    public static Object convert(String translator, File source, String targetFormat) throws IllegalArgumentException, ConversionException {
        ConversionStyle convertor = FormatConverter.selectConvertor(translator);
        return convertor.convert(source, targetFormat);
    }

    public static Object convert(String translator, InputStream source, String targetFormat) throws IllegalArgumentException, ConversionException {
        ConversionStyle convertor = FormatConverter.selectConvertor(translator);
        return convertor.convert(source, targetFormat);
    }

    public static Object convert(String translator, String source, String targetFormat) throws IllegalArgumentException, ConversionException {
        ConversionStyle convertor = FormatConverter.selectConvertor(translator);
        return convertor.convert(source, targetFormat);
    }

    protected static ConversionStyle selectConvertor(String translator) throws IllegalArgumentException {
        ConversionStyle toReturn = null;
        int colonpos = translator.indexOf(":");
        String schemeId = translator;
        if (colonpos > -1) {
            schemeId = translator.substring(0, colonpos + 1);
        }
        String argument = null;
        if (colonpos > -1 && colonpos < translator.length()) {
            argument = translator.substring(colonpos + 1);
        }
        if (translator.endsWith("xsl") && translator.indexOf(":") < 0) {
            String scheme = translator;
            toReturn = new XSLTConversion(scheme);
        }
        if (toReturn == null && !converters.containsKey(schemeId.toLowerCase())) {
            throw new IllegalArgumentException("Conversion " + translator + " does not exist");
        }
        if (toReturn == null) {
            toReturn = ((ConversionStyle)converters.get(schemeId.toLowerCase())).createWithArgument(argument);
        }
        return toReturn;
    }

    static HashMap getConvertors() {
        return converters;
    }

    public static int getNumberConverters() {
        return converters.size();
    }
}

