/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

public class PlatformInfo {
    private static String platformName = "";
    private static String OSName = "";
    private static String OSVersion = "";
    public static final String WINDOWS = "Windows";
    public static final String WIN = "Win";
    public static final String MACINTOSH = "Macintosh";
    public static final String MAC = "Mac";
    public static final String WIN32 = "Win32";
    public static final String UNIX = "Unix";
    public static final String SOLARIS = "SunOS";
    public static final String SPARC = "Sparc";
    public static final String INTEL = "Intel";
    public static final String SOLARIS_SPARC = "Solaris Sparc";
    public static final String SOLARIS_INTEL = "Solaris Intel";
    public static final String DEC_ALPHA = "alpha";
    public static final String WINDOWS_NT = "Windows NT";
    public static final String WINDOWS_95 = "Windows 95";
    public static final String WINDOWS_98 = "Windows 98";
    public static final String WINDOWS_2000 = "Windows 2000";
    public static final String SPARCSOLARIS = "SparcSolaris";
    public static final String INTELSOLARIS = "IntelSolaris";
    public static final String AIX = "AIX";
    public static final String HPUX = "HPUX";
    public static final String SGI = "SGI";
    public static final String ALPHA = "Alpha";
    public static final String LINUX = "Linux";
    public static final String WINNT = "WinNT";
    public static final String WIN95 = "Win95";
    public static final String WIN98 = "Win98";
    public static final String WIN2000 = "Win2000";
    public static final String CLASSIC = "Classic";
    public static final String CARBON = "Carbon";
    public static final String COCOA = "Cocoa";

    private PlatformInfo() {
    }

    public static String getPlatformName() {
        if (!platformName.equals("")) {
            return platformName;
        }
        platformName = System.getProperty("os.name");
        return platformName;
    }

    public static String getOSName() {
        if (!OSName.equals("")) {
            return OSName;
        }
        String PlatformName = PlatformInfo.getPlatformName();
        OSName = PlatformName.startsWith(WIN) ? WINDOWS : (PlatformName.startsWith(SOLARIS) ? UNIX : (PlatformName.startsWith(DEC_ALPHA) ? UNIX : (PlatformName.startsWith(SGI) ? UNIX : (PlatformName.startsWith(HPUX) ? UNIX : (PlatformName.startsWith(AIX) ? UNIX : (PlatformName.startsWith(LINUX) ? UNIX : (PlatformName.startsWith(MAC) ? MACINTOSH : (PlatformName.startsWith(CLASSIC) ? MACINTOSH : (PlatformName.startsWith(CARBON) ? MACINTOSH : (PlatformName.startsWith(COCOA) ? MACINTOSH : UNIX))))))))));
        return OSName;
    }

    public static String getOSVersion() {
        if (!OSVersion.equals("")) {
            return OSVersion;
        }
        OSVersion = String.valueOf(System.getProperty("os.name")) + " " + System.getProperty("os.version");
        return OSVersion;
    }

    public static String getImplementationClassName(String className) throws NoClassDefFoundError {
        String OS = PlatformInfo.getOSName();
        String platform = PlatformInfo.getPlatformName();
        String classStr = null;
        if (OS.equals(WINDOWS)) {
            classStr = String.valueOf(className) + WIN32;
        } else if (OS.equals(UNIX)) {
            classStr = String.valueOf(className) + UNIX;
        } else if (OS.equals(MACINTOSH)) {
            classStr = String.valueOf(className) + MAC;
        } else {
            throw new NoClassDefFoundError("Platform is unsupported");
        }
        try {
            Class.forName(classStr);
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName(String.valueOf(className) + platform);
            }
            catch (Throwable t) {
                throw new NoClassDefFoundError("Cannot initialize class " + className);
            }
        }
        catch (Throwable e) {
            throw new NoClassDefFoundError("Cannot initialize class " + className);
        }
        return classStr;
    }

    public static String getUserPath() {
        String separator;
        String home = System.getProperty("user.home");
        if (!home.endsWith(separator = System.getProperty("file.separator"))) {
            home = String.valueOf(home) + separator;
        }
        return home;
    }
}

