/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

public class Quantize {
    static final boolean QUICK = false;
    static final int MAX_RGB = 255;
    static final int MAX_NODES = 266817;
    static final int MAX_TREE_DEPTH = 8;
    static int[] SQUARES = new int[511];
    static int[] SHIFT;

    static {
        int i = -255;
        while (i <= 255) {
            Quantize.SQUARES[i + 255] = i * i;
            ++i;
        }
        SHIFT = new int[9];
        i = 0;
        while (i < 9) {
            Quantize.SHIFT[i] = 1 << 15 - i;
            ++i;
        }
    }

    public static int[] quantizeImage(int[][] pixels, int max_colors) {
        Cube cube = new Cube(pixels, max_colors);
        cube.classification();
        cube.reduction();
        cube.assignment();
        return cube.colormap;
    }

    static class Cube {
        int[][] pixels;
        int max_colors;
        int[] colormap;
        Node root;
        int depth;
        int colors;
        int nodes;

        Cube(int[][] pixels, int max_colors) {
            this.pixels = pixels;
            this.max_colors = max_colors;
            this.colors = 1;
            int i = max_colors;
            this.depth = 1;
            while (i != 0) {
                i /= 4;
                ++this.depth;
            }
            if (this.depth > 1) {
                --this.depth;
            }
            if (this.depth > 8) {
                this.depth = 8;
            } else if (this.depth < 2) {
                this.depth = 2;
            }
            this.root = new Node(this);
        }

        void classification() {
            int[][] pixels = this.pixels;
            int width = pixels.length;
            int height = pixels[0].length;
            int x = width;
            while (x-- > 0) {
                int y = height;
                while (y-- > 0) {
                    int pixel = pixels[x][y];
                    int alpha = pixel >> 24 & 0xFF;
                    int red = pixel >> 16 & 0xFF;
                    int green = pixel >> 8 & 0xFF;
                    int blue = pixel >> 0 & 0xFF;
                    if (alpha <= 0) continue;
                    if (this.nodes > 266817) {
                        this.root.pruneLevel();
                        --this.depth;
                    }
                    Node node = this.root;
                    int level = 1;
                    while (level <= this.depth) {
                        int id = (red > node.mid_red ? 1 : 0) << 0 | (green > node.mid_green ? 1 : 0) << 1 | (blue > node.mid_blue ? 1 : 0) << 2;
                        if (node.child[id] == null) {
                            new Node(node, id, level);
                        }
                        node = node.child[id];
                        node.number_pixels += (long)SHIFT[level];
                        if (node.number_pixels < 0L) {
                            node.number_pixels = Integer.MAX_VALUE;
                        }
                        ++level;
                    }
                    if (++node.unique < 0L) {
                        node.unique = Integer.MAX_VALUE;
                    }
                    node.total_alpha += (long)alpha;
                    node.total_red += (long)red;
                    node.total_green += (long)green;
                    node.total_blue += (long)blue;
                    if (node.total_alpha < 0L) {
                        node.total_alpha = Integer.MAX_VALUE;
                    }
                    if (node.total_red < 0L) {
                        node.total_red = Integer.MAX_VALUE;
                    }
                    if (node.total_green < 0L) {
                        node.total_green = Integer.MAX_VALUE;
                    }
                    if (node.total_blue >= 0L) continue;
                    node.total_blue = Integer.MAX_VALUE;
                }
            }
        }

        void reduction() {
            long threshold = 1L;
            while (this.colors > this.max_colors) {
                this.colors = 1;
                threshold = this.root.reduce(threshold, Integer.MAX_VALUE);
            }
        }

        void assignment() {
            this.colormap = new int[this.colors];
            this.colormap[0] = 0xF0F0F0;
            this.colors = 1;
            this.root.colormap();
            int[][] pixels = this.pixels;
            int width = pixels.length;
            int height = pixels[0].length;
            Search search = new Search();
            int x = width;
            while (x-- > 0) {
                int y = height;
                while (y-- > 0) {
                    int pixel = pixels[x][y];
                    int alpha = pixel >> 24 & 0xFF;
                    int red = pixel >> 16 & 0xFF;
                    int green = pixel >> 8 & 0xFF;
                    int blue = pixel >> 0 & 0xFF;
                    if (alpha > 0) {
                        int id;
                        Node node = this.root;
                        while (node.child[id = (red > node.mid_red ? 1 : 0) << 0 | (green > node.mid_green ? 1 : 0) << 1 | (blue > node.mid_blue ? 1 : 0) << 2] != null) {
                            node = node.child[id];
                        }
                        search.distance = Integer.MAX_VALUE;
                        node.parent.closestColor(red, green, blue, search);
                        pixels[x][y] = search.color_number;
                        continue;
                    }
                    pixels[x][y] = 0;
                }
            }
        }

        static class Node {
            Cube cube;
            Node parent;
            Node[] child;
            int nchild;
            int id;
            int level;
            int mid_red;
            int mid_green;
            int mid_blue;
            long number_pixels;
            long unique;
            long total_alpha;
            long total_red;
            long total_green;
            long total_blue;
            int color_number;

            Node(Cube cube) {
                this.cube = cube;
                this.parent = this;
                this.child = new Node[8];
                this.id = 0;
                this.level = 0;
                this.number_pixels = Integer.MAX_VALUE;
                this.mid_red = 128;
                this.mid_green = 128;
                this.mid_blue = 128;
            }

            Node(Node parent, int id, int level) {
                this.cube = parent.cube;
                this.parent = parent;
                this.child = new Node[8];
                this.id = id;
                this.level = level;
                ++this.cube.nodes;
                if (level == this.cube.depth) {
                    ++this.cube.colors;
                }
                ++parent.nchild;
                parent.child[id] = this;
                int bi = 1 << 8 - level >> 1;
                this.mid_red = parent.mid_red + ((id & 1) > 0 ? bi : -bi);
                this.mid_green = parent.mid_green + ((id & 2) > 0 ? bi : -bi);
                this.mid_blue = parent.mid_blue + ((id & 4) > 0 ? bi : -bi);
            }

            void pruneChild() {
                --this.parent.nchild;
                this.parent.unique += this.unique;
                this.parent.total_alpha += this.total_alpha;
                this.parent.total_red += this.total_red;
                this.parent.total_green += this.total_green;
                this.parent.total_blue += this.total_blue;
                this.parent.child[this.id] = null;
                --this.cube.nodes;
                this.cube = null;
                this.parent = null;
            }

            void pruneLevel() {
                if (this.nchild != 0) {
                    int id = 0;
                    while (id < 8) {
                        if (this.child[id] != null) {
                            this.child[id].pruneLevel();
                        }
                        ++id;
                    }
                }
                if (this.level == this.cube.depth) {
                    this.pruneChild();
                }
            }

            long reduce(long threshold, long next_threshold) {
                if (this.nchild != 0) {
                    int id = 0;
                    while (id < 8) {
                        if (this.child[id] != null) {
                            next_threshold = this.child[id].reduce(threshold, next_threshold);
                        }
                        ++id;
                    }
                }
                if (this.number_pixels <= threshold) {
                    this.pruneChild();
                } else {
                    if (this.unique != 0L) {
                        ++this.cube.colors;
                    }
                    if (this.number_pixels < next_threshold) {
                        next_threshold = this.number_pixels;
                    }
                }
                return next_threshold;
            }

            void colormap() {
                if (this.nchild != 0) {
                    int id = 0;
                    while (id < 8) {
                        if (this.child[id] != null) {
                            this.child[id].colormap();
                        }
                        ++id;
                    }
                }
                if (this.unique != 0L) {
                    int a = (int)((this.total_alpha + (this.unique >> 1)) / this.unique);
                    int r = (int)((this.total_red + (this.unique >> 1)) / this.unique);
                    int g = (int)((this.total_green + (this.unique >> 1)) / this.unique);
                    int b = (int)((this.total_blue + (this.unique >> 1)) / this.unique);
                    this.cube.colormap[this.cube.colors] = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
                    this.color_number = this.cube.colors++;
                }
            }

            void closestColor(int red, int green, int blue, Search search) {
                int color;
                int distance;
                if (this.nchild != 0) {
                    int id = 0;
                    while (id < 8) {
                        if (this.child[id] != null) {
                            this.child[id].closestColor(red, green, blue, search);
                        }
                        ++id;
                    }
                }
                if (this.unique != 0L && (distance = Node.distance(color = this.cube.colormap[this.color_number], red, green, blue)) < search.distance) {
                    search.distance = distance;
                    search.color_number = this.color_number;
                }
            }

            static final int distance(int color, int r, int g, int b) {
                return SQUARES[(color >> 16 & 0xFF) - r + 255] + SQUARES[(color >> 8 & 0xFF) - g + 255] + SQUARES[(color >> 0 & 0xFF) - b + 255];
            }

            public String toString() {
                StringBuffer buf = new StringBuffer();
                if (this.parent == this) {
                    buf.append("root");
                } else {
                    buf.append("node");
                }
                buf.append(' ');
                buf.append(this.level);
                buf.append(" [");
                buf.append(this.mid_red);
                buf.append(',');
                buf.append(this.mid_green);
                buf.append(',');
                buf.append(this.mid_blue);
                buf.append(']');
                return new String(buf);
            }
        }

        static class Search {
            int distance;
            int color_number;

            Search() {
            }
        }
    }
}

