/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import com.maplesoft.util.RuntimePlatform;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ResourceLoader {
    private static final String ALTERNATE_WINDOWS_TEMP_DIR = "C:\\WINDOWS\\TEMP";

    public static InputStream getResourceAsStream(String resourceName) {
        return ResourceLoader.class.getResourceAsStream(ResourceLoader.slashifyName(resourceName));
    }

    public static Image getResourceAsImage(String resourceName) {
        URL url = ResourceLoader.class.getResource(ResourceLoader.slashifyName(resourceName));
        return url != null ? Toolkit.getDefaultToolkit().createImage(url) : null;
    }

    public static URL getResourceAsURL(String resourceName) {
        return ResourceLoader.class.getResource(ResourceLoader.slashifyName(resourceName));
    }

    public static StreamSource getResourceAsStreamSource(String resourceName) {
        InputStream is = ResourceLoader.class.getResourceAsStream(ResourceLoader.slashifyName(resourceName));
        return is != null ? new StreamSource(is) : null;
    }

    public static Document getResourceAsDOMValidated(String resourceName) throws Exception {
        Document domResult = null;
        InputStream is = ResourceLoader.getResourceAsStream(ResourceLoader.slashifyName(resourceName));
        if (is == null) {
            throw new FileNotFoundException("Could not open " + resourceName);
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        InputSource isrc = new InputSource(is);
        dbf.setIgnoringComments(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        domResult = db.parse(isrc);
        return domResult;
    }

    public static Document getResourceAsDOM(String resourceName) {
        Document domResult = null;
        try {
            domResult = ResourceLoader.getResourceAsDOMValidated(resourceName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return domResult;
    }

    public static synchronized Font getResourceAsFont(String resourceName) throws IOException, FontFormatException, IllegalArgumentException {
        File testTempFileDir;
        String td;
        InputStream is = ResourceLoader.getResourceAsStream(resourceName);
        String tempDir = null;
        if (RuntimePlatform.isWindows() && ResourceLoader.couldContainCJKText(td = System.getProperty("java.io.tmpdir")) && (testTempFileDir = new File(ALTERNATE_WINDOWS_TEMP_DIR)).canWrite()) {
            tempDir = td;
            System.setProperty("java.io.tmpdir", ALTERNATE_WINDOWS_TEMP_DIR);
        }
        Font toReturn = null;
        try {
            toReturn = Font.createFont(0, is);
            is.close();
        }
        finally {
            if (tempDir != null) {
                System.setProperty("java.io.tmpdir", tempDir);
            }
        }
        return toReturn;
    }

    private static boolean couldContainCJKText(String s) {
        boolean b = false;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) > '\u00ff') {
                b = true;
                break;
            }
            ++i;
        }
        return b;
    }

    public static Font getResourceAsFont(String resourceName, float pointSize) throws IOException, FontFormatException, IllegalArgumentException {
        Font toReturn = ResourceLoader.getResourceAsFont(resourceName);
        toReturn = toReturn.deriveFont(pointSize);
        return toReturn;
    }

    public static Font getResourceAsFont(String resourceName, int style, float pointSize) throws IOException, FontFormatException, IllegalArgumentException {
        Font toReturn = ResourceLoader.getResourceAsFont(resourceName);
        toReturn = toReturn.deriveFont(style, pointSize);
        return toReturn;
    }

    public static Class[] getClasses(String packagename) {
        Class[] classesInPackage = null;
        LinkedList classes = new LinkedList();
        if (packagename != null && Package.getPackage(packagename) != null) {
            String classpath = System.getProperty("java.class.path");
            StringTokenizer tok = new StringTokenizer(classpath, System.getProperty("path.separator"));
            String entryTest = packagename.replace('.', '/');
            while (tok.hasMoreTokens()) {
                String jar = tok.nextToken();
                if (jar.endsWith(".jar")) {
                    try {
                        JarFile jarfile = new JarFile(new File(jar));
                        Enumeration<JarEntry> entries = jarfile.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            if (!entry.getName().startsWith(entryTest) || !entry.getName().endsWith(".class")) continue;
                            try {
                                Class<?> classobj = Class.forName(entry.getName().replace('/', '.').substring(0, entry.getName().length() - 6));
                                classes.add(classobj);
                            }
                            catch (Throwable classobj) {
                                // empty catch block
                            }
                        }
                    }
                    catch (Exception jarfile) {}
                    continue;
                }
                try {
                    String fileSeparator = System.getProperty("file.separator");
                    String packageNameAsPath = packagename.replace('.', fileSeparator.charAt(0));
                    String packageDirName = String.valueOf(jar) + fileSeparator + packageNameAsPath;
                    File packageDir = new File(packageDirName);
                    if (!packageDir.exists() || !packageDir.isDirectory()) continue;
                    File[] classFiles = packageDir.listFiles();
                    int i = 0;
                    while (i < classFiles.length) {
                        File classFile = classFiles[i];
                        String fileName = classFile.getName();
                        int dotclassIndex = fileName.indexOf(".class");
                        if (dotclassIndex > 0) {
                            String className = String.valueOf(packagename) + "." + fileName.substring(0, dotclassIndex);
                            try {
                                Class<?> classobj = Class.forName(className);
                                classes.add(classobj);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (classes.size() > 0) {
                classesInPackage = new Class[classes.size()];
                int i = 0;
                while (i < classes.size()) {
                    classesInPackage[i] = (Class)classes.get(i);
                    ++i;
                }
            }
        }
        return classesInPackage;
    }

    public static Class[] getClasses(String packagename, Class implemented) {
        Class[] classesToReturn = null;
        Class[] classesReturned = ResourceLoader.getClasses(packagename);
        if (classesReturned != null && classesReturned.length > 0 && implemented != null) {
            LinkedList<Class> classes = new LinkedList<Class>();
            int i = 0;
            while (i < classesReturned.length) {
                block10: {
                    try {
                        if (classesReturned[i].getSuperclass() != null && classesReturned[i].getSuperclass().equals(implemented)) {
                            classes.add(classesReturned[i]);
                            break block10;
                        }
                        Class<?>[] interfaces = classesReturned[i].getInterfaces();
                        if (interfaces == null) break block10;
                        int k = 0;
                        while (k < interfaces.length) {
                            if (interfaces[k].equals(implemented)) {
                                classes.add(classesReturned[i]);
                                break;
                            }
                            ++k;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
            classesToReturn = new Class[classes.size()];
            i = 0;
            while (i < classes.size()) {
                classesToReturn[i] = (Class)classes.get(i);
                ++i;
            }
        } else if (classesReturned != null && classesReturned.length == 0) {
            classesToReturn = new Class[]{};
        }
        return classesToReturn;
    }

    private static String slashifyName(String packagestr) {
        return packagestr.startsWith("/") ? packagestr : "/" + packagestr;
    }
}

