/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

public class RuntimePlatform {
    public static final int MAC_OS_X_VERSION_UNDEFINED = -1;
    public static final int MAC_OS_X_VERSION_10_2_JAGUAR = 2;
    public static final int MAC_OS_X_VERSION_10_3_PANTHER = 3;
    public static final int MAC_OS_X_VERSION_10_4_TIGER = 4;
    public static final int MAC_OS_X_VERSION_10_5_LEOPARD = 5;
    private static boolean isJava15;
    private static boolean isOracleJava;
    private static boolean isMac;
    private static boolean isIntelMac;
    private static int macOsVersion;
    private static boolean isWindows;
    private static boolean isUnix;
    private static boolean isDec;
    private static boolean isIrix;
    private static boolean isSolaris;
    private static boolean isLinux;
    private static boolean forceEsstix;

    static {
        String osArch;
        isJava15 = false;
        isOracleJava = true;
        isMac = false;
        isIntelMac = false;
        macOsVersion = -1;
        isWindows = false;
        isUnix = false;
        isDec = false;
        isIrix = false;
        isSolaris = false;
        isLinux = false;
        forceEsstix = false;
        String osName = System.getProperty("os.name");
        String javaVersion = System.getProperty("java.version");
        if (javaVersion != null) {
            isJava15 = javaVersion.startsWith("1.5");
        }
        if (osName.startsWith("Mac")) {
            isMac = true;
            if (javaVersion != null && (javaVersion.startsWith("1.5") || javaVersion.startsWith("1.6"))) {
                isOracleJava = false;
            }
            try {
                String osVersion = System.getProperty("os.version");
                char v = osVersion.charAt(3);
                macOsVersion = v - 48;
            }
            catch (SecurityException se) {
                macOsVersion = -1;
            }
        } else if (osName.startsWith("Win")) {
            isWindows = true;
        } else {
            isUnix = true;
            isIrix = osName.startsWith("Irix");
            isDec = osName.startsWith("OSF");
            isSolaris = osName.startsWith("Solaris");
            isLinux = osName.startsWith("Linux");
        }
        if (isMac && (osArch = System.getProperty("os.arch")) != null && osArch.startsWith("i386")) {
            isIntelMac = true;
        }
    }

    private RuntimePlatform() {
    }

    public static boolean isMac() {
        return isMac;
    }

    public static boolean isIntelMac() {
        return isIntelMac;
    }

    public static int getMacOSVersion() {
        return macOsVersion;
    }

    public static boolean isMac_10_2() {
        return RuntimePlatform.getMacOSVersion() == 2;
    }

    public static boolean isJava15() {
        return false;
    }

    public static boolean isOracleJava() {
        return isOracleJava;
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isUnix() {
        return isUnix;
    }

    public static boolean isDec() {
        return isDec;
    }

    public static boolean isIrix() {
        return isIrix;
    }

    public static boolean isSolaris() {
        return isSolaris;
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static void setOS(String os) {
        if (os != null) {
            isWindows = false;
            isMac = false;
            isUnix = false;
            isDec = false;
            isIrix = false;
            isSolaris = false;
            isLinux = false;
            if (os.equalsIgnoreCase("win")) {
                isWindows = true;
            } else if (os.equalsIgnoreCase("mac")) {
                isMac = true;
            } else if (os.equalsIgnoreCase("unix")) {
                isUnix = true;
            }
        }
    }

    public static boolean isEsstix() {
        return forceEsstix || RuntimePlatform.isMac();
    }

    public static void setEsstix(boolean isEsstix) {
        forceEsstix = isEsstix;
    }
}

