/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import com.maplesoft.util.RuntimePlatform;
import com.maplesoft.util.StringTools;
import com.maplesoft.util.encoder.AbstractStringEncoder;
import com.maplesoft.util.encoder.ShiftJISEncoder;

public class StringToolsJapanese {
    public static final int LOW_JAPANESE_UNICODE = 12288;
    public static final int HIGH_JAPANESE_UNICODE = 40879;
    public static final int LOW_JAPANESE_UNICODE_HW = 65280;
    public static final int HIGH_JAPANESE_UNICODE_HW = 65519;
    public static final int NUM_JAPANESE_FONTS = 4;
    public static final String[] JAPANESE_FONT_NAMES = new String[4];
    public static final String[] JAPANESE_FONT_ALTERNATE_NAMES = new String[4];
    public static final String MINCHO_FONT_NAME;
    public static final String MINCHO_ALTERNATE_NAME;
    public static final String PMINCHO_FONT_NAME;
    public static final String PMINCHO_ALTERNATE_NAME;
    public static final String GOTHIC_FONT_NAME;
    public static final String GOTHIC_ALTERNATE_NAME;
    public static final String PGOTHIC_FONT_NAME;
    public static final String PGOTHIC_ALTERNATE_NAME;

    static {
        StringToolsJapanese.JAPANESE_FONT_NAMES[0] = "MS Mincho";
        MINCHO_FONT_NAME = "MS Mincho";
        StringToolsJapanese.JAPANESE_FONT_ALTERNATE_NAMES[0] = RuntimePlatform.isMac() ? "Hiragino Mincho Pro" : "\uff2d\uff33 \u660e\u671d";
        MINCHO_ALTERNATE_NAME = StringToolsJapanese.JAPANESE_FONT_ALTERNATE_NAMES[0];
        StringToolsJapanese.JAPANESE_FONT_NAMES[1] = "MS PMincho";
        PMINCHO_FONT_NAME = "MS PMincho";
        StringToolsJapanese.JAPANESE_FONT_ALTERNATE_NAMES[1] = RuntimePlatform.isMac() ? "Hiragino Mincho Pro" : "\uff2d\uff33 \uff30\u660e\u671d";
        PMINCHO_ALTERNATE_NAME = StringToolsJapanese.JAPANESE_FONT_ALTERNATE_NAMES[1];
        StringToolsJapanese.JAPANESE_FONT_NAMES[2] = "MS Gothic";
        GOTHIC_FONT_NAME = "MS Gothic";
        StringToolsJapanese.JAPANESE_FONT_ALTERNATE_NAMES[2] = RuntimePlatform.isMac() ? "Hiragino Kaku Gothic Pro" : "\uff2d\uff33 \u30b4\u30b7\u30c3\u30af";
        GOTHIC_ALTERNATE_NAME = StringToolsJapanese.JAPANESE_FONT_ALTERNATE_NAMES[2];
        StringToolsJapanese.JAPANESE_FONT_NAMES[3] = "MS PGothic";
        PGOTHIC_FONT_NAME = "MS PGothic";
        StringToolsJapanese.JAPANESE_FONT_ALTERNATE_NAMES[3] = RuntimePlatform.isMac() ? "Hiragino Kaku Gothic Pro" : "\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af";
        PGOTHIC_ALTERNATE_NAME = StringToolsJapanese.JAPANESE_FONT_ALTERNATE_NAMES[3];
    }

    public static boolean isJapaneseText(String text) {
        boolean japanese = false;
        if (text != null) {
            int size = text.length();
            int i = 0;
            while (i < size) {
                boolean inRange;
                char ch = text.charAt(i);
                boolean bl = inRange = ch >= '\u3000' && ch <= '\u9faf' || ch >= '\uff00' && ch <= '\uffef';
                if (inRange && ch != '\u300a' && ch != '\u300b') {
                    japanese = true;
                    break;
                }
                ++i;
            }
        }
        return japanese;
    }

    public static boolean isShiftJISJapaneseText(String text) {
        return StringToolsJapanese.isJapaneseText(StringToolsJapanese.shiftJISDecode(text));
    }

    public static String shiftJISEncode(String source, boolean useXmlEncoding) {
        ShiftJISEncoder encoder = new ShiftJISEncoder();
        String result = encoder.fromUnicode(source);
        if (useXmlEncoding) {
            result = AbstractStringEncoder.xmlEncode(result);
        }
        return result;
    }

    public static String shiftJISDecode(String source, boolean isOctal) {
        return StringToolsJapanese.shiftJISDecode(source);
    }

    public static String shiftJISDecode(String source) {
        ShiftJISEncoder decoder = new ShiftJISEncoder();
        String result = source;
        if (!StringToolsJapanese.isJapaneseText(source)) {
            result = decoder.toUnicode(AbstractStringEncoder.xmlDecode(source));
        }
        return result;
    }

    public static boolean isJapaneseFont(String fontName) {
        return StringToolsJapanese.isJapaneseFont(fontName, true);
    }

    public static boolean isJapaneseFont(String fontName, boolean shiftJIS) {
        String unicodeFont;
        boolean isJapanese = false;
        String string = unicodeFont = shiftJIS ? StringToolsJapanese.shiftJISDecode(fontName) : fontName;
        if (!isJapanese) {
            isJapanese = StringToolsJapanese.isJapaneseText(unicodeFont);
        }
        return isJapanese;
    }

    public static boolean isUTF8JapaneseFont(String fontName) {
        String unicodeFont = StringTools.UTF8Decode(fontName);
        return StringToolsJapanese.isJapaneseText(unicodeFont);
    }

    public static boolean isEnglishNameJapaneseFont(String fontname) {
        boolean isJapanese = false;
        int i = 0;
        while (i < 4) {
            if (fontname.equals(JAPANESE_FONT_NAMES[i])) {
                isJapanese = true;
                break;
            }
            ++i;
        }
        return isJapanese;
    }

    public static String toJapaneseFontName(String fontname) {
        String japaneseFontname = fontname;
        int i = 0;
        while (i < 4) {
            if (fontname.equals(JAPANESE_FONT_NAMES[i])) {
                japaneseFontname = JAPANESE_FONT_ALTERNATE_NAMES[i];
                break;
            }
            ++i;
        }
        return japaneseFontname;
    }
}

