/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class WheelerCompression {
    private static final int HASH_TABLE_SIZE = 4096;
    private static final char BYTE_OFFSET = ':';
    private static final char END_MARK_OFFSET = '0';

    private static int slingHash(int x, int hash) {
        int runTot = hash << 4;
        hash = (runTot += x) & 0xFFF;
        return hash;
    }

    public static String compress(InputStream data) {
        StringBuffer buffy = new StringBuffer();
        WheelerCompression.compress(data, buffy);
        return buffy.toString();
    }

    public static void compress(InputStream input, StringBuffer output) {
        WheelerOutStream nStream = new WheelerOutStream(input, output);
        int i = 0;
        int c = 0;
        int hash = 0;
        char[] table = new char[4096];
        int uc = 0;
        int bit = 0;
        int byte1 = 0;
        int bitShift = 0;
        int bitCount = 0;
        i = 0;
        while (i < 4096) {
            table[i] = '\u0000';
            ++i;
        }
        hash = 0;
        bit = 1;
        byte1 = 0;
        try {
            while ((c = nStream.read()) != -1) {
                uc = c;
                if (table[hash] == (char)uc) {
                    if ((bit <<= 1) == 64) {
                        nStream.outputChar((char)(byte1 + 58));
                        bit = 1;
                        byte1 = 0;
                    }
                } else {
                    table[hash] = (char)uc;
                    byte1 |= bit;
                    if ((bit <<= 1) == 64) {
                        nStream.outputChar((char)(byte1 + 58));
                        bit = 1;
                        byte1 = 0;
                    }
                    i = 0;
                    while (i < 8) {
                        if ((uc & 1) > 0) {
                            byte1 |= bit;
                        }
                        if ((bit <<= 1) == 64) {
                            nStream.outputChar((char)(byte1 + 58));
                            bit = 1;
                            byte1 = 0;
                        }
                        uc >>= 1;
                        ++i;
                    }
                }
                hash = WheelerCompression.slingHash(c, hash);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        bitShift = bit;
        bitCount = 0;
        while (bitShift != 0) {
            ++bitCount;
            bitShift >>= 1;
        }
        nStream.outputChar((char)(bitCount + 48));
        if (bit != 0) {
            nStream.outputChar((char)(byte1 + 58));
            bit = 1;
            byte1 = 0;
        }
    }

    public static ByteArrayOutputStream decompress(String data) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        WheelerCompression.decompress(data, out);
        return out;
    }

    /*
     * Unable to fully structure code
     */
    public static void decompress(String data, ByteArrayOutputStream output) {
        nStream_in = new WheelerInStream(data);
        i = 0;
        bit = 0;
        hash = 0;
        c = 0;
        wholeByte = 0;
        bitCount = 0L;
        table = new char[4096];
        byte1 = 0;
        i = 0;
        while (i < 4096) {
            table[i] = '\u0000';
            ++i;
        }
        hash = 0;
        bit = 6;
        wholeByte = 0;
        data = data.trim();
        bitCount = -1L;
        while (bitCount != 0L) {
            if (bit != 6) ** GOTO lbl29
            if (!nStream_in.inputChar()) break;
            c = nStream_in.m_currentChar;
            if (c >= 48 && c < 58) {
                bitCount = c - 48 + 1;
            } else {
                bit = 0;
                c -= 58;
lbl29:
                // 2 sources

                if (wholeByte > 0) {
                    byte1 |= (c & '\u0001') << 8 - wholeByte;
                    if (--wholeByte == 0) {
                        output.write((byte)byte1);
                        table[hash] = (char)byte1;
                        hash = WheelerCompression.slingHash(byte1, hash);
                    }
                } else if ((c & 1) > 0) {
                    byte1 = 0;
                    wholeByte = 8;
                } else {
                    byte1 = table[hash];
                    output.write((byte)byte1);
                    hash = WheelerCompression.slingHash(byte1, hash);
                }
                c >>= 1;
                ++bit;
            }
            --bitCount;
        }
    }

    private static class WheelerInStream {
        private String m_data;
        protected char m_currentChar;
        private int m_index;

        WheelerInStream(String data) {
            this.m_data = data;
            this.m_currentChar = '\u0000';
            this.m_index = 0;
        }

        private boolean getch() {
            boolean ret = false;
            do {
                if (this.m_index < this.m_data.length()) {
                    this.m_currentChar = this.m_data.charAt(this.m_index++);
                    ret = true;
                    continue;
                }
                ret = false;
            } while (this.m_currentChar == '\n' || this.m_currentChar < ' ' || this.m_currentChar > '~');
            return ret;
        }

        protected boolean inputChar() {
            char ch = '\u0000';
            StringBuffer buffer = new StringBuffer(3);
            boolean escaped = false;
            while (true) {
                if (!this.getch()) {
                    return false;
                }
                ch = this.m_currentChar;
                if (escaped) {
                    escaped = false;
                    if (Character.isDigit(this.m_currentChar)) {
                        buffer.setCharAt(0, this.m_currentChar);
                        if (!this.getch()) {
                            return false;
                        }
                        buffer.setCharAt(1, this.m_currentChar);
                        if (!this.getch()) {
                            return false;
                        }
                        buffer.setCharAt(2, this.m_currentChar);
                        int nBuffer = Integer.parseInt(buffer.toString());
                        String octal = Integer.toOctalString(nBuffer);
                        int nOctal = Integer.parseInt(octal);
                        this.m_currentChar = (char)nOctal;
                        if (this.m_currentChar == '\r') {
                            this.m_currentChar = (char)10;
                        }
                        return true;
                    }
                    if (ch == 'n') {
                        this.m_currentChar = (char)10;
                        return true;
                    }
                    if (ch == '+') continue;
                    this.m_currentChar = ch;
                    return true;
                }
                if (ch == '\"') {
                    return false;
                }
                if (ch != '\\') break;
                escaped = true;
            }
            this.m_currentChar = ch;
            return true;
        }
    }

    private static class WheelerOutStream {
        private InputStream m_data;
        private StringBuffer m_out;

        WheelerOutStream(InputStream data, StringBuffer output) {
            this.m_data = data;
            this.m_out = output;
        }

        protected void outputChar(char ch) {
            if (ch >= ' ' && ch <= '~') {
                this.m_out.append(ch);
            } else {
                String strOctal = Integer.toOctalString(ch);
                this.m_out.append(String.valueOf('\\') + strOctal);
            }
        }

        protected int read() throws IOException {
            return this.m_data.read();
        }
    }
}

