/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import java.net.URL;
import java.net.URLClassLoader;

public class WmiProfilingClassLoader
extends URLClassLoader {
    public static final int WARN_OVERTIME = 50;
    private long classTime;
    private long slowTime;
    private int classCount;

    public WmiProfilingClassLoader(URL[] urls) {
        super(urls, (ClassLoader)null);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        long before = System.currentTimeMillis();
        try {
            Class<?> clazz = super.loadClass(name, resolve);
            return clazz;
        }
        finally {
            long after = System.currentTimeMillis();
            long time = after - before;
            this.classTime += time;
            ++this.classCount;
            if (time > 50L) {
                this.slowTime += time;
            }
        }
    }

    public int getClassCount() {
        return this.classCount;
    }
}

