/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import com.maplesoft.util.WmiStartupMonitor;
import java.lang.reflect.Method;

public class WmiStartup {
    protected static boolean printTiming = false;
    protected static long startTime = System.currentTimeMillis();
    private static long expectedTime;
    private static long expectedClassCount;
    private static Method classcountMethod;
    private static WmiStartupMonitor startupMonitor;
    private static Object startupWaiters;

    static {
        startupWaiters = new Object();
    }

    private WmiStartup() {
    }

    public static void setExpectedStartupTime(long ms) {
        expectedTime = ms;
    }

    public static void setExpectedClassCount(int cc) {
        expectedClassCount = cc;
    }

    protected static boolean startupPercentageKnown() {
        return expectedTime != 0L || expectedClassCount != 0L;
    }

    public static long getTime() {
        long time = System.currentTimeMillis() - startTime;
        return time;
    }

    public static long estimateTimeLeft() {
        return Math.max(expectedTime - WmiStartup.getTime(), 0L);
    }

    public static int getClassCount() {
        try {
            ClassLoader cl = WmiStartup.class.getClassLoader();
            if (classcountMethod == null) {
                classcountMethod = cl.getClass().getMethod("getClassCount", null);
            }
            Integer ret = (Integer)classcountMethod.invoke((Object)cl, null);
            return ret;
        }
        catch (NoSuchMethodException nsme) {
            return 0;
        }
        catch (Exception e) {
            System.err.println("EXCEPTION: " + e);
            e.printStackTrace();
            return 0;
        }
    }

    protected static void debugPrint(String output) {
    }

    public static int percentDone() {
        int p = 0;
        int div = 0;
        if (expectedTime != 0L) {
            ++div;
            p += (int)((double)WmiStartup.getTime() * 100.0 / (double)expectedTime);
        }
        if (expectedClassCount != 0L) {
            ++div;
            p += (int)((double)WmiStartup.getClassCount() * 100.0 / (double)expectedClassCount);
        }
        if (div == 0) {
            return 0;
        }
        return p / div;
    }

    public static void progress(String text) {
        if (startupMonitor != null) {
            startupMonitor.showProgress(WmiStartup.percentDone());
        }
    }

    public static void setStartupMonitor(WmiStartupMonitor sm) {
        assert (sm != null) : "call startupComplete instead";
        startupMonitor = sm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startupComplete() {
        startupMonitor = null;
        Object object = startupWaiters;
        synchronized (object) {
            startupWaiters.notifyAll();
            startupWaiters = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForStartupCompletion(int sleepTime) {
        if (startupWaiters != null) {
            try {
                Object object = startupWaiters;
                synchronized (object) {
                    startupWaiters.wait(WmiStartup.estimateTimeLeft() + 10000L);
                }
                if (sleepTime > 0) {
                    Thread.sleep(sleepTime);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

