/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

public class WmiStringParseTools {
    private static final char[] infinity = new char[]{'I', 'n', 'f', 'i', 'n', 'i', 't', 'y'};
    private static final char[] notANumber = new char[]{'N', 'a', 'N'};
    private static final char[] zero = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
    private static final long signMask = Long.MIN_VALUE;
    private static final long expMask = 0x7FF0000000000000L;
    private static final long fractMask = 0xFFFFFFFFFFFFFL;
    private static final int expShift = 52;
    private static final int expBias = 1023;
    private static final long fractHOB = 0x10000000000000L;
    private static final int maxDecimalDigits = 15;
    private static final int maxDecimalExponent = 308;
    private static final int minDecimalExponent = -324;
    private static final int bigDecimalExponent = 324;
    private static final long highbyte = -72057594037927936L;
    private static final long lowbytes = 0xFFFFFFFFFFFFFFL;
    private static final int singleMaxDecimalDigits = 7;
    private static final int singleMaxDecimalExponent = 38;
    private static final int singleMinDecimalExponent = -45;
    private static final int intDecimalDigits = 9;
    private static final char[] digitsBuffer = new char[20];
    private static final double[] small10pow = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
    private static final float[] singleSmall10pow = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f};
    private static final double[] big10pow = new double[]{1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};
    private static final double[] tiny10pow = new double[]{1.0E-16, 1.0E-32, 1.0E-64, 1.0E-128, 1.0E-256};
    private static final int maxSmallTen = small10pow.length - 1;
    private static final int singleMaxSmallTen = singleSmall10pow.length - 1;
    private static final int[] small5pow = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
    private static final long[] long5pow = new long[]{1L, 5L, 25L, 125L, 625L, 3125L, 15625L, 78125L, 390625L, 1953125L, 9765625L, 48828125L, 244140625L, 1220703125L, 6103515625L, 30517578125L, 152587890625L, 762939453125L, 3814697265625L, 19073486328125L, 95367431640625L, 476837158203125L, 2384185791015625L, 11920928955078125L, 59604644775390625L, 298023223876953125L, 1490116119384765625L};
    private static FDBigInt[] b5p;

    private WmiStringParseTools() {
    }

    public static int parseInt(String s, int start, int end) throws NumberFormatException {
        int radix = 10;
        int result = 0;
        boolean negative = false;
        int i = start;
        int max = end;
        if (max > 0) {
            int digit;
            int limit;
            if (s.charAt(i) == '-') {
                negative = true;
                limit = Integer.MIN_VALUE;
                ++i;
            } else {
                limit = -2147483647;
            }
            int multmin = limit / 10;
            if (i < max) {
                if ((digit = Character.digit(s.charAt(i++), 10)) < 0) {
                    throw new NumberFormatException(s);
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = Character.digit(s.charAt(i++), 10)) < 0) {
                    throw new NumberFormatException(s);
                }
                if (result < multmin) {
                    throw new NumberFormatException(s);
                }
                if ((result *= 10) < limit + digit) {
                    throw new NumberFormatException(s);
                }
                result -= digit;
            }
        } else {
            throw new NumberFormatException(s);
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException(s);
        }
        return -result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static float parseFloat(String in, int start, int end) throws NumberFormatException {
        isNegative = false;
        signSeen = false;
        try {
            while (Character.isWhitespace(in.charAt(start)) && start < end) {
                ++start;
            }
            while (Character.isWhitespace(in.charAt(end)) && start < end) {
                --end;
            }
            l = end - start;
            if (l == 0) {
                throw new NumberFormatException("empty String");
            }
            i = start;
            c = in.charAt(i);
            switch (c) {
                case '-': {
                    isNegative = true;
                }
                case '+': {
                    ++i;
                    signSeen = true;
                }
            }
            c = in.charAt(i);
            if (c == 'N' || c == 'I') {
                potentialNaN = false;
                targetChars = null;
                if (c == 'N') {
                    targetChars = WmiStringParseTools.notANumber;
                    potentialNaN = true;
                } else {
                    targetChars = WmiStringParseTools.infinity;
                }
                j = 0;
                while (i < l && j < targetChars.length) {
                    if (in.charAt(i) == targetChars[j]) {
                        ++i;
                        ++j;
                        continue;
                    }
                    ** break block42
                }
                if (j == targetChars.length && i == l) {
                    return potentialNaN != false ? NaNf : (isNegative != false ? -Infinityf : Infinityf);
                }
                ** break block42
            }
            var9_10 = WmiStringParseTools.digitsBuffer;
            synchronized (WmiStringParseTools.digitsBuffer) {
                digits = l <= WmiStringParseTools.digitsBuffer.length ? WmiStringParseTools.digitsBuffer : new char[l];
                nDigits = 0;
                decSeen = false;
                decPt = 0;
                nLeadZero = 0;
                nTrailZero = 0;
                block24: while (i < l) {
                    c = in.charAt(i);
                    switch (c) {
                        case '0': {
                            if (nDigits > 0) {
                                ++nTrailZero;
                                break;
                            }
                            ++nLeadZero;
                            break;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            while (nTrailZero > 0) {
                                digits[nDigits++] = 48;
                                --nTrailZero;
                            }
                            digits[nDigits++] = c;
                            break;
                        }
                        case '.': {
                            if (decSeen) {
                                throw new NumberFormatException("multiple points");
                            }
                            decPt = i;
                            if (signSeen) {
                                --decPt;
                            }
                            decSeen = true;
                            break;
                        }
                        default: {
                            break block24;
                        }
                    }
                    ++i;
                }
                if (nDigits == 0) {
                    digits = WmiStringParseTools.zero;
                    nDigits = 1;
                    if (nLeadZero == 0) {
                        // ** MonitorExit[var9_10] (shouldn't be in output)
                        ** break block42
                    }
                }
                decExp = decSeen != false ? decPt - nLeadZero : nDigits + nTrailZero;
                if (i < l && (c = in.charAt(i)) == 'e' || c == 'E') {
                    expSign = 1;
                    expVal = 0;
                    reallyBig = 0xCCCCCCC;
                    expOverflow = false;
                    switch (in.charAt(++i)) {
                        case '-': {
                            expSign = -1;
                        }
                        case '+': {
                            ++i;
                        }
                    }
                    expAt = i;
                    block26: while (i < l) {
                        if (expVal >= reallyBig) {
                            expOverflow = true;
                        }
                        c = in.charAt(i++);
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                expVal = expVal * 10 + (c - 48);
                                break;
                            }
                            default: {
                                --i;
                                break block26;
                            }
                        }
                    }
                    expLimit = 324 + nDigits + nTrailZero;
                    decExp = expOverflow || expVal > expLimit ? expSign * expLimit : (decExp += expSign * expVal);
                    if (i == expAt) {
                        // ** MonitorExit[var9_10] (shouldn't be in output)
                        ** break block42
                    }
                }
                if (i < l && (i != l - 1 || in.charAt(i) != 'f' && in.charAt(i) != 'F' && in.charAt(i) != 'd' && in.charAt(i) != 'D')) {
                    // ** MonitorExit[var9_10] (shouldn't be in output)
                    ** break block42
                }
                // ** MonitorExit[var9_10] (shouldn't be in output)
                return WmiStringParseTools.floatValue(isNegative, decExp, digits, nDigits, false);
            }
        }
        catch (StringIndexOutOfBoundsException var7_6) {
            // empty catch block
        }
lbl-1000:
        // 6 sources

        {
            throw new NumberFormatException(in);
        }
    }

    private static float floatValue(boolean isNegative, int decExponent, char[] digits, int nDigits, boolean isExceptional) {
        int kDigits = Math.min(nDigits, 8);
        if (digits == infinity || digits == notANumber) {
            if (digits == notANumber) {
                return Float.NaN;
            }
            return isNegative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        int iValue = digits[0] - 48;
        int i = 1;
        while (i < kDigits) {
            iValue = iValue * 10 + digits[i] - 48;
            ++i;
        }
        float fValue = iValue;
        int exp = decExponent - kDigits;
        if (nDigits <= 7) {
            if (exp == 0 || fValue == 0.0f) {
                return isNegative ? -fValue : fValue;
            }
            if (exp >= 0) {
                if (exp <= singleMaxSmallTen) {
                    return isNegative ? -fValue : (fValue *= singleSmall10pow[exp]);
                }
                int slop = 7 - kDigits;
                if (exp <= singleMaxSmallTen + slop) {
                    fValue *= singleSmall10pow[slop];
                    return isNegative ? -fValue : (fValue *= singleSmall10pow[exp - slop]);
                }
            } else if (exp >= -singleMaxSmallTen) {
                return isNegative ? -fValue : (fValue /= singleSmall10pow[-exp]);
            }
        } else if (decExponent >= nDigits && nDigits + decExponent <= 15) {
            long lValue = iValue;
            int i2 = kDigits;
            while (i2 < nDigits) {
                lValue = lValue * 10L + (long)(digits[i2] - 48);
                ++i2;
            }
            double dValue = lValue;
            exp = decExponent - nDigits;
            fValue = (float)(dValue *= small10pow[exp]);
            return isNegative ? -fValue : fValue;
        }
        if (decExponent > 39) {
            return isNegative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        if (decExponent < -46) {
            return isNegative ? -0.0f : 0.0f;
        }
        double dValue = WmiStringParseTools.doubleValue(isNegative, decExponent, digits, nDigits, isExceptional, true);
        return WmiStringParseTools.stickyRound(dValue);
    }

    private static float stickyRound(double dval) {
        long lbits = Double.doubleToLongBits(dval);
        long binexp = lbits & 0x7FF0000000000000L;
        if (binexp == 0L || binexp == 0x7FF0000000000000L) {
            return (float)dval;
        }
        return (float)Double.longBitsToDouble(lbits);
    }

    private static double doubleValue(boolean isNegative, int decExponent, char[] digits, int nDigits, boolean isExceptional, boolean mustSetRoundDir) {
        boolean overvalue;
        double t;
        int j;
        int kDigits = Math.min(nDigits, 16);
        if (digits == infinity || digits == notANumber) {
            if (digits == notANumber) {
                return Double.NaN;
            }
            return isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        int roundDir = 0;
        int iValue = digits[0] - 48;
        int iDigits = Math.min(kDigits, 9);
        int i = 1;
        while (i < iDigits) {
            iValue = iValue * 10 + digits[i] - 48;
            ++i;
        }
        long lValue = iValue;
        i = iDigits;
        while (i < kDigits) {
            lValue = lValue * 10L + (long)(digits[i] - 48);
            ++i;
        }
        double dValue = lValue;
        int exp = decExponent - kDigits;
        if (nDigits <= 15) {
            if (exp == 0 || dValue == 0.0) {
                return isNegative ? -dValue : dValue;
            }
            if (exp >= 0) {
                if (exp <= maxSmallTen) {
                    double rValue = dValue * small10pow[exp];
                    if (mustSetRoundDir) {
                        double tValue = rValue / small10pow[exp];
                        roundDir = tValue == dValue ? 0 : (tValue < dValue ? 1 : -1);
                    }
                    return isNegative ? -rValue : rValue;
                }
                int slop = 15 - kDigits;
                if (exp <= maxSmallTen + slop) {
                    double rValue = (dValue *= small10pow[slop]) * small10pow[exp - slop];
                    if (mustSetRoundDir) {
                        double tValue = rValue / small10pow[exp - slop];
                        roundDir = tValue == dValue ? 0 : (tValue < dValue ? 1 : -1);
                    }
                    return isNegative ? -rValue : rValue;
                }
            } else if (exp >= -maxSmallTen) {
                double rValue = dValue / small10pow[-exp];
                double tValue = rValue * small10pow[-exp];
                if (mustSetRoundDir) {
                    roundDir = tValue == dValue ? 0 : (tValue < dValue ? 1 : -1);
                }
                return isNegative ? -rValue : rValue;
            }
        }
        if (exp > 0) {
            if (decExponent > 309) {
                return isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if ((exp & 0xF) != 0) {
                dValue *= small10pow[exp & 0xF];
            }
            if ((exp >>= 4) != 0) {
                j = 0;
                while (exp > 1) {
                    if ((exp & 1) != 0) {
                        dValue *= big10pow[j];
                    }
                    ++j;
                    exp >>= 1;
                }
                t = dValue * big10pow[j];
                if (Double.isInfinite(t)) {
                    t = dValue / 2.0;
                    if (Double.isInfinite(t *= big10pow[j])) {
                        return isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                    }
                    t = Double.MAX_VALUE;
                }
                dValue = t;
            }
        } else if (exp < 0) {
            exp = -exp;
            if (decExponent < -325) {
                return isNegative ? -0.0 : 0.0;
            }
            if ((exp & 0xF) != 0) {
                dValue /= small10pow[exp & 0xF];
            }
            if ((exp >>= 4) != 0) {
                j = 0;
                while (exp > 1) {
                    if ((exp & 1) != 0) {
                        dValue *= tiny10pow[j];
                    }
                    ++j;
                    exp >>= 1;
                }
                t = dValue * tiny10pow[j];
                if (t == 0.0) {
                    t = dValue * 2.0;
                    if ((t *= tiny10pow[j]) == 0.0) {
                        return isNegative ? -0.0 : 0.0;
                    }
                    t = Double.MIN_VALUE;
                }
                dValue = t;
            }
        }
        FDBigInt bigD0 = new FDBigInt(lValue, digits, kDigits, nDigits);
        exp = decExponent - nDigits;
        int bigIntExp = 0;
        int bigIntNBits = 0;
        do {
            FDBigInt halfUlp;
            FDBigInt diff;
            int D2;
            int D5;
            int B2;
            int B5;
            long lbits = Double.doubleToLongBits(dValue) & Long.MAX_VALUE;
            int binexp = (int)(lbits >>> 52);
            lbits &= 0xFFFFFFFFFFFFFL;
            if (binexp > 0) {
                lbits |= 0x10000000000000L;
            } else {
                assert (lbits != 0L) : lbits;
                ++binexp;
                while ((lbits & 0x10000000000000L) == 0L) {
                    lbits <<= 1;
                    --binexp;
                }
            }
            int nbits = WmiStringParseTools.countBits(lbits);
            int lowOrderZeros = 53 - nbits;
            bigIntExp = (binexp -= 1023) + 1 - nbits;
            bigIntNBits = nbits;
            FDBigInt bigB = new FDBigInt(lbits >>>= lowOrderZeros);
            if (exp >= 0) {
                B5 = 0;
                B2 = 0;
                D2 = D5 = exp;
            } else {
                B2 = B5 = -exp;
                D5 = 0;
                D2 = 0;
            }
            if (bigIntExp >= 0) {
                B2 += bigIntExp;
            } else {
                D2 -= bigIntExp;
            }
            int Ulp2 = B2;
            int hulpbias = bigIntExp + bigIntNBits <= -1022 ? bigIntExp + 1023 + 52 : 54 - bigIntNBits;
            int common2 = Math.min(B2 += hulpbias, Math.min(D2 += hulpbias, Ulp2));
            Ulp2 -= common2;
            bigB = WmiStringParseTools.multPow52(bigB, B5, B2 -= common2);
            FDBigInt bigD = WmiStringParseTools.multPow52(new FDBigInt(bigD0), D5, D2 -= common2);
            int cmpResult = bigB.cmp(bigD);
            if (cmpResult > 0) {
                overvalue = true;
                diff = bigB.sub(bigD);
                if (bigIntNBits == 1 && bigIntExp > -1023 && --Ulp2 < 0) {
                    Ulp2 = 0;
                    diff.lshiftMe(1);
                }
            } else {
                if (cmpResult >= 0) break;
                overvalue = false;
                diff = bigD.sub(bigB);
            }
            if ((cmpResult = diff.cmp(halfUlp = WmiStringParseTools.constructPow52(B5, Ulp2))) < 0) {
                roundDir = overvalue ? -1 : 1;
                break;
            }
            if (cmpResult != 0) continue;
            dValue += 0.5 * WmiStringParseTools.ulp(dValue, overvalue);
            roundDir = overvalue ? -1 : 1;
            break;
        } while ((dValue += WmiStringParseTools.ulp(dValue, overvalue)) != 0.0 && dValue != Double.POSITIVE_INFINITY);
        return isNegative ? -dValue : dValue;
    }

    /*
     * Unable to fully structure code
     */
    private static int countBits(long v) {
        if (v != 0L) ** GOTO lbl4
        return 0;
lbl-1000:
        // 1 sources

        {
            v <<= 8;
lbl4:
            // 2 sources

            ** while ((v & -72057594037927936L) == 0L)
        }
lbl5:
        // 2 sources

        while (v > 0L) {
            v <<= 1;
        }
        n = 0;
        while ((v & 0xFFFFFFFFFFFFFFL) != 0L) {
            v <<= 8;
            n += 8;
        }
        while (v != 0L) {
            v <<= 1;
            ++n;
        }
        return n;
    }

    private static FDBigInt multPow52(FDBigInt v, int p5, int p2) {
        if (p5 != 0) {
            v = p5 < small5pow.length ? v.mult(small5pow[p5]) : v.mult(WmiStringParseTools.big5pow(p5));
        }
        if (p2 != 0) {
            v.lshiftMe(p2);
        }
        return v;
    }

    private static synchronized FDBigInt big5pow(int p) {
        assert (p >= 0) : p;
        if (b5p == null) {
            b5p = new FDBigInt[p + 1];
        } else if (b5p.length <= p) {
            FDBigInt[] t = new FDBigInt[p + 1];
            System.arraycopy(b5p, 0, t, 0, b5p.length);
            b5p = t;
        }
        if (b5p[p] != null) {
            return b5p[p];
        }
        if (p < small5pow.length) {
            WmiStringParseTools.b5p[p] = new FDBigInt(small5pow[p]);
            return WmiStringParseTools.b5p[p];
        }
        if (p < long5pow.length) {
            WmiStringParseTools.b5p[p] = new FDBigInt(long5pow[p]);
            return WmiStringParseTools.b5p[p];
        }
        int q = p >> 1;
        int r = p - q;
        FDBigInt bigq = b5p[q];
        if (bigq == null) {
            bigq = WmiStringParseTools.big5pow(q);
        }
        if (r < small5pow.length) {
            WmiStringParseTools.b5p[p] = bigq.mult(small5pow[r]);
            return WmiStringParseTools.b5p[p];
        }
        FDBigInt bigr = b5p[r];
        if (bigr == null) {
            bigr = WmiStringParseTools.big5pow(r);
        }
        WmiStringParseTools.b5p[p] = bigq.mult(bigr);
        return WmiStringParseTools.b5p[p];
    }

    private static FDBigInt constructPow52(int p5, int p2) {
        FDBigInt v = new FDBigInt(WmiStringParseTools.big5pow(p5));
        if (p2 != 0) {
            v.lshiftMe(p2);
        }
        return v;
    }

    private static double ulp(double dval, boolean subtracting) {
        long lbits = Double.doubleToLongBits(dval) & Long.MAX_VALUE;
        int binexp = (int)(lbits >>> 52);
        if (subtracting && binexp >= 52 && (lbits & 0xFFFFFFFFFFFFFL) == 0L) {
            --binexp;
        }
        double ulpval = binexp > 52 ? Double.longBitsToDouble((long)(binexp - 52) << 52) : (binexp == 0 ? Double.MIN_VALUE : Double.longBitsToDouble(1L << binexp - 1));
        if (subtracting) {
            ulpval = -ulpval;
        }
        return ulpval;
    }

    private static class FDBigInt {
        int nWords;
        int[] data;

        public FDBigInt(int v) {
            this.nWords = 1;
            this.data = new int[1];
            this.data[0] = v;
        }

        public FDBigInt(long v) {
            this.data = new int[2];
            this.data[0] = (int)v;
            this.data[1] = (int)(v >>> 32);
            this.nWords = this.data[1] == 0 ? 1 : 2;
        }

        public FDBigInt(FDBigInt other) {
            this.nWords = other.nWords;
            this.data = new int[this.nWords];
            System.arraycopy(other.data, 0, this.data, 0, this.nWords);
        }

        private FDBigInt(int[] d, int n) {
            this.data = d;
            this.nWords = n;
        }

        public FDBigInt(long seed, char[] digit, int nd0, int nd) {
            int v;
            int n = (nd + 8) / 9;
            if (n < 2) {
                n = 2;
            }
            this.data = new int[n];
            this.data[0] = (int)seed;
            this.data[1] = (int)(seed >>> 32);
            this.nWords = this.data[1] == 0 ? 1 : 2;
            int i = nd0;
            int limit = nd - 5;
            while (i < limit) {
                int ilim = i + 5;
                v = digit[i++] - 48;
                while (i < ilim) {
                    v = 10 * v + digit[i++] - 48;
                }
                this.multaddMe(100000, v);
            }
            int factor = 1;
            v = 0;
            while (i < nd) {
                v = 10 * v + digit[i++] - 48;
                factor *= 10;
            }
            if (factor != 1) {
                this.multaddMe(factor, v);
            }
        }

        public void lshiftMe(int c) throws IllegalArgumentException {
            if (c <= 0) {
                if (c == 0) {
                    return;
                }
                throw new IllegalArgumentException("negative shift count");
            }
            int wordcount = c >> 5;
            int bitcount = c & 0x1F;
            int anticount = 32 - bitcount;
            int[] t = this.data;
            int[] s = this.data;
            if (this.nWords + wordcount + 1 > t.length) {
                t = new int[this.nWords + wordcount + 1];
            }
            int target = this.nWords + wordcount;
            int src = this.nWords - 1;
            if (bitcount == 0) {
                System.arraycopy(s, 0, t, wordcount, this.nWords);
                target = wordcount - 1;
            } else {
                t[target--] = s[src] >>> anticount;
                while (src >= 1) {
                    t[target--] = s[src] << bitcount | s[--src] >>> anticount;
                }
                t[target--] = s[src] << bitcount;
            }
            while (target >= 0) {
                t[target--] = 0;
            }
            this.data = t;
            this.nWords += wordcount + 1;
            while (this.nWords > 1 && this.data[this.nWords - 1] == 0) {
                --this.nWords;
            }
        }

        /*
         * Unable to fully structure code
         */
        public int normalizeMe() throws IllegalArgumentException {
            block6: {
                wordcount = 0;
                bitcount = 0;
                v = 0;
                src = this.nWords - 1;
                while (src >= 0 && (v = this.data[src]) == 0) {
                    ++wordcount;
                    --src;
                }
                if (src < 0) {
                    throw new IllegalArgumentException("zero value");
                }
                this.nWords -= wordcount;
                if ((v & -268435456) == 0) ** GOTO lbl21
                bitcount = 32;
                while ((v & -268435456) != 0) {
                    v >>>= 1;
                    --bitcount;
                }
                break block6;
lbl-1000:
                // 1 sources

                {
                    v <<= 8;
                    bitcount += 8;
lbl21:
                    // 2 sources

                    ** while (v <= 1048575)
                }
lbl22:
                // 2 sources

                while (v <= 0x7FFFFFF) {
                    v <<= 1;
                    ++bitcount;
                }
            }
            if (bitcount != 0) {
                this.lshiftMe(bitcount);
            }
            return bitcount;
        }

        public FDBigInt mult(int iv) {
            long v = iv;
            int[] r = new int[v * ((long)this.data[this.nWords - 1] & 0xFFFFFFFFL) > 0xFFFFFFFL ? this.nWords + 1 : this.nWords];
            long p = 0L;
            int i = 0;
            while (i < this.nWords) {
                r[i] = (int)(p += v * ((long)this.data[i] & 0xFFFFFFFFL));
                p >>>= 32;
                ++i;
            }
            if (p == 0L) {
                return new FDBigInt(r, this.nWords);
            }
            r[this.nWords] = (int)p;
            return new FDBigInt(r, this.nWords + 1);
        }

        public void multaddMe(int iv, int addend) {
            long v = iv;
            long p = v * ((long)this.data[0] & 0xFFFFFFFFL) + ((long)addend & 0xFFFFFFFFL);
            this.data[0] = (int)p;
            p >>>= 32;
            int i = 1;
            while (i < this.nWords) {
                this.data[i] = (int)(p += v * ((long)this.data[i] & 0xFFFFFFFFL));
                p >>>= 32;
                ++i;
            }
            if (p != 0L) {
                this.data[this.nWords] = (int)p;
                ++this.nWords;
            }
        }

        public FDBigInt mult(FDBigInt other) {
            int[] r = new int[this.nWords + other.nWords];
            int i = 0;
            while (i < this.nWords) {
                long v = (long)this.data[i] & 0xFFFFFFFFL;
                long p = 0L;
                int j = 0;
                while (j < other.nWords) {
                    r[i + j] = (int)(p += ((long)r[i + j] & 0xFFFFFFFFL) + v * ((long)other.data[j] & 0xFFFFFFFFL));
                    p >>>= 32;
                    ++j;
                }
                r[i + j] = (int)p;
                ++i;
            }
            i = r.length - 1;
            while (i > 0) {
                if (r[i] != 0) break;
                --i;
            }
            return new FDBigInt(r, i + 1);
        }

        public FDBigInt add(FDBigInt other) {
            int m;
            int[] b;
            int n;
            int[] a;
            long c = 0L;
            if (this.nWords >= other.nWords) {
                a = this.data;
                n = this.nWords;
                b = other.data;
                m = other.nWords;
            } else {
                a = other.data;
                n = other.nWords;
                b = this.data;
                m = this.nWords;
            }
            int[] r = new int[n];
            int i = 0;
            while (i < n) {
                c += (long)a[i] & 0xFFFFFFFFL;
                if (i < m) {
                    c += (long)b[i] & 0xFFFFFFFFL;
                }
                r[i] = (int)c;
                c >>= 32;
                ++i;
            }
            if (c != 0L) {
                int[] s = new int[r.length + 1];
                System.arraycopy(r, 0, s, 0, r.length);
                s[i++] = (int)c;
                return new FDBigInt(s, i);
            }
            return new FDBigInt(r, i);
        }

        public FDBigInt sub(FDBigInt other) {
            int[] r = new int[this.nWords];
            int n = this.nWords;
            int m = other.nWords;
            int nzeros = 0;
            long c = 0L;
            int i = 0;
            while (i < n) {
                c += (long)this.data[i] & 0xFFFFFFFFL;
                if (i < m) {
                    c -= (long)other.data[i] & 0xFFFFFFFFL;
                }
                nzeros = (r[i] = (int)c) == 0 ? ++nzeros : 0;
                c >>= 32;
                ++i;
            }
            assert (c == 0L) : c;
            assert (FDBigInt.dataInRangeIsZero(i, m, other));
            return new FDBigInt(r, n - nzeros);
        }

        private static boolean dataInRangeIsZero(int i, int m, FDBigInt other) {
            while (i < m) {
                if (other.data[i++] == 0) continue;
                return false;
            }
            return true;
        }

        public int cmp(FDBigInt other) {
            int i;
            int j;
            if (this.nWords > other.nWords) {
                j = other.nWords - 1;
                i = this.nWords - 1;
                while (i > j) {
                    if (this.data[i] != 0) {
                        return 1;
                    }
                    --i;
                }
            } else if (this.nWords < other.nWords) {
                j = this.nWords - 1;
                i = other.nWords - 1;
                while (i > j) {
                    if (other.data[i] != 0) {
                        return -1;
                    }
                    --i;
                }
            } else {
                i = this.nWords - 1;
            }
            while (i > 0) {
                if (this.data[i] != other.data[i]) break;
                --i;
            }
            int a = this.data[i];
            int b = other.data[i];
            if (a < 0) {
                if (b < 0) {
                    return a - b;
                }
                return 1;
            }
            if (b < 0) {
                return -1;
            }
            return a - b;
        }

        public int quoRemIteration(FDBigInt S) throws IllegalArgumentException {
            int i;
            if (this.nWords != S.nWords) {
                throw new IllegalArgumentException("disparate values");
            }
            int n = this.nWords - 1;
            long q = ((long)this.data[n] & 0xFFFFFFFFL) / (long)S.data[n];
            long diff = 0L;
            int i2 = 0;
            while (i2 <= n) {
                this.data[i2] = (int)(diff += ((long)this.data[i2] & 0xFFFFFFFFL) - q * ((long)S.data[i2] & 0xFFFFFFFFL));
                diff >>= 32;
                ++i2;
            }
            if (diff != 0L) {
                long sum = 0L;
                while (sum == 0L) {
                    sum = 0L;
                    i = 0;
                    while (i <= n) {
                        this.data[i] = (int)(sum += ((long)this.data[i] & 0xFFFFFFFFL) + ((long)S.data[i] & 0xFFFFFFFFL));
                        sum >>= 32;
                        ++i;
                    }
                    assert (sum == 0L || sum == 1L) : sum;
                    --q;
                }
            }
            long p = 0L;
            i = 0;
            while (i <= n) {
                this.data[i] = (int)(p += 10L * ((long)this.data[i] & 0xFFFFFFFFL));
                p >>= 32;
                ++i;
            }
            assert (p == 0L) : p;
            return (int)q;
        }

        public long longValue() {
            assert (this.nWords > 0) : this.nWords;
            if (this.nWords == 1) {
                return (long)this.data[0] & 0xFFFFFFFFL;
            }
            assert (FDBigInt.dataInRangeIsZero(2, this.nWords, this));
            assert (this.data[1] >= 0);
            return (long)this.data[1] << 32 | (long)this.data[0] & 0xFFFFFFFFL;
        }

        public String toString() {
            StringBuffer r = new StringBuffer(30);
            r.append('[');
            int i = Math.min(this.nWords - 1, this.data.length - 1);
            if (this.nWords > this.data.length) {
                r.append("(" + this.data.length + "<" + this.nWords + "!)");
            }
            while (i > 0) {
                r.append(Integer.toHexString(this.data[i]));
                r.append(' ');
                --i;
            }
            r.append(Integer.toHexString(this.data[0]));
            r.append(']');
            return new String(r);
        }
    }
}

