/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class WmiXMLParserImplementation {
    private XMLReader xmlReader = this.createXMLReader();
    protected ContentHandler contentHandler;

    public WmiXMLParserImplementation(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
        if (contentHandler != null) {
            this.xmlReader.setContentHandler(contentHandler);
        }
    }

    private XMLReader createXMLReader() {
        XMLReader reader = null;
        SAXParserFactory f = SAXParserFactory.newInstance();
        try {
            SAXParser sp = f.newSAXParser();
            if (sp != null) {
                reader = sp.getXMLReader();
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        if (reader == null) {
            try {
                Class<?> readerClass = Class.forName("org.apache.crimson.parser.XMLReaderImpl");
                reader = (XMLReader)readerClass.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return reader;
    }

    public XMLReader getXMLReader() {
        return this.xmlReader;
    }

    public void parse(InputSource input) throws SAXException, IOException {
        this.xmlReader.parse(input);
    }

    public void parse(Reader reader) throws SAXException, IOException {
        this.parse(new InputSource(reader));
    }
}

