/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import com.maplesoft.util.ConversionException;
import com.maplesoft.util.ConversionStyle;
import java.io.InputStream;

public class XMLSafeStringConversion
implements ConversionStyle {
    private boolean convertStandardEntities = true;

    @Override
    public String getConversionSchemeID() {
        return "xmlsafe:";
    }

    public XMLSafeStringConversion() {
    }

    @Override
    public ConversionStyle createWithArgument(String argument) {
        return new XMLSafeStringConversion(argument);
    }

    public XMLSafeStringConversion(String argument) {
        if (argument.equals("escape-only")) {
            this.convertStandardEntities = false;
        }
    }

    @Override
    public Object convert(Object source, String targetFormat) throws ConversionException, IllegalArgumentException {
        if (!(targetFormat.equalsIgnoreCase("string") || targetFormat.equalsIgnoreCase("xml") || targetFormat.equals("java.lang.String"))) {
            throw new IllegalArgumentException("com.maplesoft.util.XMLSafeStringConversion: only supports String or XML output");
        }
        if (!(source instanceof String)) {
            throw new IllegalArgumentException("com.maplesoft.util.XMLSafeStringConversion: only supports String source");
        }
        try {
            String result = null;
            StringBuffer buf = new StringBuffer((String)source);
            int i = 0;
            while (i < buf.length()) {
                if (buf.charAt(i) == '&' && this.convertStandardEntities) {
                    buf.replace(i, i + 1, "&amp;");
                }
                ++i;
            }
            i = 0;
            while (i < buf.length()) {
                char c = buf.charAt(i);
                if (c == '\"' && this.convertStandardEntities) {
                    buf.replace(i, i + 1, "&quot;");
                } else if (c == '<' && this.convertStandardEntities) {
                    buf.replace(i, i + 1, "&lt;");
                } else if (c == '>' && this.convertStandardEntities) {
                    buf.replace(i, i + 1, "&gt;");
                } else if (c == '\'' && this.convertStandardEntities) {
                    buf.replace(i, i + 1, "&apos;");
                } else if (c == '\u0000') {
                    buf.deleteCharAt(i);
                } else if (c == '\b') {
                    buf.replace(i, i + 1, "&#8;");
                } else if (c == '\f') {
                    buf.replace(i, i + 1, "&#12;");
                } else if (c == '\n') {
                    buf.replace(i, i + 1, "&#10;");
                } else if (c == '\r') {
                    buf.replace(i, i + 1, "&#13;");
                } else if (c == '\t') {
                    buf.replace(i, i + 1, "&#9;");
                }
                ++i;
            }
            result = buf.toString();
            return result;
        }
        catch (Exception e1) {
            throw new ConversionException(e1);
        }
    }

    @Override
    public Object convert(InputStream source, String targetFormat) throws IllegalArgumentException {
        throw new IllegalArgumentException("com.maplesoft.util.XMLSafeStringConversion: does not support InputStreams");
    }
}

