/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import com.maplesoft.util.ConversionException;
import com.maplesoft.util.ConversionStyle;
import com.maplesoft.util.FormatConverter;
import com.maplesoft.util.ResourceLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XSLTConversion
implements ConversionStyle {
    private String transformSheetLocation;
    static HashMap previousConversions = new HashMap();

    public XSLTConversion() {
    }

    public XSLTConversion(String transformSheetLoc) {
        this.transformSheetLocation = transformSheetLoc;
    }

    @Override
    public String getConversionSchemeID() {
        return "XSLT:";
    }

    @Override
    public ConversionStyle createWithArgument(String argument) {
        return new XSLTConversion(argument);
    }

    @Override
    public Object convert(Object source, String targetFormat) throws ConversionException, IllegalArgumentException {
        try {
            Transformer xform = this.getTransformer();
            DOMSource src = null;
            if (source instanceof Document) {
                src = new DOMSource((Document)source);
            } else if (source instanceof String) {
                src = new DOMSource((Document)FormatConverter.convert("BuildDOM:", source, "dom"));
            } else if (source instanceof File) {
                src = new DOMSource((Document)FormatConverter.convert("BuildDOM:", source, "dom"));
            } else {
                if (source != null) {
                    throw new IllegalArgumentException("Source Object " + source + "of type " + source.getClass() + " not supported");
                }
                throw new IllegalArgumentException("Source Object cannot be null");
            }
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            xform.transform(src, result);
            Object converted = this.buildResult(sw.toString(), targetFormat);
            return converted;
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e1) {
            throw new ConversionException(e1);
        }
    }

    @Override
    public Object convert(InputStream source, String targetFormat) throws ConversionException, IllegalArgumentException {
        try {
            if (source == null) {
                throw new NullPointerException("InputStream source was null");
            }
            Transformer xform = this.getTransformer();
            StreamSource src = new StreamSource(source);
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            xform.transform(src, result);
            Object converted = this.buildResult(sw.toString(), targetFormat);
            return converted;
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e1) {
            throw new ConversionException(e1);
        }
    }

    private Object buildResult(String result, String targetFormat) throws Exception {
        Object built = null;
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        StringReader sr = new StringReader(result);
        Document documentBuilt = db.parse(new InputSource(sr));
        if (targetFormat.equalsIgnoreCase("dom") || targetFormat.equalsIgnoreCase("Document") || targetFormat.equalsIgnoreCase("org.w3c.dom.Document")) {
            built = documentBuilt;
        } else if (targetFormat.equalsIgnoreCase("String") || targetFormat.equalsIgnoreCase("java.lang.String") || targetFormat.equalsIgnoreCase("xml")) {
            built = FormatConverter.toXML(documentBuilt);
        } else {
            throw new IllegalArgumentException("Target Format " + targetFormat + " not supported by XSLTConversion");
        }
        return built;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transformer getTransformer() throws Exception {
        Templates templates = null;
        Transformer xform = null;
        TransformRecord tr = null;
        if (previousConversions.containsKey(this.transformSheetLocation)) {
            HashMap hashMap = previousConversions;
            synchronized (hashMap) {
                tr = (TransformRecord)previousConversions.get(this.transformSheetLocation);
            }
            tr.incUsed();
            xform = tr.getTransform();
        } else {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            InputStream is = ResourceLoader.getResourceAsStream(this.transformSheetLocation);
            if (is == null) {
                throw new FileNotFoundException("Missing Resource: " + this.transformSheetLocation);
            }
            StreamSource sheets = new StreamSource(is);
            templates = transFactory.newTemplates(sheets);
            tr = new TransformRecord(templates);
            xform = templates.newTransformer();
            HashMap hashMap = previousConversions;
            synchronized (hashMap) {
                previousConversions.put(this.transformSheetLocation, tr);
                if (previousConversions.size() > 10) {
                    this.cullStoredConversions();
                }
            }
        }
        return xform;
    }

    private void cullStoredConversions() {
        int trUsed = 0;
        int maxUsed = 0;
        HashSet<String> remove = new HashSet<String>();
        Iterator<Object> convertIt = previousConversions.keySet().iterator();
        while (convertIt.hasNext()) {
            TransformRecord tr = (TransformRecord)previousConversions.get(convertIt.next());
            trUsed = tr.getUsed();
            int n = maxUsed = trUsed > maxUsed ? trUsed : maxUsed;
        }
        int cutoff = maxUsed / 2 + 1;
        for (String name : previousConversions.keySet()) {
            TransformRecord tr = (TransformRecord)previousConversions.get(name);
            trUsed = tr.getUsed();
            if (trUsed >= cutoff) continue;
            remove.add(name);
        }
        convertIt = remove.iterator();
        while (convertIt.hasNext()) {
            previousConversions.remove(convertIt.next());
        }
    }

    class TransformRecord {
        protected Templates transformSource;
        protected int used;

        TransformRecord(Templates transform) {
            this.transformSource = transform;
            this.used = 1;
        }

        public int getUsed() {
            return this.used;
        }

        public void incUsed() {
            ++this.used;
        }

        public Transformer getTransform() {
            try {
                return this.transformSource.newTransformer();
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

