/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util.commandlineoptions;

import com.maplesoft.util.commandlineoptions.CommandOptionException;
import com.maplesoft.util.commandlineoptions.CommandOptionSetupException;
import com.maplesoft.util.commandlineoptions.FileRecognizer;
import com.maplesoft.util.commandlineoptions.OptionHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class CommandOptionParser {
    private HashMap optionIDToHandler = new HashMap();
    private List handlers = new ArrayList();
    private char[] optionIdCharacters = new char[]{'-'};
    private boolean strict = false;
    private List filesFound = new ArrayList();
    private FileRecognizer fileFinder;
    private HashSet concatenators = new HashSet();
    private static final String OPTION_PARSE_ERROR_START = "The option '";
    private static final String OPTION_PARSE_ERROR_NOT_SUPPORTED = "' is not supported.";
    private static final String OPTION_PARSE_ERROR_ONEARG = " argument.";
    private static final String OPTION_PARSE_ERROR_MULTIARG = " arguments.";
    private static final String OPTION_PARSE_ERROR_EXPECT = "' expects ";

    public void addHandler(OptionHandler handler) throws CommandOptionSetupException {
        if (handler == null) {
            throw new CommandOptionSetupException("Handler may not be null");
        }
        if (this.handlers.indexOf(handler) > -1) {
            throw new CommandOptionSetupException("Duplicate Handlers not allowed");
        }
        String[] names = handler.getOptionNames();
        if (names == null || names != null && names.length == 0) {
            throw new CommandOptionSetupException("OptionHandler " + handler + " does not return a valid list of option names");
        }
        int i = 0;
        while (i < names.length) {
            int j = 0;
            while (j < this.handlers.size()) {
                String[] options = ((OptionHandler)this.handlers.get(j)).getOptionNames();
                int k = 0;
                while (k < options.length) {
                    if (options[k].equals(names[i])) {
                        throw new CommandOptionSetupException("Duplicate option names are not allowed.");
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.handlers.add(handler);
        if (handler.isConcatenationAllowed()) {
            this.concatenators.add(handler);
        }
        i = 0;
        while (i < names.length) {
            this.optionIDToHandler.put(names[i], handler);
            ++i;
        }
    }

    public void process(String[] args) throws CommandOptionException {
        int i = 0;
        while (i < args.length) {
            if (this.isOption(args[i])) {
                String option = this.stripLeadCharacters(args[i]);
                boolean concatenationRequired = false;
                String optionName = null;
                OptionHandler handler = (OptionHandler)this.optionIDToHandler.get(option);
                if (handler == null && this.isConcatenationPossible() && option.length() > 1) {
                    Iterator conCatIt = this.concatenators.iterator();
                    int largestMatchSize = 0;
                    OptionHandler largestMatchingHandler = null;
                    while (conCatIt.hasNext()) {
                        OptionHandler thand = (OptionHandler)conCatIt.next();
                        String[] names = thand.getOptionNames();
                        int k = 0;
                        while (k < names.length) {
                            String toption;
                            if (option.length() > names[k].length() && (toption = option.substring(0, names[k].length())).equals(names[k]) && toption.length() > largestMatchSize) {
                                largestMatchingHandler = thand;
                                largestMatchSize = toption.length();
                                optionName = toption;
                            }
                            ++k;
                        }
                    }
                    handler = largestMatchingHandler;
                    boolean bl = concatenationRequired = handler != null;
                    if (handler == null) {
                        optionName = null;
                    }
                }
                if (this.strict && handler == null) {
                    throw new CommandOptionException(OPTION_PARSE_ERROR_START + args[i] + OPTION_PARSE_ERROR_NOT_SUPPORTED);
                }
                if (handler != null) {
                    int optionArgs = handler.numArgs();
                    String[] handlerArgs = new String[1 + optionArgs];
                    if (concatenationRequired) {
                        String optionArgument;
                        handlerArgs[1] = optionArgument = option.substring(1);
                    } else {
                        optionName = option;
                        if (optionArgs >= args.length - i) {
                            throw new CommandOptionException(OPTION_PARSE_ERROR_START + option + OPTION_PARSE_ERROR_EXPECT + optionArgs + (optionArgs != 1 ? OPTION_PARSE_ERROR_MULTIARG : OPTION_PARSE_ERROR_ONEARG));
                        }
                        int j = 1;
                        while (j <= optionArgs) {
                            handlerArgs[j] = args[i + j];
                            ++j;
                        }
                        i += optionArgs;
                    }
                    handlerArgs[0] = optionName;
                    handler.handle(this, handlerArgs);
                }
            } else if (this.fileFinder != null) {
                String fileName = args[i];
                if (fileName.startsWith("\"")) {
                    fileName = fileName.substring(1, fileName.length() - 1);
                }
                if (this.fileFinder.isValidFile(fileName)) {
                    this.filesFound.add(fileName);
                }
            }
            ++i;
        }
    }

    public boolean isConcatenationPossible() {
        return this.concatenators.size() > 0;
    }

    public void setFileFinder(FileRecognizer fileRecognizer) {
        this.fileFinder = fileRecognizer;
    }

    public List getFilesFound() {
        return this.filesFound;
    }

    public boolean isOption(String argument) {
        boolean option = false;
        if (argument.length() > 0) {
            char firstChar = argument.charAt(0);
            int i = 0;
            while (i < this.optionIdCharacters.length) {
                if (firstChar == this.optionIdCharacters[i]) {
                    option = true;
                    break;
                }
                ++i;
            }
        }
        return option;
    }

    public String getOptionHelp() {
        StringBuffer helpResult = new StringBuffer();
        for (OptionHandler handler : this.handlers) {
            String[] optionIds = handler.getOptionNames();
            int i = 0;
            while (i < optionIds.length) {
                helpResult.append(this.optionIdCharacters[0]);
                helpResult.append(optionIds[i]);
                if (i < optionIds.length - 1) {
                    helpResult.append(", ");
                }
                ++i;
            }
            helpResult.append("   -   ");
            helpResult.append(handler.getHelpText());
            helpResult.append("\n");
        }
        return helpResult.toString();
    }

    public void setOptionLeadCharacters(char[] chars) {
        this.optionIdCharacters = chars;
    }

    public char[] getOptionLeadCharacters() {
        return this.optionIdCharacters;
    }

    public void setStrict(boolean isStrict) {
        this.strict = isStrict;
    }

    public boolean isStrict() {
        return this.strict;
    }

    /*
     * Unable to fully structure code
     */
    private String stripLeadCharacters(String arg) {
        i = 0;
        ** GOTO lbl7
        {
            arg = arg.substring(1);
            do {
                if (arg.length() > 0 && arg.charAt(0) == this.optionIdCharacters[i]) continue block0;
                ++i;
lbl7:
                // 2 sources

            } while (i < this.optionIdCharacters.length);
        }
        return arg;
    }
}

