/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util.encoder;

import com.maplesoft.util.encoder.AbstractStringEncoder;
import java.util.Arrays;

public abstract class DoubleByteEncoder
extends AbstractStringEncoder {
    protected DoubleByteEncoder(String name) {
        super(name);
    }

    @Override
    public String toUnicode(String source) {
        int[] encodedValues = new int[source.length()];
        int idx = 0;
        int i = 0;
        while (i < source.length()) {
            int ch = source.charAt(i);
            if (Arrays.binarySearch(this.getPageRefs(), Integer.toHexString(ch).toUpperCase()) >= 0 && i + 1 < source.length()) {
                ch = (ch << 8) + source.charAt(++i);
            }
            encodedValues[idx++] = ch;
            ++i;
        }
        int[] trimmed = new int[idx];
        int i2 = 0;
        while (i2 < idx) {
            trimmed[i2] = encodedValues[i2];
            ++i2;
        }
        int[] unicodeValues = this.toUnicode(trimmed);
        StringBuffer unicodeString = new StringBuffer(unicodeValues.length);
        int i3 = 0;
        while (i3 < unicodeValues.length) {
            unicodeString.append((char)unicodeValues[i3]);
            ++i3;
        }
        return unicodeString.toString();
    }

    @Override
    public String fromUnicode(String source) {
        int[] unicodeValues = new int[source.length()];
        int i = 0;
        while (i < unicodeValues.length) {
            unicodeValues[i] = source.charAt(i);
            ++i;
        }
        int[] encodedValues = this.fromUnicode(unicodeValues);
        StringBuffer encodedString = new StringBuffer(encodedValues.length);
        int i2 = 0;
        while (i2 < encodedValues.length) {
            int ch = encodedValues[i2];
            if (ch > 255) {
                encodedString.append((char)(ch >> 8));
                ch &= 0xFF;
            }
            encodedString.append((char)ch);
            ++i2;
        }
        return encodedString.toString();
    }

    @Override
    public int getType() {
        return 1;
    }
}

