/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util.encoder;

import com.maplesoft.util.encoder.AbstractStringEncoder;

public class UnicodeEscapeEncoder
extends AbstractStringEncoder {
    private static final String ESCAPE_SEQUENCE_START = "&#";
    private static final String ESCAPE_SEQUENCE_END = ";";
    private static final int ESCAPE_SEQUENCE_MAXLEN = 10;

    public UnicodeEscapeEncoder() {
        super(null);
    }

    public static String convertEscapeSequenceToUnicode(String encodedString) {
        return UnicodeEscapeEncoder.convertEscapeSequenceToUnicode(encodedString, true);
    }

    public static String convertEscapeSequenceToUnicode(String encodedString, boolean stripBackquotes) {
        if (encodedString != null && encodedString.length() > 0) {
            StringBuffer buffy = new StringBuffer();
            int start = 0;
            boolean foundUnicodeChar = false;
            int current = encodedString.indexOf(ESCAPE_SEQUENCE_START);
            int escapeEnd = encodedString.indexOf(ESCAPE_SEQUENCE_END, current);
            while (current >= 0 && escapeEnd >= 0) {
                if (escapeEnd - current < 10) {
                    String number = encodedString.substring(current + ESCAPE_SEQUENCE_START.length(), escapeEnd);
                    try {
                        int c = Integer.parseInt(number);
                        buffy.append(encodedString.substring(start, current));
                        buffy.append((char)c);
                        foundUnicodeChar = true;
                    }
                    catch (NumberFormatException e) {
                        buffy.append(encodedString.substring(start, escapeEnd + 1));
                    }
                } else {
                    buffy.append(encodedString.substring(start, escapeEnd + 1));
                }
                start = escapeEnd + 1;
                current = encodedString.indexOf(ESCAPE_SEQUENCE_START, escapeEnd);
                escapeEnd = encodedString.indexOf(ESCAPE_SEQUENCE_END, current);
            }
            buffy.append(encodedString.substring(start));
            encodedString = buffy.toString();
            if (foundUnicodeChar && stripBackquotes) {
                encodedString = encodedString.replaceAll("`", "");
            }
        }
        return encodedString;
    }

    public static String convertUnicodeToEscapeSequence(String unicodeString) {
        return UnicodeEscapeEncoder.convertUnicodeToEscapeSequence(unicodeString, true);
    }

    public static String convertUnicodeToEscapeSequence(String unicodeString, boolean addBackquotes) {
        StringBuffer outerValue = new StringBuffer();
        if (unicodeString != null && unicodeString.length() > 0) {
            boolean inIdentifier = UnicodeEscapeEncoder.isPartOfIdentifier(unicodeString.charAt(0));
            boolean inString = false;
            boolean escaped = false;
            int i = 0;
            while (i < unicodeString.length()) {
                StringBuffer buffy = new StringBuffer();
                boolean needEscape = false;
                while (i < unicodeString.length()) {
                    char c = unicodeString.charAt(i);
                    if (inIdentifier != UnicodeEscapeEncoder.isPartOfIdentifier(c)) {
                        inIdentifier = !inIdentifier;
                        break;
                    }
                    if (escaped) {
                        escaped = false;
                    } else if (c == '\\') {
                        escaped = true;
                    } else if (c == '\"') {
                        boolean bl = inString = !inString;
                    }
                    if (c <= '\u007f') {
                        buffy.append(c);
                    } else {
                        buffy.append(ESCAPE_SEQUENCE_START);
                        buffy.append((int)c);
                        buffy.append(ESCAPE_SEQUENCE_END);
                        needEscape = !inString;
                    }
                    ++i;
                }
                if (addBackquotes && needEscape && (outerValue.length() < 1 || outerValue.charAt(outerValue.length() - 1) != '`')) {
                    outerValue.append('`');
                }
                outerValue.append(buffy);
                if (!addBackquotes || !needEscape || i < unicodeString.length() && unicodeString.charAt(i) == '`') continue;
                outerValue.append('`');
            }
        }
        return outerValue.toString();
    }

    private static boolean isPartOfIdentifier(char c) {
        boolean isId = true;
        if (c < '\u007f') {
            isId = Character.isLetterOrDigit(c) || c == '_';
        }
        return isId;
    }

    @Override
    public String toUnicode(String encodedString) {
        if (encodedString.indexOf(ESCAPE_SEQUENCE_START) > 0 && encodedString.indexOf(ESCAPE_SEQUENCE_END) > 0) {
            encodedString = encodedString.replaceAll("`", "");
        }
        return encodedString;
    }

    @Override
    public String fromUnicode(String unicodeString) {
        return UnicodeEscapeEncoder.convertUnicodeToEscapeSequence(unicodeString);
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    protected String[] getPageRefs() {
        return null;
    }
}

