/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.applets;

import com.maplesoft.applets.MyGlassPane;
import com.maplesoft.mathdoc.components.WmiMathMLEditorButtonMenu;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class GlassPaneListener
extends MouseInputAdapter {
    WmiMathMLEditorButtonMenu owner;
    Toolkit toolkit;
    JPanel glassPane;
    Container contentPane;
    String prefix;

    public GlassPaneListener(WmiMathMLEditorButtonMenu owner, JPanel glassPane, Container contentPane, String p) {
        this.owner = owner;
        this.toolkit = Toolkit.getDefaultToolkit();
        this.glassPane = glassPane;
        this.contentPane = contentPane;
        this.prefix = p;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point screenLocation = e.getPoint();
        SwingUtilities.convertPointToScreen(screenLocation, this.glassPane);
        if (!(this.owner.isActivePaletteWindowJustShown() || this.owner.getActiveMenuItem() == null && this.owner.getActiveButton() == null || this.hideOnExit(e))) {
            boolean pointInSubmenu = this.isPointInSubmenu(e);
            boolean pointInPalette = this.isPointInPalette(e);
            if (!(pointInPalette || pointInSubmenu || this.owner.getActiveMenuItem() == null && this.owner.getActiveButton() == null || this.owner.getActiveButton() == null)) {
                SwingUtilities.convertPointFromScreen(screenLocation, this.owner.getActiveButton());
                if (!this.owner.getActiveButton().contains(screenLocation)) {
                    this.owner.hideSubmenu();
                }
            }
        }
        this.owner.setActivePaletteWindowJustShown(false);
        this.redispatchMouseEvent(e, false);
    }

    private boolean isPointInParentWindow(WmiMathMLEditorButtonMenu parent, MouseEvent e) {
        if (parent != null && parent.buttonSubmenuWindow != null) {
            Point pp = e.getLocationOnScreen();
            SwingUtilities.convertPointFromScreen(pp, parent.buttonSubmenuWindow);
            return parent.buttonSubmenuWindow.contains(pp);
        }
        return false;
    }

    private boolean isPointInSubmenu(MouseEvent e) {
        if (this.owner.getActiveMenu() != null && this.owner.getActiveMenu().buttonSubmenuWindow != null) {
            Point pp = e.getLocationOnScreen();
            SwingUtilities.convertPointFromScreen(pp, this.owner.getActiveMenu().buttonSubmenuWindow);
            return this.owner.getActiveMenu().buttonSubmenuWindow.contains(pp);
        }
        return false;
    }

    private boolean isPointInPalette(MouseEvent e) {
        if (this.owner.getActivePaletteWindow() != null) {
            Point pp = e.getLocationOnScreen();
            SwingUtilities.convertPointFromScreen(pp, this.owner.getActivePaletteWindow());
            return this.owner.getActivePaletteWindow().contains(pp);
        }
        return false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.redispatchMouseEvent(e, false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.redispatchMouseEvent(e, false);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.redispatchMouseEvent(e, false);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (RuntimePlatform.isOracleJava()) {
            this.hideOnExit(e);
        }
        this.redispatchMouseEvent(e, false);
    }

    private boolean hideOnExit(MouseEvent e) {
        if (this.owner.isActivePaletteWindowJustShown()) {
            return false;
        }
        boolean pointInSubmenu = this.isPointInSubmenu(e);
        boolean pointInPalette = this.isPointInPalette(e);
        if (pointInPalette || pointInSubmenu) {
            return false;
        }
        Point p = e.getPoint();
        int gpw = this.glassPane.getWidth();
        int gph = this.glassPane.getHeight();
        if (p.x < 3 || p.y < 3 || p.x > gpw - 3 || p.y > gph - 3) {
            WmiMathMLEditorButtonMenu parent = this.owner;
            while (parent != null) {
                if (this.isPointInParentWindow(parent, e)) break;
                parent.hidePaletteWindow();
                parent.hide();
                parent = parent.getParentMenu();
            }
            return true;
        }
        return false;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.redispatchMouseEvent(e, false);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.redispatchMouseEvent(e, true);
    }

    private void redispatchMouseEvent(MouseEvent e, boolean repaint) {
        if (this.glassPane instanceof MyGlassPane && ((MyGlassPane)this.glassPane).getWarningPanel().isVisible()) {
            return;
        }
        Point glassPanePoint = e.getPoint();
        Container container = this.contentPane;
        Point containerPoint = SwingUtilities.convertPoint(this.glassPane, glassPanePoint, this.contentPane);
        Component component = SwingUtilities.getDeepestComponentAt(container, containerPoint.x, containerPoint.y);
        if (component != null) {
            Point componentPoint = SwingUtilities.convertPoint(this.glassPane, glassPanePoint, component);
            component.dispatchEvent(new MouseEvent(component, e.getID(), e.getWhen(), e.getModifiers(), componentPoint.x, componentPoint.y, e.getClickCount(), e.isPopupTrigger()));
        }
        if (repaint) {
            this.glassPane.repaint();
        }
    }
}

