/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.applets;

import com.maplesoft.applets.GlassPaneListener;
import com.maplesoft.applets.MyGlassPane;
import com.maplesoft.mathdoc.components.WmiMathMLContextMenuManager;
import com.maplesoft.mathdoc.components.WmiMathMLEditorButtonMenu;
import com.maplesoft.mathdoc.controller.edit.WmiMathMLTransfer;
import com.maplesoft.mathdoc.controller.edit.WmiTransfer;
import com.maplesoft.mathdoc.controller.insert.WmiEntityListCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiFormatException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.exception.WmiParseException;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLPresentationFormatter;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiParagraphModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiMathMLEditorDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiSelection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class MathMLEditor
extends JApplet {
    private static final char DOLLAR_SIGN_CHAR = '$';
    private static final String DEFAULT_APPLICATION = "default";
    private static final String MAPLE_TA_APPLICATION = "mapleta";
    private static final String MAPLE_TA_APPLICATION_NO_ITALICS = "mapleta-noitalics";
    private static final String WIDTH_PARAMETER = "mathmlWidth";
    private static final String HEIGHT_PARAMETER = "mathmlHeight";
    private static final String MATHML_PARAMETER = "mathml";
    private static final String BREAK_WIDTH_PARAMETER = "breakWidth";
    private static final String EDITABLE_PARAMETER = "editable";
    private static final String PALETTE_PARAMETER = "palette";
    private static final String PALETTE_CONTENT_PARAMETER = "paletteContent";
    private static final String TOOLBAR_PARAMETER = "toolbar";
    private static final String TOOLTIP_PARAMETER = "tooltip";
    private static final String APPLICATION_PARAMETER = "application";
    private static final String DISABLE_STRETCHY_OPS_PARAMETER = "disableStretchyOperators";
    private static final String EXTENDED_PALETTE = "extended";
    private static final int DEFAULT_WIDTH = 300;
    private static final int DEFAULT_HEIGHT = 400;
    private static final boolean DEFAULT_EXTENDED_PALETTE = false;
    private static final String EMPTY_MATHML = "<math><mrow><mi></mi></mrow></math>";
    private static final String DEFAULT_TOOLTIP = "";
    private static final int WIDTH_ALLOWANCE = 5;
    private static final int HEIGHT_ALLOWANCE = 5;
    private static final int SCROLLBAR_ALLOWANCE = 35;
    private static final int TOOLBAR_BUTTON_WIDTH = 40;
    private static final String RESOURCES = "com.maplesoft.applets.resources.MathMLEditor";
    private WmiResourcePackage resources;
    private int mathmlWidth;
    private int mathmlHeight;
    private int breakWidth;
    private boolean editable;
    private boolean extendedPalette;
    private String mathml;
    private String paletteContent;
    private boolean useToolbar;
    private String tooltip;
    private String application;
    private boolean disableStretchyOperators;
    private WmiMathDocumentModel doc;
    private WmiMathMLEditorDocumentView view;
    private JPanel editor;
    JViewport viewport;

    @Override
    public void init() {
        WmiCaret.resetTimer();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MathMLEditor.this.resources = WmiResourcePackage.getResourcePackage(MathMLEditor.RESOURCES);
                    MathMLEditor.this.createGUI();
                }
            });
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
    }

    @Override
    public void start() {
        WmiCaret.resetTimer();
        MathMLEditor.disableFocusTraversal(this);
    }

    public static void disableFocusTraversal(Container con) {
        con.setFocusTraversalKeysEnabled(false);
        con.setFocusCycleRoot(true);
    }

    private void createGUI() {
        this.parseParameters();
        this.setGlassPane(new MyGlassPane(this));
        this.addWaterMarkLabel();
        this.addWarningPanel();
        this.getGlassPane().setVisible(true);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent arg0) {
            }

            @Override
            public void componentResized(ComponentEvent arg0) {
                MathMLEditor.this.view.layoutView();
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
            }

            @Override
            public void componentHidden(ComponentEvent arg0) {
            }
        });
        this.view = new WmiMathMLEditorDocumentView();
        WmiMathMLEditorDocumentView.setActiveDocumentView(this.view);
        this.view.setBreakWidth(this.breakWidth - 35);
        this.view.setToolTipText(this.tooltip);
        this.doc = (WmiMathDocumentModel)this.view.getModel();
        this.doc.setReadOnly(!this.editable);
        this.setEditAndDisplayOptions(this.application);
        WmiMathMLContextMenuManager contextMgr = null;
        if (this.editable) {
            contextMgr = this.paletteContent == null ? new WmiMathMLContextMenuManager(2, this.view, this.extendedPalette) : new WmiMathMLContextMenuManager(2, this.view, this.paletteContent);
            this.view.setContextManager(contextMgr);
            this.view.addMouseListener(new EditorMouseListener());
        }
        Dimension d = new Dimension(this.mathmlWidth, this.mathmlHeight);
        this.view.setSize(d);
        this.view.setPreferredSize(d);
        this.view.setMinimumSize(d);
        this.view.setMaximumSize(d);
        this.view.setBackground(Color.white);
        this.editor = new JPanel();
        this.editor.setLayout(new BorderLayout());
        JScrollPane aScrollPane = new JScrollPane(this.view, 20, 30);
        if (!this.editable) {
            aScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
        this.viewport = aScrollPane.getViewport();
        this.editor.add((Component)aScrollPane, "Center");
        this.setViewportSize();
        this.getContentPane().add(this.editor);
        this.parseMathML(this.mathml);
        if (this.useToolbar && this.editable) {
            WmiParagraphModel paragraph = new WmiParagraphModel(this.doc);
            WmiMathMLEditorButtonMenu toolbar = (WmiMathMLEditorButtonMenu)contextMgr.getMenuForModel(paragraph);
            toolbar.buildForToolbar = true;
            toolbar.setButtonWidth(40);
            contextMgr.setContextForDocument(new WmiParagraphView(paragraph, this.view));
            contextMgr.buildMenu();
            contextMgr.setPopupEnabled(false);
            GlassPaneListener l = new GlassPaneListener((WmiMathMLEditorButtonMenu)contextMgr.getActiveContextualMenu(), this.getAppletGlassPane(), this.getAppletContentPane(), "MAIN");
            this.getGlassPane().addMouseListener(l);
            this.getGlassPane().addMouseMotionListener(l);
            JPanel toolbarPanel = new JPanel();
            toolbarPanel.setBackground(Color.white);
            toolbarPanel.setLayout(new BorderLayout());
            toolbarPanel.add((Component)((WmiMathMLEditorButtonMenu)contextMgr.getActiveContextualMenu()).buttonPanel, "Before");
            ImageIcon icon = this.createImageIcon("/com/maplesoft/applets/trash.png", DEFAULT_TOOLTIP);
            JButton button = new JButton(icon);
            button.setPreferredSize(new Dimension(40, 40));
            button.setMinimumSize(new Dimension(40, 40));
            button.setMaximumSize(new Dimension(40, 40));
            button.setToolTipText("Reset the equation space");
            ToolTipManager.sharedInstance().setInitialDelay(2000);
            ToolTipManager.sharedInstance().setDismissDelay(1500);
            ToolTipManager.sharedInstance().setReshowDelay(1000);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ((MyGlassPane)MathMLEditor.this.getGlassPane()).showWarning();
                    }
                    catch (Exception ex) {
                        WmiErrorLog.log(ex);
                    }
                }
            });
            JPanel buttonPane = new JPanel();
            buttonPane.setLayout(new BoxLayout(buttonPane, 0));
            buttonPane.setOpaque(false);
            buttonPane.add(Box.createRigidArea(new Dimension(5, 0)));
            buttonPane.add(button);
            toolbarPanel.add((Component)buttonPane, "After");
            this.editor.add((Component)toolbarPanel, "First");
        }
        this.view.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MathMLEditor.this.getAppletGlassPane().hideWaterMark();
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.view.layoutView();
    }

    private void setViewportSize() {
        int w = this.getWidth() > 0 ? Math.min(this.mathmlWidth, this.getWidth()) : this.mathmlWidth;
        int h = this.getHeight() > 0 ? Math.min(this.mathmlHeight, this.getHeight()) : this.mathmlHeight;
        Dimension d = new Dimension(w - 5, h - 5);
        this.viewport.setSize(d);
        this.viewport.setPreferredSize(d);
        this.viewport.setMinimumSize(d);
        this.viewport.setMaximumSize(d);
    }

    private void addWaterMarkLabel() {
        JLabel waterMarkLabel = new JLabel("<html><center>Click here to enter your answer by keyboard<BR>and/or use of the function buttons above.</center></html>", 0);
        waterMarkLabel.setForeground(new Color(0.5f, 0.5f, 0.5f, 0.5f));
        waterMarkLabel.setFont(new Font("SansSerif", 2, 12));
        waterMarkLabel.setOpaque(false);
        this.getAppletGlassPane().add(Box.createRigidArea(new Dimension(0, this.getHeight() / 3)));
        this.getAppletGlassPane().add(waterMarkLabel);
        this.getAppletGlassPane().setWaterMarkLabel(waterMarkLabel);
        if (!this.mathml.equals(EMPTY_MATHML)) {
            this.getAppletGlassPane().hideWaterMark();
        }
    }

    private void addWarningPanel() {
        JPanel holderPanel = new JPanel();
        JPanel warningPanel = new JPanel();
        holderPanel.setLayout(new BoxLayout(holderPanel, 0));
        holderPanel.setOpaque(false);
        warningPanel.setLayout(new BoxLayout(warningPanel, 1));
        warningPanel.setBackground(new Color(0.9f, 0.9f, 0.9f, 1.0f));
        warningPanel.setBorder(new LineBorder(Color.black, 1, true));
        Dimension d = warningPanel.getSize();
        warningPanel.setOpaque(true);
        JLabel buttonLabel = new JLabel("<html><center>Are you sure you want to reset the equation space?</center></html>", 0);
        buttonLabel.setAlignmentX(0.5f);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.setOpaque(false);
        JButton okButton = new JButton("OK");
        okButton.setPreferredSize(new Dimension(80, 25));
        okButton.setMinimumSize(new Dimension(80, 25));
        okButton.setMaximumSize(new Dimension(80, 25));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MathMLEditor.this.setMathML(MathMLEditor.EMPTY_MATHML);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                MathMLEditor.this.getAppletGlassPane().showWaterMark();
                MathMLEditor.this.view.repaint();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setPreferredSize(new Dimension(80, 25));
        cancelButton.setMinimumSize(new Dimension(80, 25));
        cancelButton.setMaximumSize(new Dimension(80, 25));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MathMLEditor.this.getAppletGlassPane().hideWarning();
                MathMLEditor.this.view.repaint();
            }
        });
        buttonPanel.add(okButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPanel.add(cancelButton);
        warningPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        warningPanel.add(buttonLabel);
        warningPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        warningPanel.add(buttonPanel);
        warningPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        holderPanel.setVisible(false);
        holderPanel.add(Box.createRigidArea(new Dimension(50, 0)));
        holderPanel.add(warningPanel);
        holderPanel.add(Box.createRigidArea(new Dimension(50, 0)));
        this.getAppletGlassPane().add(holderPanel);
        this.getAppletGlassPane().setWarningPanel(holderPanel);
    }

    protected ImageIcon createImageIcon(String path, String description) {
        URL imgURL = this.getClass().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    private void setEditAndDisplayOptions(String application) {
        if (application.startsWith(MAPLE_TA_APPLICATION)) {
            this.view.registerIdentifierCharacter('$');
        }
        if (application.equals(MAPLE_TA_APPLICATION_NO_ITALICS)) {
            this.view.initializeItalicsMode(false);
        }
        if (this.disableStretchyOperators) {
            WmiMathOperatorModel.disableStretchyOps = true;
        }
    }

    private void parseParameters() {
        String toolbarString;
        String editableString;
        String breakWidthString;
        String heightString;
        String widthString = this.getParameter(WIDTH_PARAMETER);
        if (widthString != null) {
            try {
                this.mathmlWidth = Integer.parseInt(widthString);
            }
            catch (NumberFormatException nfe) {
                this.mathmlWidth = 300;
            }
        } else {
            this.mathmlWidth = 300;
        }
        if ((heightString = this.getParameter(HEIGHT_PARAMETER)) != null) {
            try {
                this.mathmlHeight = Integer.parseInt(heightString);
            }
            catch (NumberFormatException nfe) {
                this.mathmlHeight = 400;
            }
        } else {
            this.mathmlHeight = 400;
        }
        if ((breakWidthString = this.getParameter(BREAK_WIDTH_PARAMETER)) != null) {
            try {
                this.breakWidth = Integer.parseInt(breakWidthString);
            }
            catch (NumberFormatException nfe) {
                this.breakWidth = this.mathmlWidth;
            }
        } else {
            this.breakWidth = this.mathmlWidth;
        }
        if (this.breakWidth > this.mathmlWidth) {
            this.breakWidth = this.mathmlWidth;
        }
        this.editable = (editableString = this.getParameter(EDITABLE_PARAMETER)) == null || !editableString.toLowerCase().equals("false");
        String paletteString = this.getParameter(PALETTE_PARAMETER);
        this.extendedPalette = paletteString != null && paletteString.toLowerCase().equals(EXTENDED_PALETTE);
        this.paletteContent = this.getParameter(PALETTE_CONTENT_PARAMETER);
        if (this.paletteContent != null && !this.paletteContent.startsWith("<tb>")) {
            this.paletteContent = this.readPaletteFile(this.paletteContent);
        }
        this.useToolbar = (toolbarString = this.getParameter(TOOLBAR_PARAMETER)) != null && toolbarString.toLowerCase().equals("true");
        String applicationString = this.getParameter(APPLICATION_PARAMETER);
        this.application = applicationString != null ? applicationString.trim().toLowerCase() : DEFAULT_APPLICATION;
        String tooltipString = this.getParameter(TOOLTIP_PARAMETER);
        this.tooltip = tooltipString != null ? tooltipString.trim() : null;
        this.mathml = this.getParameter(MATHML_PARAMETER);
        if (this.mathml == null || this.mathml.trim().equals(DEFAULT_TOOLTIP)) {
            this.mathml = EMPTY_MATHML;
        } else if (this.mathml.startsWith("%")) {
            this.mathml = this.decodeMathML(this.mathml);
        }
        String disableStretchyOpsString = this.getParameter(DISABLE_STRETCHY_OPS_PARAMETER);
        this.disableStretchyOperators = disableStretchyOpsString != null && disableStretchyOpsString.toLowerCase().trim().equals("true");
    }

    private String readPaletteFile(String fileName) {
        StringBuffer palette = new StringBuffer();
        try {
            File f = new File(fileName);
            FileReader r = new FileReader(f);
            BufferedReader reader = new BufferedReader(r);
            String line = reader.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    palette.append(line);
                }
                line = reader.readLine();
            }
        }
        catch (FileNotFoundException e) {
            WmiErrorLog.log(e);
        }
        catch (IOException e) {
            WmiErrorLog.log(e);
        }
        return palette.toString();
    }

    /*
     * Exception decompiling
     */
    private void parseMathML(String inputMathML) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String decodeMathML(String mathml) {
        StringBuffer out = new StringBuffer(mathml.length());
        StringBuffer hexCode = new StringBuffer("XX");
        int i = 0;
        while (i < mathml.length()) {
            char c = mathml.charAt(i);
            switch (c) {
                case '+': {
                    out.append(' ');
                    break;
                }
                case '%': {
                    try {
                        hexCode.setCharAt(0, mathml.charAt(++i));
                        hexCode.setCharAt(1, mathml.charAt(++i));
                        out.append((char)Integer.valueOf(hexCode.toString(), 16).intValue());
                        break;
                    }
                    catch (Exception e) {
                        return DEFAULT_TOOLTIP;
                    }
                }
                default: {
                    out.append(c);
                }
            }
            ++i;
        }
        return out.toString();
    }

    public void setMathML(String mathml) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiParseException, WmiModelIndexOutOfBoundsException {
        if (mathml == null || mathml.trim().equals(DEFAULT_TOOLTIP)) {
            mathml = EMPTY_MATHML;
        } else if (mathml.startsWith("%")) {
            mathml = this.decodeMathML(mathml);
        }
        if (!mathml.equals(EMPTY_MATHML)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MathMLEditor.this.getAppletGlassPane().hideWaterMark();
                }
            });
        }
        Object resultValue = null;
        boolean hasWriteLock = false;
        boolean hasReadLock = false;
        WmiMathMLImportParser parser = new WmiMathMLImportParser();
        try {
            try {
                hasWriteLock = WmiModelLock.writeLock(this.doc, false);
                if (hasWriteLock) {
                    this.doc.removeChildren(0, this.doc.getChildCount());
                    mathml = "<?xml version=\"1.0\" standalone=\"no\" ?>" + mathml.replaceAll("\\n", DEFAULT_TOOLTIP);
                    parser.parse(new StringReader(mathml), (WmiCompositeModel)this.doc, 0);
                    this.view.setSelection(null);
                    this.view.updateView();
                }
            }
            catch (WmiParseException pe) {
                String errorMessage = "<math><mrow><merror>" + this.resources.getStringForKey("ParseErrorMessage") + "</merror></mrow></math>";
                parser.parse(new StringReader(errorMessage), (WmiCompositeModel)this.doc, 0);
                this.view.updateView();
                if (hasWriteLock) {
                    WmiModelLock.writeUnlock(this.doc);
                }
                if (hasReadLock) {
                    WmiModelLock.readUnlock(this.doc);
                }
            }
        }
        finally {
            if (hasWriteLock) {
                WmiModelLock.writeUnlock(this.doc);
            }
            if (hasReadLock) {
                WmiModelLock.readUnlock(this.doc);
            }
        }
    }

    public String getPresentationMathML() throws WmiFormatException, WmiNoReadAccessException {
        String mathml = DEFAULT_TOOLTIP;
        boolean hasWriteLock = false;
        boolean hasReadLock = false;
        try {
            hasReadLock = WmiModelLock.readLock(this.doc, true);
            if (hasReadLock) {
                WmiMathMLPresentationFormatter formatter = new WmiMathMLPresentationFormatter(this.view);
                StringWriter writer = new StringWriter();
                formatter.format(writer, this.doc);
                mathml = writer.toString();
            }
        }
        finally {
            if (hasReadLock) {
                WmiModelLock.readUnlock(this.doc);
            }
        }
        return mathml;
    }

    public String getSelectionPresentationMathML() throws WmiFormatException, WmiNoReadAccessException {
        String mathml = DEFAULT_TOOLTIP;
        boolean hasWriteLock = false;
        boolean hasReadLock = false;
        try {
            WmiSelection selection;
            WmiTransfer transfer;
            Object mathmlData;
            hasReadLock = WmiModelLock.readLock(this.doc, true);
            if (hasReadLock && (mathmlData = (transfer = WmiMathMLTransfer.createTransferable(selection = this.view.getSelection())).getTransferData(DataFlavor.stringFlavor)) != null && mathmlData instanceof String) {
                mathml = mathmlData.toString();
            }
        }
        finally {
            if (hasReadLock) {
                WmiModelLock.readUnlock(this.doc);
            }
        }
        return mathml;
    }

    public Container getAppletContentPane() {
        return this.getContentPane();
    }

    public MyGlassPane getAppletGlassPane() {
        return (MyGlassPane)this.getGlassPane();
    }

    public class EditorMouseListener
    implements MouseListener {
        @Override
        public void mouseClicked(MouseEvent arg0) {
            WmiEntityListCommand.popDownList();
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }
    }
}

