/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client;

import com.maplesoft.client.KernelAdapter;
import com.maplesoft.client.KernelEvent;
import com.maplesoft.client.KernelListener;
import com.maplesoft.client.KernelProxy;
import com.maplesoft.client.kernelresult.KernelErrorResult;

public abstract class BlockingEvaluation {
    public static final int WARNING_RESULT = -3;
    public static final int WAITING_FOR_RESULT = -2;
    public static final int NO_RESULT = -1;
    public static final int ERROR_RESULT = 0;
    public static final int TEXT_RESULT = 1;
    public static final int CHAR_RESULT = 2;
    public static final int REAL_MATH_RESULT = 3;
    public static final int SYSTEM_RESULT = 4;
    public static final int PLOT_RESULT = 5;
    public static final int PLOT3D_RESULT = 6;
    public static final int SMARTPLOT_RESULT = 7;
    protected static final long DEFAULT_WAIT_TIMEOUT = 30000L;
    private static final int PROCESS_EVALUATE = 0;
    private static final int PROCESS_URGENT_EVALUATE = 1;
    private static final int PROCESS_INTERNAL_EVALUATE = 2;
    private Object result;
    private Object pendingResult = null;
    private int kernelID;
    private KernelListener parentListener;
    private int resultType = -2;
    private int pendingResultType = -2;
    private int how = 41;
    private long timeout = 30000L;

    protected BlockingEvaluation(int kernelID, KernelListener parentListener) {
        this.kernelID = kernelID;
        this.parentListener = parentListener;
    }

    protected BlockingEvaluation(int kernelID, KernelListener parentListener, int how) {
        this.kernelID = kernelID;
        this.parentListener = parentListener;
        this.how = how;
    }

    protected boolean formatErrorResults() {
        return false;
    }

    protected void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected long getTimeout() {
        return this.timeout;
    }

    public Object getResult() {
        return this.result;
    }

    public KernelListener getParentListener() {
        return this.parentListener;
    }

    public synchronized void setResultType(int result) {
        this.resultType = result;
    }

    public int getResultType() {
        return this.resultType;
    }

    public synchronized void urgentProcess() {
        this.process(1);
    }

    public synchronized void internalProcess() {
        this.process(2);
    }

    public synchronized void process() {
        this.process(0);
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void process(int ptype) {
        block7: {
            this.result = null;
            proxy = KernelProxy.getInstance();
            if (!proxy.isKernelConnectionValid(this.kernelID)) break block7;
            switch (ptype) {
                case 0: {
                    proxy.evaluate(this.kernelID, this.getBlockingListener(), this.getCommand(), this.how);
                    ** GOTO lbl18
                }
                case 1: {
                    proxy.urgentEvaluate(this.kernelID, this.getBlockingListener(), this.getCommand(), this.how);
                    ** GOTO lbl18
                }
                case 2: {
                    proxy.internalEvaluate(this.kernelID, this.getBlockingListener(), this.getCommand(), this.how);
                    if (true) ** GOTO lbl18
                }
                default: {
                    throw new IllegalArgumentException("type of processing not recognized");
                }
            }
            {
                do {
                    this.wait(this.timeout);
lbl18:
                    // 4 sources

                } while (proxy.isKernelConnectionValid(this.kernelID) && this.resultType == -2);
                this.update();
            }
        }
    }

    protected BlockingListener getBlockingListener() {
        return new BlockingListener(this);
    }

    protected abstract String getCommand();

    protected abstract void update();

    public synchronized void setResult(Object result) {
        this.result = result;
        this.notifyAll();
    }

    public synchronized void setPendingResult(Object result, int type) {
        this.pendingResult = result;
        this.pendingResultType = type;
    }

    public synchronized Object getPendingResult() {
        return this.pendingResult;
    }

    public synchronized int getPendingType() {
        return this.pendingResultType;
    }

    public static class BlockingListener
    extends KernelAdapter {
        protected BlockingEvaluation evaluator;

        protected BlockingListener(BlockingEvaluation evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public boolean processWarning(KernelEvent event) {
            String warning = null;
            if (this.evaluator.formatErrorResults()) {
                try {
                    KernelErrorResult.FormattedErrorMessage m = KernelErrorResult.parseErrorMessage(event);
                    warning = m.getText();
                }
                catch (Exception e) {
                    warning = "Warning";
                }
            } else {
                warning = event.getText();
            }
            this.evaluator.setPendingResult(warning, -3);
            return true;
        }

        @Override
        public boolean processError(KernelEvent event) {
            this.evaluator.setResultType(0);
            String error = null;
            if (this.evaluator.formatErrorResults()) {
                try {
                    KernelErrorResult.FormattedErrorMessage m = KernelErrorResult.parseErrorMessage(event);
                    error = m.getText();
                }
                catch (Exception e) {
                    error = "Error";
                }
            } else {
                error = event.getText();
            }
            this.evaluator.setResult(error);
            return true;
        }

        @Override
        public boolean processText(KernelEvent event) {
            this.evaluator.setPendingResult(event.getClass(), 1);
            return true;
        }

        @Override
        public boolean processChar(KernelEvent event) {
            this.evaluator.setPendingResult(event.getText(), 2);
            return true;
        }

        @Override
        public boolean processRealMath(KernelEvent event) {
            this.evaluator.setPendingResult(event.getDag(), 3);
            return true;
        }

        @Override
        public boolean processSystem(KernelEvent event) {
            this.evaluator.setResultType(4);
            this.evaluator.setResult(event.getDag());
            return true;
        }

        @Override
        public boolean processPlot(KernelEvent event) {
            this.evaluator.setResultType(5);
            this.evaluator.setResult(event.getDag());
            return true;
        }

        @Override
        public boolean processPlot3D(KernelEvent event) {
            System.out.println("process Plot 3D");
            this.evaluator.setResultType(6);
            this.evaluator.setResult(event.getDag());
            return true;
        }

        @Override
        public boolean processSmartPlot(KernelEvent event) {
            this.evaluator.setResultType(7);
            this.evaluator.setResult(event.getDag());
            return true;
        }

        @Override
        public boolean processComputationStateChange(KernelEvent event) {
            if ((event.getStreamName().equals("EVALEND") || event.getStreamName().equals("KERNELFAIL")) && this.evaluator.resultType == -2) {
                if (this.evaluator.getPendingResult() != null) {
                    this.evaluator.setResultType(this.evaluator.getPendingType());
                    this.evaluator.setResult(this.evaluator.getPendingResult());
                } else {
                    this.evaluator.setResultType(-1);
                    this.evaluator.setResult(event.getDag());
                }
            }
            return true;
        }

        @Override
        public KernelListener getParentListener() {
            return this.evaluator.getParentListener();
        }
    }
}

