/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client;

import com.maplesoft.client.KernelConnection;
import com.maplesoft.client.KernelListener;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DotMParseError;

public class KernelEvent {
    private int theType;
    private KernelListener source;
    public static final String NULL_DAG_DOTM = "6\"";
    private String streamName;
    private String replyAsText;
    private String replyAsDotM;
    private Dag replyAsDAG;
    private String toKernel;
    private KernelConnection kernelConnection;

    public KernelEvent(int type, char[] reply, boolean isDotm, KernelListener listener) {
        if (isDotm) {
            this.replyAsDotM = new String(reply);
        } else {
            String temp = String.valueOf(reply);
            this.replyAsText = temp.substring(0, temp.length() - 1);
            int index = this.replyAsText.indexOf(0);
            if (index >= 0) {
                this.replyAsText = this.replyAsText.substring(0, index);
            }
        }
        this.theType = type;
        this.toKernel = null;
        this.source = listener;
        this.streamName = null;
    }

    public KernelEvent(int type, String reply, boolean isDotm, KernelListener listener) {
        this.theType = type;
        if (isDotm) {
            this.replyAsDotM = reply;
        } else {
            this.replyAsText = reply;
        }
        this.toKernel = null;
        this.source = listener;
        this.streamName = null;
    }

    public KernelListener getSource() {
        return this.source;
    }

    public void setKernelConnection(KernelConnection kernelConnection) {
        this.kernelConnection = kernelConnection;
    }

    public KernelConnection getKernelConnection() {
        return this.kernelConnection;
    }

    public int getKernelID() {
        return this.kernelConnection == null ? -1 : this.kernelConnection.getKernelID();
    }

    public int getType() {
        return this.theType;
    }

    public void setType(int theType) {
        this.theType = theType;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public boolean isStreamCall() {
        return this.streamName != null;
    }

    public String getText() {
        if (this.replyAsText == null) {
            this.buildText();
        }
        return this.replyAsText;
    }

    public String getDotm() {
        return this.replyAsDotM;
    }

    public Dag getDag() {
        if (this.replyAsDotM != null && this.replyAsDAG == null) {
            this.buildDAG();
        }
        return this.replyAsDAG;
    }

    public void buildDAG() {
        if (this.replyAsDotM != null && this.replyAsDAG == null) {
            try {
                if (this.replyAsDotM.length() > 16000000) {
                    byte[] dotMData = new byte[this.replyAsDotM.length()];
                    this.replyAsDotM.getBytes(0, this.replyAsDotM.length(), dotMData, 0);
                    this.replyAsDAG = DagBuilder.createDag(dotMData);
                } else {
                    this.replyAsDAG = DagBuilder.createDag(this.replyAsDotM.getBytes());
                }
            }
            catch (DotMParseError dpe) {
                throw dpe;
            }
            catch (Exception e1) {
                this.replyAsDAG = DagConstants.EMPTY;
            }
        }
    }

    private void buildText() {
        if (this.replyAsText == null) {
            this.buildDAG();
            if (this.replyAsDAG != null) {
                Dag normalizedDag = DagBuilder.normalize(this.replyAsDAG);
                this.replyAsText = DagBuilder.lPrint(normalizedDag);
                if (this.replyAsText != null && this.streamName != null && this.streamName.equals("CHAR") && this.replyAsText.charAt(0) == '\"' && this.replyAsText.charAt(this.replyAsText.length() - 1) == '\"') {
                    this.replyAsText = this.replyAsText.substring(1, this.replyAsText.length() - 1);
                }
            }
        }
    }

    public String getReply() {
        return this.getText();
    }

    public void setResponseForKernel(String response) {
        this.toKernel = response;
    }

    public void setResponseAsDag(Dag dag) {
        this.toKernel = DagBuilder.createDotm(dag, false);
    }

    public void setResponseAsText(String text) {
        this.toKernel = text;
    }

    public void setResponseAsDotM(String dotm) {
        this.toKernel = dotm;
    }

    public String getResponseForKernel() {
        return this.toKernel;
    }
}

