/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client;

import com.maplesoft.client.KernelCommunicationError;
import com.maplesoft.client.KernelConnection;
import com.maplesoft.client.KernelPortReady;
import com.maplesoft.util.RuntimePlatform;
import com.maplesoft.util.commandlineoptions.AbstractOptionHandler;
import com.maplesoft.util.commandlineoptions.CommandOptionException;
import com.maplesoft.util.commandlineoptions.CommandOptionParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import javax.net.ServerSocketFactory;

public class MapleServerSocket
implements Runnable {
    public static final int SOCKET_DEFAULT_CONNECTION = 0;
    public static final int SOCKET_LOCALHOST_CONNECTION = 1;
    public static final int SOCKET_IP_ADDRESS_CONNECTION = 2;
    public static final int NUM_SOCKET_CONNECTION_TYPES = 3;
    public static final String WINDOWS_STARTUP_FILE = "maple.ini";
    public static final String NON_WINDOWS_STARTUP_FILE = ".mapleinit";
    public static final String MAPLE_ROOT = "MAPLE_ROOT";
    public static final String MAPLE_LICENSE_ROOT = "MAPLE_LICENSE_ROOT";
    private static final int STARTUP_ERROR_TIMEOUT = 15000;
    private static final int BASE_PORT = 50577;
    private static final int MAX_PORT = 65535;
    private static int connectionType = 0;
    private int serverPort;
    private ServerSocket serverSocket;
    private volatile Socket clientSocket;
    private int kernelPort;
    private String kernelPortStr;
    private Process mapleServerProc;
    private BufferedReader in;
    private StringBuffer mServerstr = new StringBuffer(256);
    private String errorMsg;
    private boolean shutdown;
    private KernelPortReady kernelPortReady;
    private String language = "C";
    private static CommandOptionParser optionParser;
    private static ArrayList argsToPassToKernel;
    private static boolean libPathSet;
    private static boolean argumentsSetOnce;

    static {
        argsToPassToKernel = new ArrayList();
        libPathSet = false;
        argumentsSetOnce = false;
    }

    public MapleServerSocket(KernelPortReady portReady) {
        this.kernelPortReady = portReady;
        this.shutdown = false;
        this.serverSocket = null;
        this.clientSocket = null;
    }

    public static synchronized void setConnectionType(int type) {
        if (type < 0 || type > 2) {
            throw new IllegalArgumentException("illegal connection type:" + type);
        }
        connectionType = type;
    }

    public static int getNextConnectionType(int currentType) {
        return (currentType + 1) % 3;
    }

    public static synchronized int getConnectionType() {
        return connectionType;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    private ServerSocket createServerSocketByName(String name, int port) throws IOException {
        InetAddress addy = InetAddress.getByName(name);
        ServerSocketFactory factory = ServerSocketFactory.getDefault();
        return factory.createServerSocket(port, 0, addy);
    }

    public ServerSocket createServerSocket(int port) {
        ServerSocket s = null;
        boolean done = false;
        while (!done) {
            try {
                switch (MapleServerSocket.getConnectionType()) {
                    case 0: {
                        s = new ServerSocket(port);
                        break;
                    }
                    case 1: {
                        s = this.createServerSocketByName("localhost", port);
                        break;
                    }
                    case 2: {
                        s = this.createServerSocketByName("127.0.0.1", port);
                    }
                }
                this.serverPort = port;
                done = true;
            }
            catch (IOException e) {
                if (++port <= 65535) continue;
                this.serverPort = -1;
                break;
            }
        }
        return s;
    }

    public static CommandOptionParser getCommandOptionParser() throws CommandOptionException {
        if (optionParser == null) {
            optionParser = new CommandOptionParser();
            optionParser.addHandler(new KernelPortOption("p"));
            optionParser.addHandler(new KernelPortOption("ktp"));
            optionParser.addHandler(new LibraryOption("b"));
            optionParser.addHandler(new PassToKernelOption("a", 0));
            optionParser.addHandler(new PassToKernelOption("m", 0));
            optionParser.addHandler(new PassToKernelOption("q", 0));
            optionParser.addHandler(new PassToKernelOption("r", 0));
            optionParser.addHandler(new PassToKernelOption("s", 0));
            optionParser.addHandler(new PassToKernelOption("t", 0));
            optionParser.addHandler(new PassToKernelOption("z", 0));
            optionParser.addHandler(new PassToKernelOption("B", 0));
            optionParser.addHandler(new PassToKernelOption("F", 0));
            optionParser.addHandler(new PassToKernelOption("N", 0));
            optionParser.addHandler(new PassToKernelOption("P", 0));
            optionParser.addHandler(new PassToKernelOption("c", 1));
            optionParser.addHandler(new PassToKernelOption("e", 1));
            optionParser.addHandler(new PassToKernelOption("f", 1));
            optionParser.addHandler(new PassToKernelOption("g", 1));
            optionParser.addHandler(new PassToKernelOption("h", 1));
            optionParser.addHandler(new PassToKernelOption("i", 1));
            optionParser.addHandler(new PassToKernelOption("l", 1));
            optionParser.addHandler(new PassToKernelOption("w", 1));
            optionParser.addHandler(new PassToKernelOption("A", 1));
            optionParser.addHandler(new PassToKernelOption("D", 1));
            optionParser.addHandler(new PassToKernelOption("I", 1));
            optionParser.addHandler(new PassToKernelOption("L", 1));
            optionParser.addHandler(new PassToKernelOption("U", 1));
            optionParser.addHandler(new PassToKernelOption("T", 1));
            optionParser.addHandler(new PassToKernelOption("V", 1));
        }
        return optionParser;
    }

    public static synchronized void setStartupArguments(String[] arguments) throws CommandOptionException {
        if (argumentsSetOnce) {
            throw new CommandOptionException("setStartupArguments may only be called once.");
        }
        argumentsSetOnce = true;
        boolean libPathSet = false;
        argsToPassToKernel = new ArrayList();
        optionParser = MapleServerSocket.getCommandOptionParser();
        optionParser.process(arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.serverSocket = this.createServerSocket(50577);
        if (this.serverSocket == null) {
            KernelPortReady kernelPortReady = this.kernelPortReady;
            synchronized (kernelPortReady) {
                this.kernelPortReady.error = true;
                this.kernelPortReady.notify();
            }
            return;
        }
        WatchForErrors watcher = null;
        Thread errorReader = null;
        try {
            this.mapleServerProc = this.startMapleServer();
            InputStream errors = this.mapleServerProc.getErrorStream();
            watcher = new WatchForErrors(Thread.currentThread(), errors);
            errorReader = new Thread(watcher);
            errorReader.start();
        }
        catch (Throwable t) {
            KernelPortReady kernelPortReady = this.kernelPortReady;
            synchronized (kernelPortReady) {
                this.kernelPortReady.error = true;
                this.kernelPortReady.notify();
            }
            throw new KernelCommunicationError("Unable to start maple server.", t);
        }
        try {
            this.clientSocket = this.serverSocket.accept();
            this.in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
        }
        catch (IOException e) {
            throw new KernelCommunicationError("serverSocket failed in timeout " + this.serverPort, e);
        }
        catch (Throwable e) {
            throw new KernelCommunicationError(this.errorMsg);
        }
        try {
            char ch22;
            while ((ch22 = (char)this.in.read()) != '\u0000') {
                this.mServerstr.append(ch22);
            }
            if (this.mServerstr != null) {
                this.kernelPortStr = this.mServerstr.toString();
            }
            KernelPortReady ch22 = this.kernelPortReady;
            synchronized (ch22) {
                this.kernelPortReady.ready = true;
                this.kernelPortReady.notify();
            }
        }
        catch (Exception e) {
            KernelPortReady kernelPortReady = this.kernelPortReady;
            synchronized (kernelPortReady) {
                this.kernelPortReady.ready = true;
                this.kernelPortReady.notify();
            }
        }
        if (watcher != null) {
            watcher.stopRunning();
        }
    }

    private Process startMapleServer() {
        String binPath = System.getProperty("maple.bin.path");
        if (binPath == null) {
            throw new IllegalArgumentException("Error starting maple server, system property \"maple.bin.path\" not set.");
        }
        if (this.serverPort < 0) {
            throw new IllegalArgumentException("server port < 0");
        }
        String[] cmd = new String[argsToPassToKernel.size() + 5];
        String mserver = null;
        mserver = RuntimePlatform.isMac() ? "mserver_ulimit" : "mserver";
        cmd[0] = binPath != null ? String.valueOf(binPath) + "/" + mserver : mserver;
        cmd[1] = "-kport";
        cmd[2] = Integer.toString(this.serverPort);
        cmd[3] = "-O";
        cmd[4] = this.language;
        int i = 0;
        while (i < argsToPassToKernel.size()) {
            cmd[i + 5] = (String)argsToPassToKernel.get(i);
            ++i;
        }
        Process proc = null;
        try {
            Runtime rt = Runtime.getRuntime();
            File binDir = new File(binPath);
            String[] envp = this.getEnvironmentVariables(binPath);
            proc = rt.exec(cmd, envp, binDir);
            Thread.sleep(4L);
        }
        catch (KernelCommunicationError e) {
            throw e;
        }
        catch (Throwable t) {
            throw new KernelCommunicationError(t.getMessage());
        }
        return proc;
    }

    private String[] getEnvironmentVariables(String binPath) {
        ArrayList<String> envpList = null;
        if (RuntimePlatform.isMac()) {
            String matlabDir;
            String dyldPath;
            String homeDir;
            String envMapleLicenseRoot;
            envpList = new ArrayList<String>();
            String envMapleRoot = System.getProperty(MAPLE_ROOT);
            if (envMapleRoot != null) {
                envpList.add("MAPLE_ROOT=" + envMapleRoot);
            }
            if ((envMapleLicenseRoot = System.getProperty(MAPLE_LICENSE_ROOT)) != null) {
                envpList.add("MAPLE_LICENSE_ROOT=" + envMapleLicenseRoot);
            }
            if ((homeDir = System.getProperty("user.home")) != null) {
                envpList.add("HOME=" + homeDir);
            }
            if (binPath != null) {
                envpList.add("PATH=" + binPath);
            }
            if ((dyldPath = (dyldPath = System.getProperty("maple.dylib.path")) != null && dyldPath.length() > 0 ? String.valueOf(binPath) + ":" + dyldPath : binPath) != null) {
                envpList.add("DYLD_LIBRARY_PATH=" + dyldPath);
            }
            if ((matlabDir = System.getProperty("matlab.basedir")) != null) {
                envpList.add("MATLAB_BASEDIR=" + matlabDir);
            }
        }
        return envpList != null ? envpList.toArray(new String[envpList.size()]) : null;
    }

    public synchronized int getKernelPort() {
        this.kernelPort = -1;
        if (this.kernelPortStr != null) {
            this.kernelPort = Integer.valueOf(this.kernelPortStr);
        }
        return this.kernelPort;
    }

    public synchronized void Shutdown(boolean shutdown) {
        this.shutdown = shutdown;
        try {
            if (this.in != null) {
                this.in.close();
            }
            this.serverSocket.close();
            this.clientSocket.close();
            this.serverSocket = null;
            this.clientSocket = null;
            this.mapleServerProc.destroy();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized boolean isShutdown() {
        return this.shutdown;
    }

    static /* synthetic */ boolean access$2() {
        return libPathSet;
    }

    private static class KernelPortOption
    extends AbstractOptionHandler {
        public KernelPortOption(String name) {
            this.addOptionNames(new String[]{name});
        }

        @Override
        public int numArgs() {
            return 1;
        }

        @Override
        public void handle(CommandOptionParser parser, String[] args) throws CommandOptionException {
            String startupPortString = args[1];
            boolean success = false;
            if (startupPortString != null) {
                try {
                    int portNumber = Integer.parseInt(startupPortString);
                    KernelConnection.setServerPort(portNumber);
                    success = true;
                }
                catch (Exception e) {
                    success = false;
                }
            }
            if (!success) {
                throw new CommandOptionException("Port Option Argument - " + args[1] + " was malformed");
            }
        }
    }

    private static class LibraryOption
    extends PassToKernelOption {
        public LibraryOption(String optionName) {
            super(optionName, 1);
        }

        @Override
        public void handle(CommandOptionParser parser, String[] args) throws CommandOptionException {
            super.handle(parser, args);
            libPathSet = true;
        }
    }

    private static class PassToKernelOption
    extends AbstractOptionHandler {
        int numArgs = 0;

        public PassToKernelOption(String optionName, int numArgs) {
            this.numArgs = numArgs;
            this.addOptionNames(new String[]{optionName});
        }

        @Override
        public int numArgs() {
            return this.numArgs;
        }

        @Override
        public void handle(CommandOptionParser parser, String[] args) throws CommandOptionException {
            int i = 0;
            while (i < args.length) {
                String arg = i == 0 ? "-" + args[i] : args[i];
                argsToPassToKernel.add(arg);
                ++i;
            }
        }
    }

    class WatchForErrors
    implements Runnable {
        InputStream errors;
        Thread parent;
        boolean running = true;

        WatchForErrors(Thread parent, InputStream errors) {
            this.errors = errors;
            this.parent = parent;
        }

        @Override
        public void run() {
            try {
                byte[] buf = new byte[1024];
                StringBuffer sb = new StringBuffer();
                long whatTimeIsItNow = System.currentTimeMillis();
                while (this.running) {
                    Thread.yield();
                    Thread.sleep(1L);
                    long andTheTimeNow = System.currentTimeMillis();
                    if (andTheTimeNow - whatTimeIsItNow <= 15000L) {
                        if (this.errors.available() > 0) {
                            int len = 0;
                            while ((len = this.errors.read(buf, 0, 1023)) > -1) {
                                int i = 0;
                                while (i < len) {
                                    sb.append((char)buf[i]);
                                    ++i;
                                }
                            }
                        }
                        if (sb.length() <= 0) continue;
                        this.running = false;
                        this.signalError(sb.toString());
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void stopRunning() {
            this.running = false;
        }

        public void signalError(String msg) {
            MapleServerSocket.this.errorMsg = msg;
            this.stopRunning();
        }
    }
}

