/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client;

import com.maplesoft.client.KernelAdapter;
import com.maplesoft.client.KernelConnection;
import com.maplesoft.client.KernelEvent;
import com.maplesoft.client.KernelListener;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.kernelresult.KernelErrorResult;
import com.maplesoft.client.kernelresult.KernelRedirectResult;
import com.maplesoft.client.prettyprinter.TTYFormatter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class RedirectedKernelListener
extends KernelAdapter {
    protected KernelListener parent;
    protected KernelRedirectResult.Redirector redirector;
    protected KernelConnection connection;

    public RedirectedKernelListener(KernelConnection connection, KernelRedirectResult.Redirector redirector) {
        this.redirector = redirector;
        this.connection = connection;
    }

    public void setParentListener(KernelListener parent) {
        this.parent = parent;
    }

    public void writeInput(String userInput) {
        try {
            this.redirector.writeString(this.connection.getInterfaceProperties().getValue("prompt") + userInput + "\n");
        }
        catch (IOException ie1) {
            ie1.printStackTrace(System.err);
        }
    }

    @Override
    public boolean processText(KernelEvent event) {
        try {
            this.redirector.writeString(event.getText());
        }
        catch (IOException ie1) {
            ie1.printStackTrace(System.err);
        }
        return true;
    }

    @Override
    public boolean processChar(KernelEvent event) {
        try {
            this.redirector.writeString(event.getText());
        }
        catch (IOException ie1) {
            ie1.printStackTrace(System.err);
        }
        return true;
    }

    @Override
    public boolean processError(KernelEvent event) {
        try {
            KernelErrorResult.FormattedErrorMessage ed = KernelErrorResult.parseErrorMessage(event);
            String errorMessage = "Error: " + ed.getText();
            this.redirector.writeString(errorMessage);
            this.redirector.writeString("\n");
        }
        catch (Exception e1) {
            e1.printStackTrace(System.err);
        }
        return false;
    }

    @Override
    public boolean processWarning(KernelEvent event) {
        try {
            KernelErrorResult.FormattedErrorMessage ed = KernelErrorResult.parseErrorMessage(event);
            String warnMessage = "Warning: " + ed.getText();
            this.redirector.writeString(warnMessage);
            this.redirector.writeString("\n");
        }
        catch (Exception e1) {
            e1.printStackTrace(System.err);
        }
        return false;
    }

    @Override
    public boolean processRealMath(KernelEvent event) {
        try {
            Integer iValue = (Integer)this.connection.getInterfaceProperties().getValue("prettyprint");
            switch (iValue) {
                case 1: 
                case 2: 
                case 3: {
                    TTYFormatter f = new TTYFormatter();
                    TTYWriter writer = new TTYWriter(this.redirector);
                    Dag dag = event.getDag();
                    dag = DagBuilder.normalize(dag);
                    f.display(dag, (PrintWriter)writer);
                    writer.close();
                    break;
                }
                default: {
                    this.redirector.writeString(event.getText());
                    break;
                }
            }
        }
        catch (IOException ie1) {
            ie1.printStackTrace(System.err);
        }
        return true;
    }

    @Override
    public KernelListener getParentListener() {
        return this.parent;
    }

    public KernelRedirectResult.Redirector getRedirector() {
        return this.redirector;
    }

    private static class TTYStream
    extends OutputStream {
        private static final int BUFFER_SIZE = 4000;
        private int offset;
        private char[] buffer;
        private KernelRedirectResult.Redirector redirector;

        private TTYStream(KernelRedirectResult.Redirector redirector) {
            this.redirector = redirector;
            this.buffer = new char[4000];
            this.offset = 0;
        }

        public void update() throws IOException {
            this.redirector.writeString(new String(this.buffer, 0, this.offset));
        }

        public void write(char[] array) throws IOException {
            int length = array.length;
            int i = 0;
            while (i < length) {
                this.buffer[this.offset++] = array[i];
                if (this.offset == 4000) {
                    this.update();
                }
                ++i;
            }
        }

        @Override
        public void close() {
            try {
                this.flush();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            this.update();
        }

        @Override
        public void write(int param) throws IOException {
            this.buffer[this.offset++] = (char)param;
            if (this.offset == 4000) {
                this.update();
            }
        }
    }

    private static class TTYWriter
    extends PrintWriter {
        private TTYWriter(KernelRedirectResult.Redirector redirector) {
            super(new TTYStream(redirector), false);
        }
    }
}

