/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.ExpseqDagFactory;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;

public abstract class AbstractCollectionDagFactory
extends ExpseqDagFactory {
    private static final int ELIDETHRESHOLD = 1000;
    private static final int LEFTSAMPLE = 10;
    private static final int RIGHTSAMPLE = 10;

    public abstract String getLeftBracket();

    public abstract String getRightBracket();

    public abstract int getLeftBracketID();

    public abstract int getRightBracketID();

    public static Dag create(int type, Dag[] args) {
        return Dag.createDag(type, args, null, true);
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        result.append(this.getLeftBracket());
        int length = dag.getLength();
        int i = 0;
        while (i < length) {
            DagBuilder.linePrint(result, dag.getChild(i), options);
            if (i < length - 1) {
                result.append(this.getStringOperator(options));
            }
            ++i;
        }
        result.append(this.getRightBracket());
    }

    @Override
    public LayoutBox createLayout(LayoutFormatter f, Dag dag) {
        LayoutBox b = new DefaultLayoutBox();
        int n = dag.getLength();
        InlineLayoutBox sequence = new InlineLayoutBox(2 * n);
        if (n > 0) {
            LayoutBox firstChild = DagBuilder.createLayout(f, dag.getChild(0));
            sequence.addChild(firstChild);
            int i = 1;
            while (i < n) {
                if (n > 1000 && i == 10) {
                    NotationLayoutBox elide = NotationLayoutBox.createCustomBox(f, "[..." + (n - 10 - 10) + " terms...]");
                    sequence.addChild(NotationLayoutBox.createNotationBox(f, 14));
                    sequence.addChild(elide);
                    i = n - 10;
                }
                NotationLayoutBox comma = NotationLayoutBox.createNotationBox(f, 14);
                sequence.addChild(comma);
                LayoutBox child = DagBuilder.createLayout(f, dag.getChild(i));
                sequence.addChild(child);
                ++i;
            }
        }
        sequence.setDag(dag);
        sequence.setLineBreaker(LineBreakerFactory.newLineBreaker(2));
        b = BracketTemplate.apply(f, (LayoutBox)sequence, this.getLeftBracketID(), this.getRightBracketID());
        SelectionData sd = new SelectionData(1);
        sd.setStandardEastWestArray(sequence);
        sd.setStandardNorthSouthArray();
        sequence.setSelectionData(sd);
        b.setLineBreaker(LineBreakerFactory.newLineBreaker(1));
        return b;
    }

    @Override
    public int getPrecedence(Dag dag, WmiLPrintOptions options) {
        return this.getPrecedence();
    }
}

