/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.MapleNumbers;
import com.maplesoft.client.dag.BackrefBuilder;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstructor;
import com.maplesoft.client.dag.DagRenderContext;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.AbstractLayoutBox;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public abstract class AbstractDagFactory {
    protected AbstractDagFactory() {
    }

    public abstract Dag readDotm(WmiByteArrayInputStream var1) throws IOException;

    public abstract void writeDotm(StringBuffer var1, Dag var2);

    public Dag readDotm(WmiByteArrayInputStream sr, int length) throws IOException {
        return null;
    }

    public int getPrecedence() {
        return 20;
    }

    public int getPrecedence(Dag dag) {
        return this.getPrecedence();
    }

    public int getPrecedence(WmiLPrintOptions options) {
        return this.getPrecedence();
    }

    public int getPrecedence(Dag dag, WmiLPrintOptions options) {
        return this.getPrecedence(dag);
    }

    public int getPrecedence(Dag dag, LayoutFormatter format) {
        return this.getPrecedence(dag);
    }

    public DagConstructor getConstructor() {
        return null;
    }

    public void updateContext(DagRenderContext context) {
    }

    protected Dag readDotm(WmiByteArrayInputStream bs, int type, int length) throws IOException {
        int cnt = 0;
        if (type != 57 && type != 56) {
            cnt = DagBuilder.dagCountPlus();
            DagBuilder.depthPlus();
        }
        Dag[] myDag = new Dag[--length];
        try {
            int i = 0;
            while (i < length) {
                myDag[i] = DagBuilder.create(bs);
                ++i;
            }
        }
        catch (IOException i) {
            // empty catch block
        }
        Dag dag = Dag.createDag(type, myDag, null, true);
        if (type != 57 && type != 56) {
            DagBuilder.putDag(dag, cnt);
            DagBuilder.depthMinus();
        }
        return dag;
    }

    protected void writeDotm(StringBuffer sb, Dag dag, int type, boolean writeLength) {
        int backrefPosition = AbstractDagFactory.isABackref(dag, type);
        if (backrefPosition > 0) {
            this.writeBackref(sb, backrefPosition);
            return;
        }
        char ch = (char)(MapleNumbers.dotMOutputTable[type] + 33 - 1);
        sb.append(ch);
        int length = dag.getLength();
        if (length > 0) {
            if (writeLength) {
                DagBuilder.writeShortInteger(sb, length + 1);
            }
            int i = 0;
            while (i < length) {
                DagBuilder.writeDotm(sb, dag.getChild(i));
                ++i;
            }
        } else if (writeLength) {
            DagBuilder.writeShortInteger(sb, 1);
        }
    }

    public static int isABackref(Dag dag, int type) {
        BackrefBuilder builder;
        int result = 0;
        if (DagBuilder.getBackRefFlag() && type != 57 && type != 56 && (builder = DagBuilder.getBackrefs()) != null && (result = builder.get(dag)) == 0) {
            builder.put(dag);
        }
        return result;
    }

    public void writeBackref(StringBuffer sb, int pos) {
        char ch = (char)(MapleNumbers.dotMOutputTable[56] + 33 - 1);
        sb.append(ch);
        DagBuilder.writeShortInteger(sb, pos);
    }

    public final void linePrint(StringBuffer result, Dag dag) {
    }

    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        result.append("In linePrint: not ready for ");
        result.append(DagBuilder.CLASS_NAMES[dag.getType()]);
    }

    public LayoutBox createLayout(LayoutFormatter f, Dag dag) {
        int type = dag.getType();
        AbstractLayoutBox b = null;
        int length = dag.getLength();
        if (length == 0) {
            String value = dag.getData();
            b = NotationLayoutBox.createCustomBox(f, value);
        } else {
            b = new InlineLayoutBox(DagBuilder.ELEMENT_NAME[type], length);
            int i = 0;
            while (i < length) {
                b.addChild(DagBuilder.createLayout(f, dag.getChild(i)));
                ++i;
            }
        }
        return b;
    }

    public LayoutBox createLayout(LayoutFormatter f, int type, String value) {
        NotationLayoutBox b = NotationLayoutBox.createCustomBox(f, value);
        return b;
    }

    public StringBuffer toMathML(Dag dag) {
        return new StringBuffer();
    }

    public Dag normalize(Dag dag) {
        dag.setNormalized(dag);
        return dag;
    }
}

