/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.Dag;
import java.util.Arrays;

public class BackrefBuilder {
    private static final int HASH_INFLATION = 2;
    private static final int MIN_TABLE_SIZE = 10;
    int tableSize;
    private Dag[] references;
    private int[] indices;
    private int entries;

    public BackrefBuilder(Dag source) {
        this.tableSize = this.computeDagSize(source);
        if (this.tableSize < 10) {
            this.tableSize = 10;
        }
        this.references = new Dag[this.tableSize];
        this.tableSize *= 2;
        this.indices = new int[this.tableSize];
        Arrays.fill(this.indices, -1);
        this.entries = 0;
    }

    public int get(Dag reference) {
        int index = -1;
        int offset = reference.hashCode() % this.tableSize;
        while (this.indices[offset] != -1) {
            Dag candidate = this.references[this.indices[offset]];
            if (candidate.equals(reference)) {
                index = this.indices[offset];
                break;
            }
            if (++offset != this.tableSize) continue;
            offset = 0;
        }
        return index + 1;
    }

    public void put(Dag reference) {
        if (this.entries >= 3 * this.references.length / 4) {
            this.growTables();
            this.put(reference);
        } else if (reference != null) {
            int offset = reference.hashCode() % this.tableSize;
            while (this.indices[offset] != -1) {
                if (++offset != this.tableSize) continue;
                offset = 0;
            }
            this.indices[offset] = this.entries;
            this.references[this.entries++] = reference;
        }
    }

    private void growTables() {
        Dag[] oldReferences = this.references;
        this.entries = 0;
        this.references = new Dag[this.tableSize];
        this.tableSize *= 2;
        this.indices = new int[this.tableSize];
        Arrays.fill(this.indices, -1);
        int size = oldReferences.length;
        int i = 0;
        while (i < size) {
            this.put(oldReferences[i]);
            ++i;
        }
    }

    private int computeDagSize(Dag source) {
        int size = 1;
        int length = source.getLength();
        int i = 0;
        while (i < length) {
            Dag child = source.getChild(i);
            if (child != null) {
                size += this.computeDagSize(child);
            }
            ++i;
        }
        return size;
    }
}

