/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractBinopDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreaker;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.template.BinaryOperationTemplate;

public class ExpseqDagFactory
extends AbstractBinopDagFactory {
    public static Dag createExpseqDag(Dag[] args) {
        return Dag.createDag(29, args, null, true);
    }

    @Override
    public int getType() {
        return 29;
    }

    @Override
    public String getStringOperator(WmiLPrintOptions options) {
        if (options.isNoCommasInExpression()) {
            return " ";
        }
        return ", ";
    }

    @Override
    public NotationLayoutBox createNotationBox(LayoutFormatter formatter) {
        return NotationLayoutBox.createNotationBox(formatter, 14);
    }

    @Override
    public boolean isVariableLength() {
        return true;
    }

    @Override
    public LayoutBox createLayout(LayoutFormatter f, Dag d) {
        int length = d.getLength();
        ExpSeqLayoutBox box = new ExpSeqLayoutBox(2 * length);
        if (length > 0) {
            int n = length;
            int i = 0;
            while (i < n) {
                if (n > this.elideThreshold && i == this.leftSample && n > this.leftSample + this.rightSample) {
                    NotationLayoutBox elide = NotationLayoutBox.createCustomBox(f, "[..." + (n - this.leftSample - this.rightSample) + " terms...]");
                    box.addChild(this.createNotationBox(f));
                    box.addChild(elide);
                    i = n - this.rightSample;
                    if (i == n) break;
                }
                BinaryOperationTemplate.apply(f, (LayoutBox)box, this.createNotationBox(f), d.getChild(i), this.getPrecedence());
                ++i;
            }
        }
        return box;
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        this.infixLinePrint(result, dag, options);
    }

    static class ExpSeqLayoutBox
    extends InlineLayoutBox {
        private static LineBreaker lb = LineBreakerFactory.newLineBreaker(2);

        public ExpSeqLayoutBox(String s, int i) {
            super(s, i);
        }

        public ExpSeqLayoutBox(int length) {
            super(length);
        }

        @Override
        public void setLineBreaker(LineBreaker l) {
        }

        @Override
        public LineBreaker getLineBreaker() {
            return lb;
        }
    }
}

