/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.HybridDag;

public class HashDag
extends HybridDag {
    protected int hashSize;

    public HashDag(int type) {
        super(type, null, null);
    }

    public void setSize(int s) {
        this.hashSize = s;
    }

    public int getSize() {
        return this.hashSize;
    }

    @Override
    public Dag copy() {
        HashDag copy = new HashDag(this.theType);
        copy.setSize(this.hashSize);
        copy.setData(this.theData);
        int length = this.getLength();
        Dag[] children = new Dag[length];
        int i = 0;
        while (i < length) {
            children[i] = this.getChild(i);
            ++i;
        }
        copy.setChildren(children);
        return copy;
    }

    @Override
    public String toString(String indent) {
        StringBuffer s = new StringBuffer();
        s.append(DagBuilder.CLASS_NAMES[this.theType]);
        s.append(" --------------------\n");
        s.append(indent);
        s.append("-type:       ");
        s.append(this.theType);
        s.append("\n");
        s.append(indent);
        s.append("-data:       ");
        s.append(this.theData);
        int length = this.getLength();
        if (length > 0) {
            s.append("\n");
            s.append(indent);
            s.append("-children:   ");
            s.append(length);
            int i = 0;
            while (i < length) {
                s.append("\n");
                s.append(indent);
                s.append("\n");
                s.append(indent);
                s.append(".   SubDag #");
                s.append(i);
                s.append("  ");
                Dag child = this.getChild(i);
                if (child == null) {
                    s.append("--> null");
                } else {
                    s.append(child.toString(String.valueOf(indent) + ".   "));
                }
                ++i;
            }
        }
        return s.toString();
    }
}

