/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.MapleNumbers;
import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class HfloatDagFactory
extends AbstractDagFactory {
    @Override
    public Dag readDotm(WmiByteArrayInputStream is) throws IOException {
        int cnt = DagBuilder.dagCountPlus();
        long tmpL = 0L;
        int i = 0;
        while (i < 16) {
            int ch = is.read();
            if (ch <= 57) {
                ch -= 48;
            } else {
                ch -= 65;
                ch += 10;
            }
            tmpL = (tmpL << 4) + (long)ch;
            ++i;
        }
        Dag dag = Dag.createDag(5, null, Long.toString(tmpL), false);
        DagBuilder.putDag(dag, cnt);
        return dag;
    }

    @Override
    public void writeDotm(StringBuffer sb, Dag dag) {
        int backrefPosition = HfloatDagFactory.isABackref(dag, 5);
        if (backrefPosition > 0) {
            this.writeBackref(sb, backrefPosition);
            return;
        }
        char ch = (char)(MapleNumbers.dotMOutputTable[5] + 33 - 1);
        sb.append(ch);
        long theBits = Long.parseLong(dag.getData());
        String result = Long.toHexString(theBits);
        int padding = 16 - result.length();
        int i = 0;
        while (i < padding) {
            sb.append('0');
            ++i;
        }
        sb.append(result.toUpperCase());
    }

    public static double getDoubleValue(Dag dag) {
        double value = 0.0;
        if (dag != null && dag.getType() == 5) {
            try {
                String strValue = dag.getData();
                if (strValue != null) {
                    long lvalue = Long.parseLong(strValue);
                    value = Double.longBitsToDouble(lvalue);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        result.append("HFloat(");
        result.append(HfloatDagFactory.toString(dag));
        result.append(")");
    }

    public static String toString(Dag dag) {
        double db = HfloatDagFactory.getDoubleValue(dag);
        String strValue = Double.toString(db);
        strValue = strValue.equals("Infinity") ? "HFloat(infinity)" : (strValue.equals("-Infinity") ? "HFloat(-infinity)" : (strValue.equals("NaN") ? "HFloat(undefined)" : strValue.toLowerCase()));
        return strValue;
    }

    @Override
    public LayoutBox createLayout(LayoutFormatter f, Dag dag) {
        String contents = DagBuilder.lPrint(dag, new WmiLPrintOptions());
        NotationLayoutBox box = f.createNotationBox(5, contents, 4);
        box.setLineBreaker(LineBreakerFactory.newLineBreaker(4));
        return box;
    }

    @Override
    public int getPrecedence() {
        return 2;
    }

    @Override
    public int getPrecedence(Dag dag) {
        return DagUtil.isNegative(dag) ? 6 : 2;
    }
}

