/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.BranchDag;
import com.maplesoft.client.dag.Dag;

public class HybridDag
extends BranchDag {
    protected Object theData;

    public HybridDag(int type, Dag[] dags, Object data) {
        super(type, dags);
        this.theData = data;
    }

    @Override
    public void setData(Object data) {
        this.theData = data;
    }

    @Override
    public String getData() {
        return this.theData != null ? this.theData.toString() : null;
    }

    @Override
    public Dag copy() {
        int length = this.getLength();
        Dag[] newDags = new Dag[length];
        int i = 0;
        while (i < length) {
            Dag child = this.getChild(i);
            if (child != null) {
                newDags[i] = child.deepCopy();
            }
            ++i;
        }
        return new HybridDag(this.theType, newDags, this.theData);
    }

    @Override
    public int computeHashCode() {
        int hash = super.computeHashCode();
        if (this.theData != null) {
            hash ^= this.theData.hashCode();
        }
        return hash;
    }

    @Override
    public void dispose() {
        this.theData = null;
        super.dispose();
    }
}

