/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.MapleNumbers;
import com.maplesoft.client.dag.AbstractElisionDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class IntDagFactory
extends AbstractElisionDagFactory {
    private int type;
    private String number;
    private static SelectionData sd = null;

    protected IntDagFactory(int dagType) {
        this.type = dagType;
    }

    @Override
    public Dag readDotm(WmiByteArrayInputStream sr) throws IOException {
        int cnt = DagBuilder.dagCountPlus();
        int dotmLength = DagBuilder.parseShortInteger(sr);
        this.number = DagBuilder.parseDigits(sr, dotmLength);
        Dag dag = Dag.createDag(this.type, null, this.number, false);
        DagBuilder.putDag(dag, cnt);
        return dag;
    }

    @Override
    public void writeDotm(StringBuffer sb, Dag dag) {
        char ch = '\u0000';
        int backrefPosition = IntDagFactory.isABackref(dag, this.type);
        if (backrefPosition > 0) {
            this.writeBackref(sb, backrefPosition);
            return;
        }
        ch = (char)(MapleNumbers.dotMOutputTable[this.type] + 33 - 1);
        sb.append(ch);
        String data = dag.getData();
        DagBuilder.writeShortInteger(sb, data.length());
        DagBuilder.writeDigits(sb, data, data.length());
    }

    @Override
    protected String getElisionThresholdProperty() {
        return "elisiondigitsthreshold";
    }

    @Override
    protected String getElisionAfterProperty() {
        return "elisiondigitsafter";
    }

    @Override
    protected String getElisionBeforeProperty() {
        return "elisiondigitsbefore";
    }

    @Override
    protected int getDefaultElideThreshold() {
        return 10000;
    }

    @Override
    public LayoutBox createLayout(LayoutFormatter f, Dag dag) {
        dag.getType();
        String contents = this.type == 2 ? dag.getData() : DagBuilder.lPrint(dag);
        int cl = contents.length();
        if (cl > this.elideThreshold && cl > this.leftSample + this.rightSample && this.leftSample + this.rightSample > 0 && this.leftSample < Integer.MAX_VALUE && this.rightSample < Integer.MAX_VALUE && this.rightSample > 0 && this.leftSample > 0) {
            int elisionSize = cl - this.leftSample - this.rightSample;
            String elisionMarkerText = elisionSize > 1 ? " digits...]" : " digit...]";
            String elide = "[..." + elisionSize + elisionMarkerText;
            contents = String.valueOf(contents.substring(0, this.leftSample)) + elide + contents.substring(cl - this.rightSample, cl);
        }
        NotationLayoutBox box = f.createNotationBox(this.type, contents, 4);
        box.setLineBreaker(LineBreakerFactory.newLineBreaker(4));
        if (sd == null) {
            sd = new StandardSelectionData(2);
            sd.setContextHelpAvailable(false);
        }
        box.setSelectionData(sd);
        return box;
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        if (this.type == 1) {
            result.append("-");
        }
        result.append(dag.getData());
    }
}

