/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractBinopDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;
import com.maplesoft.client.prettyprinter.template.DivideTemplate;
import com.maplesoft.client.prettyprinter.template.PowerTemplate;
import com.maplesoft.client.prettyprinter.template.RootTemplate;

public class PowerDagFactory
extends AbstractBinopDagFactory {
    public static Dag create(Dag base, Dag exponent) {
        Dag[] dags = new Dag[]{base, exponent};
        return Dag.createDag(13, dags, null, false);
    }

    @Override
    public int getType() {
        return 13;
    }

    @Override
    public String getStringOperator(WmiLPrintOptions options) {
        return "^";
    }

    @Override
    public boolean isVariableLength() {
        return false;
    }

    @Override
    public int getPrecedence() {
        return 3;
    }

    @Override
    public NotationLayoutBox createNotationBox(LayoutFormatter formatter) {
        return NotationLayoutBox.createNotationBox(formatter, 51);
    }

    @Override
    public boolean addBrackets(Dag dag, WmiLPrintOptions options) {
        return DagBuilder.getPrecedence(dag, options) >= this.getPrecedence();
    }

    @Override
    public LayoutBox createLayout(LayoutFormatter f, Dag dag) {
        int type = this.getType();
        LayoutBox b = new DefaultLayoutBox(DagBuilder.ELEMENT_NAME[type], 2);
        int length = dag.getLength();
        if (length == 2) {
            Dag baseDag = dag.getChild(0);
            Dag powerDag = dag.getChild(1);
            if (DagUtil.isOneHalf(powerDag) && f.useRootSymbol() && !f.isInProc()) {
                b = RootTemplate.apply(b, f, dag);
            } else {
                boolean smallExponent;
                LayoutBox base = DagBuilder.createLayout(f, baseDag);
                boolean bl = smallExponent = !f.isInProc();
                if (smallExponent) {
                    f.incSuperscriptCount();
                }
                LayoutBox power = this.createExponent(f, dag, powerDag, smallExponent);
                if (smallExponent) {
                    f.decSuperscriptCount();
                }
                b = PowerTemplate.apply(f, base, power);
                b.applyLayout();
                if (b.getWidth() < f.getSafeBreakWidth()) {
                    b.setLineBreaker(LineBreakerFactory.newLineBreaker(5));
                } else {
                    InlineLayoutBox inlineBox = new InlineLayoutBox("inline-power");
                    LayoutBox inlineBase = base;
                    inlineBase = BracketTemplate.apply(f, inlineBase, baseDag, 3, 0);
                    inlineBox.addChild(inlineBase);
                    inlineBox.addChild(NotationLayoutBox.createNotationBox(f, 52));
                    LayoutBox inlinePower = this.createExponent(f, dag, powerDag, true);
                    inlinePower = BracketTemplate.apply(f, inlinePower, powerDag, 3, 0);
                    inlineBox.addChild(inlinePower);
                    inlineBox.setLineBreaker(LineBreakerFactory.newLineBreaker(9));
                    b = inlineBox;
                }
            }
        }
        return b;
    }

    protected LayoutBox createExponent(LayoutFormatter formatter, Dag root, Dag exponent, boolean is2D) {
        boolean rationalPower = false;
        LayoutBox power = null;
        if (is2D && exponent.getType() == 3) {
            Dag numerator = exponent.getChild(0);
            Dag denominator = exponent.getChild(1);
            if (numerator.getData().length() <= 2 && denominator.getData().length() <= 2) {
                rationalPower = true;
                LayoutBox numeratorBox = DagBuilder.createLayout(formatter, numerator);
                numeratorBox.setDag(numerator);
                LayoutBox denominatorBox = DagBuilder.createLayout(formatter, denominator);
                denominatorBox.setDag(denominator);
                power = DivideTemplate.apply(formatter, numeratorBox, denominatorBox, 9);
                power.setDag(exponent);
            }
        }
        if (!rationalPower) {
            power = DagBuilder.createLayout(formatter, exponent);
            if (!is2D) {
                power = BracketTemplate.apply(formatter, power, exponent, 3, 0);
            }
        }
        return power;
    }
}

