/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.BranchDag;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagRenderContext;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.LeafDag;
import com.maplesoft.client.dag.ProcDag;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.template.ProcTemplate;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;
import java.util.EmptyStackException;
import java.util.Stack;

public class ProcDagFactory
extends AbstractDagFactory {
    private static final boolean DEFAULT_LONGDELIM = false;
    private static final int DEFAULT_VERBOSEPROC = 0;
    private static boolean longForm = false;
    private static int verboseProc = 0;
    public static final int MIN_DAG_LENGTH = 8;
    public static final int NEW_PROC_MIN_LENGTH = 9;
    public static final int OLD_PROC_LENGTH = 7;
    private static final int FIRST = 0;
    public static final int PARAM_INDEX = 0;
    public static final int LOCAL_INDEX = 1;
    public static final int OPTION_INDEX = 2;
    public static final int REMEMBER_INDEX = 3;
    public static final int STATEMENT_INDEX = 4;
    public static final int DESCRIPTION_INDEX = 5;
    public static final int GLOBAL_INDEX = 6;
    public static final int LEXICAL_INDEX = 7;
    public static final int EOP_INDEX = 8;
    private static final int NORMAL_PARAM_COUNT = 8;
    private static Stack parameterStack_read = new Stack();
    private static Stack localStack_read = new Stack();
    private static Stack exportStack_read = new Stack();
    private static Stack lexicalStack_read = new Stack();
    public static final String END_OF_PARAM_MARKER = " $";
    private static int procSubType = 70;

    @Override
    public void updateContext(DagRenderContext context) {
        longForm = context.getInterfaceProperty("longdelim", false);
        verboseProc = context.getInterfaceProperty("verboseproc", 0);
    }

    public static int getActiveProcSubtype() {
        return procSubType;
    }

    public static void setActiveProcSubtype(int ch) {
        procSubType = ch;
    }

    public static boolean useLongForm() {
        return longForm;
    }

    public static int getVerbosity() {
        return verboseProc;
    }

    @Override
    public Dag readDotm(WmiByteArrayInputStream is) throws IOException {
        int dagLength = DagBuilder.parseShortInteger(is);
        return this.readDotm(is, dagLength);
    }

    @Override
    public Dag readDotm(WmiByteArrayInputStream is, int dagLength) throws IOException {
        int cnt = DagBuilder.dagCountPlus();
        int size = --dagLength;
        int subType = ProcDagFactory.getActiveProcSubtype();
        int originalSize = size;
        if (dagLength < 8) {
            size = 8;
        }
        Dag[] myDag = new Dag[size];
        int i = 0;
        while (i < dagLength) {
            myDag[i] = DagBuilder.create(is);
            ++i;
        }
        if (dagLength < size) {
            int j = dagLength;
            while (j < size) {
                myDag[j] = DagConstants.EMPTY;
                ++j;
            }
        }
        Dag options = myDag[2];
        boolean builtin = false;
        int i2 = 0;
        while (i2 < options.getLength()) {
            String opt = options.getChild(i2).getData();
            if (opt != null && opt.equals("builtin")) {
                builtin = true;
            }
            ++i2;
        }
        Dag attributes = null;
        if (builtin) {
            attributes = DagBuilder.create(is);
        }
        ProcDag newDag = new ProcDag(subType, originalSize, myDag);
        if (attributes != null) {
            ((Dag)newDag).setAttributes(attributes);
        }
        DagBuilder.putDag(newDag, cnt);
        return newDag;
    }

    @Override
    public void writeDotm(StringBuffer sb, Dag dag) {
        int type = dag.getType();
        int backrefPosition = ProcDagFactory.isABackref(dag, type);
        if (backrefPosition > 0) {
            this.writeBackref(sb, backrefPosition);
            return;
        }
        int length = dag.getLength();
        char ch = '\u0000';
        if (dag instanceof ProcDag) {
            ch = (char)((ProcDag)dag).getSubType();
            length = ((ProcDag)dag).getLength();
        } else if (length == 9 && !dag.getChild(8).equals(DagConstants.EMPTY)) {
            ch = (char)116;
        } else {
            ch = (char)102;
            if (length == 9) {
                --length;
            }
        }
        sb.append(ch);
        if (length > 0) {
            DagBuilder.writeShortInteger(sb, length + 1);
            int i = 0;
            while (i < length) {
                DagBuilder.writeDotm(sb, dag.getChild(i));
                ++i;
            }
            Dag attributes = dag.getAttributes();
            if (attributes != null) {
                DagBuilder.writeDotm(sb, attributes);
            }
        }
    }

    public static boolean hasReturnType(Dag dag) {
        boolean hasReturnType = false;
        int length = dag.getLength();
        if (dag != null && dag.getType() == 34 && length > 8) {
            Dag typeDag = dag.getChild(length - 1);
            hasReturnType = false;
            if (typeDag != null && typeDag != DagConstants.EMPTY) {
                hasReturnType = ProcDagFactory.containsNameDag(typeDag);
            }
        }
        return hasReturnType;
    }

    private static boolean containsNameDag(Dag typeDag) {
        boolean hasName = false;
        if (typeDag instanceof LeafDag) {
            hasName = typeDag.getType() == 8;
        } else {
            int size = typeDag.getLength();
            int i = 0;
            while (i < size) {
                if (ProcDagFactory.containsNameDag(typeDag.getChild(i))) {
                    hasName = true;
                    break;
                }
                ++i;
            }
        }
        return hasName;
    }

    @Override
    public int getPrecedence() {
        return 1;
    }

    @Override
    public int getPrecedence(Dag term) {
        Dag options = term.getChild(2);
        int i = 0;
        while (i < options.getLength()) {
            String opt = options.getChild(i).getData();
            if (opt != null && opt.equals("arrow")) {
                return 19;
            }
            ++i;
        }
        return this.getPrecedence();
    }

    public static Dag getParameter(int index) {
        Dag result = null;
        if (!parameterStack_read.empty()) {
            Dag dagFromStack = (Dag)parameterStack_read.peek();
            result = index > 0 ? dagFromStack.getChild(index - 1) : null;
        }
        return result;
    }

    public static Dag getLocal(int index) {
        Dag reply = null;
        Dag locals = null;
        int llen = 0;
        int childIndex = 0;
        if (!localStack_read.empty()) {
            locals = (Dag)localStack_read.peek();
            llen = locals.getLength();
        }
        if (index - 1 >= llen) {
            Dag exports;
            Dag dag = exports = exportStack_read.isEmpty() ? null : (Dag)exportStack_read.peek();
            if (exports != null && (childIndex = index - llen - 1) >= 0 && childIndex < exports.getLength()) {
                reply = exports.getChild(childIndex);
            }
        } else if (locals != null && (childIndex = index - 1) >= 0 && childIndex < locals.getLength()) {
            reply = locals.getChild(childIndex);
        }
        return reply;
    }

    public static Dag getLexical(int index) {
        Dag result = null;
        if (!lexicalStack_read.empty()) {
            Dag dagFromStack = (Dag)lexicalStack_read.peek();
            result = index > 0 ? dagFromStack.getChild(index - 1) : null;
        }
        return result;
    }

    public static void addToStacks(Dag dag) {
        parameterStack_read.push(dag.getChild(0));
        localStack_read.push(dag.getChild(1));
        if (dag.getLength() > 7) {
            lexicalStack_read.push(dag.getChild(7));
        }
    }

    public static void addToStacks(Dag params, Dag locals, Dag lexicals, Dag exports) {
        parameterStack_read.push(params);
        localStack_read.push(locals);
        lexicalStack_read.push(lexicals);
        exportStack_read.push(exports);
    }

    public static void removeStacks(Dag dag) {
        try {
            parameterStack_read.pop();
            localStack_read.pop();
            if (dag.getLength() > 7) {
                lexicalStack_read.pop();
            }
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    public static void removeStacks() {
        parameterStack_read.pop();
        localStack_read.pop();
        lexicalStack_read.pop();
        exportStack_read.pop();
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        DagBuilder.inProc = true;
        int length = dag.getLength();
        ProcDagFactory.addToStacks(dag);
        result.append("proc ");
        result.append("(");
        int paramCount = ProcDagFactory.countNormalParams(dag);
        Dag params = dag.getChild(0);
        int endOfParamMarkerIndex = paramCount;
        if (paramCount > 0 && DagUtil.isNameNamed(params.getChild(paramCount - 1), END_OF_PARAM_MARKER)) {
            --endOfParamMarkerIndex;
        }
        int i = 0;
        while (i < endOfParamMarkerIndex) {
            DagBuilder.linePrint(result, params.getChild(i), options);
            if (i < params.getLength() - 1) {
                result.append(", ");
            }
            ++i;
        }
        if (params.getLength() > paramCount) {
            result.append("{ ");
            i = paramCount;
            while (i < params.getLength()) {
                DagBuilder.linePrint(result, params.getChild(i), options);
                if (i < params.getLength() - 1) {
                    result.append(", ");
                }
                ++i;
            }
            result.append(" }");
        }
        if (endOfParamMarkerIndex < paramCount) {
            if (params.getLength() > paramCount) {
                result.append(", ");
            }
            DagBuilder.linePrint(result, params.getChild(endOfParamMarkerIndex), options);
        }
        result.append(")");
        if (ProcDagFactory.hasReturnType(dag)) {
            Dag typeDag = dag.getChild(length - 1);
            result.append("::");
            DagBuilder.linePrint(result, typeDag, options);
            result.append(";");
        }
        result.append(" ");
        Dag child = dag.getChild(1);
        if (child.getLength() > 0) {
            result.append("local ");
            DagBuilder.linePrint(result, child, options);
            result.append("; ");
        }
        if ((child = dag.getChild(2)).getLength() > 0) {
            if (child.getLength() > 1) {
                result.append("options ");
            } else {
                result.append("option ");
            }
            DagBuilder.linePrint(result, child, options);
            result.append("; ");
        }
        if ((child = dag.getChild(6)).getLength() > 0) {
            result.append("global ");
            DagBuilder.linePrint(result, child, options);
            result.append("; ");
        }
        if (!((child = dag.getChild(5)) instanceof BranchDag) || child.getLength() > 0) {
            result.append("description ");
            DagBuilder.linePrint(result, child, options);
            result.append("; ");
        }
        if ((child = dag.getChild(3)).getLength() > 0) {
            DagBuilder.linePrint(result, child, options);
            result.append(" ");
        }
        if ((child = dag.getChild(4)) != null) {
            DagBuilder.linePrint(result, child, options);
            if (child.getType() == 29) {
                if (child.getLength() > 0) {
                    result.append(" ");
                }
            } else {
                result.append(" ");
            }
        }
        result.append("end proc");
        ProcDagFactory.removeStacks(dag);
        DagBuilder.inProc = false;
    }

    public static int countNormalParams(Dag dag) {
        Dag count;
        Dag eop;
        int result = dag.getChild(0).getLength();
        if (dag.getLength() > 8 && (eop = dag.getChild(8)) != null && !DagUtil.isNull(eop) && DagUtil.isExpSeq(eop) && (count = eop.getChild(0)).getType() == 2) {
            result = Integer.parseInt(count.getData());
        }
        return result;
    }

    @Override
    public LayoutBox createLayout(LayoutFormatter f, Dag dag) {
        LayoutBox box = null;
        ProcDagFactory.addToStacks(dag);
        f.incProcCount();
        box = ProcTemplate.apply(f, dag);
        f.decProcCount();
        ProcDagFactory.removeStacks(dag);
        return box;
    }
}

