/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.HybridDag;
import com.maplesoft.client.dag.RtableData;

public class RtableDag
extends HybridDag {
    public static final int RTABLE_NUMDIMS_INDEX = 6;
    public static final int RTABLE_RESERVED_INDEX = 5;
    public static final int RTABLE_READONLY_INDEX = 4;
    public static final int RTABLE_ORDER_INDEX = 3;
    public static final int RTABLE_STORAGE_INDEX = 2;
    public static final int RTABLE_SUBTYPE_INDEX = 1;
    public static final int RTABLE_DATATYPE_INDEX = 0;
    public static final int RTABLE_DAG = 0;
    public static final int RTABLE_CXDAG = 1;
    public static final int RTABLE_INTEGER8 = 2;
    public static final int RTABLE_INTEGER16 = 3;
    public static final int RTABLE_INTEGER32 = 4;
    public static final int RTABLE_INTEGER64 = 5;
    public static final int RTABLE_FLOAT = 6;
    public static final int RTABLE_FLOAT64 = 6;
    public static final int RTABLE_COMPLEX = 7;
    public static final int RTABLE_FLOAT32 = 8;
    public static final int RTABLE_NUM_DATATYPES = 9;
    public static final int RTABLE_ARRAY = 0;
    public static final int RTABLE_MATRIX = 1;
    public static final int RTABLE_COLUMN = 2;
    public static final int RTABLE_ROW = 3;
    public static final int RTABLE_SPARSE = 0;
    public static final int RTABLE_EMPTY = 1;
    public static final int RTABLE_DIAG = 2;
    public static final int RTABLE_BAND = 3;
    public static final int RTABLE_RECT = 4;
    public static final int RTABLE_UPPTRI = 5;
    public static final int RTABLE_UPPTRIMINUS = 6;
    public static final int RTABLE_UPPTRIPLUS = 7;
    public static final int RTABLE_LOWTRI = 8;
    public static final int RTABLE_LOWTRIMINUS = 9;
    public static final int RTABLE_LOWTRIPLUS = 10;
    public static final int RTABLE_SCALAR = 11;
    public static final int RTABLE_FORTRAN = 0;
    public static final int RTABLE_C = 1;
    protected int[] theFlags;
    protected int[] theSizes;
    protected RtableData theTableData;
    protected Dag[] dataDags;

    public RtableDag() {
        super(38, null, null);
    }

    public void setFlags(int[] f) {
        this.theFlags = f;
    }

    public int[] getFlags() {
        return this.theFlags;
    }

    public int getDataType() {
        return this.theFlags[0];
    }

    public int getSubType() {
        return this.theFlags[1];
    }

    public int getStorage() {
        return this.theFlags[2];
    }

    public int getOrder() {
        return this.theFlags[3];
    }

    public int getReadOnly() {
        return this.theFlags[4];
    }

    public int getReserved() {
        return this.theFlags[5];
    }

    public int getDimensionCount() {
        return this.theFlags[6];
    }

    public boolean isReadOnly() {
        return this.getReadOnly() == 1;
    }

    public boolean isFortranOrder() {
        return this.getOrder() == 1;
    }

    public void setSizes(int[] s) {
        this.theSizes = s;
    }

    public int[] getSizes() {
        return this.theSizes;
    }

    public int getElementCount() {
        return this.theSizes[0];
    }

    public int getRangeLowerBound(int dim) {
        return this.theSizes[dim * 2 + 1];
    }

    public int getRangeUpperBound(int dim) {
        return this.theSizes[dim * 2 + 2];
    }

    private Dag getBandExpSeqDag() {
        Dag indexFuncDag = this.getChild(2);
        Dag tableRefDag = indexFuncDag.getChild(0);
        return tableRefDag.getChild(1);
    }

    public int getBandLowerBound() {
        Dag expseq = this.getBandExpSeqDag();
        return DagUtil.parseInt(expseq.getChild(0));
    }

    public int getBandUpperBound() {
        Dag expseq = this.getBandExpSeqDag();
        return DagUtil.parseInt(expseq.getChild(1));
    }

    public void setTableData(RtableData rd) {
        this.theTableData = rd;
    }

    public RtableData getTableData() {
        return this.theTableData;
    }

    public void setDataDags(Dag[] dags) {
        this.dataDags = dags;
    }

    public Dag[] getDataDags() {
        return this.dataDags;
    }

    @Override
    public Dag copy() {
        RtableDag copy = new RtableDag();
        copy.theFlags = this.getFlags();
        copy.theSizes = this.getSizes();
        copy.dataDags = this.getDataDags();
        copy.setTableData(this.theTableData);
        copy.theData = this.theData;
        copy.theDags = this.theDags;
        return copy;
    }

    @Override
    public Dag getNormalized() {
        if (this.normalized == null) {
            this.normalized = DagBuilder.normalize(this);
        }
        return this.normalized;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RtableDag)) {
            return false;
        }
        RtableDag d = (RtableDag)o;
        if (this.theFlags.length != d.theFlags.length) {
            return false;
        }
        int i = 0;
        while (i < this.theFlags.length) {
            if (this.theFlags[i] != d.theFlags[i]) {
                return false;
            }
            ++i;
        }
        if (this.theSizes.length != d.theSizes.length) {
            return false;
        }
        i = 0;
        while (i < this.theSizes.length) {
            if (this.theSizes[i] != d.theSizes[i]) {
                return false;
            }
            ++i;
        }
        if (this.dataDags != d.dataDags && this.dataDags != null) {
            if (this.dataDags.length != d.dataDags.length) {
                return false;
            }
            i = 0;
            while (i < this.theSizes.length) {
                if (!this.dataDags[i].equals(d.dataDags[i])) {
                    return false;
                }
                ++i;
            }
        }
        if (this.theTableData != d.theTableData && this.theTableData != null) {
            return this.theTableData.equals(d.theTableData);
        }
        return true;
    }

    @Override
    public int computeHashCode() {
        int hash = super.computeHashCode();
        if (this.theTableData.getNamedArray() != null) {
            hash ^= this.theTableData.getNamedArray().hashCode();
        }
        return hash;
    }

    @Override
    public void dispose() {
        this.theTableData = null;
        super.dispose();
    }

    @Override
    public String toString() {
        int i;
        StringBuffer result = new StringBuffer("*********************\n");
        result.append("Type: " + this.theType + " " + DagBuilder.CLASS_NAMES[this.theType] + "\n");
        int dagLength = 1;
        int dataLength = 0;
        int calculatedLength = 0;
        if (this.theDags != null) {
            i = 0;
            while (i < this.theDags.length) {
                if (this.theDags[i] != null) {
                    result.append(this.theDags[i].toString());
                }
                ++i;
            }
            dagLength = this.theDags.length;
        }
        if (this.theData instanceof String) {
            result.append("Data: " + this.theData + "\n");
            dataLength = ((String)this.theData).length();
        }
        calculatedLength = dataLength > 0 ? dataLength : dagLength;
        result.append("Length: " + calculatedLength + "\n");
        i = 0;
        while (i < this.theFlags.length) {
            result.append("Flag # " + i + " is " + this.theFlags[i] + "\n");
            ++i;
        }
        i = 0;
        while (i < this.theSizes.length) {
            result.append("Sizes # " + i + " is " + this.theSizes[i] + "\n");
            ++i;
        }
        result.append(this.theTableData);
        result.append("\nArray Name is " + this.theTableData.getNamedArray());
        result.append("\n(");
        if (this.theData instanceof String && dataLength > 0) {
            result.append("Leaf Node with Data)\n");
        } else if (calculatedLength == 1) {
            result.append("Leaf Node -- no Children)\n");
        } else if (calculatedLength > 1) {
            result.append("Branch Node)\n");
        } else if (this.theDags == null && this.theData == null) {
            result.append("Leaf Node -- no Children/no Data)\n");
        } else if (this.theData instanceof String && dataLength == 0) {
            result.append("Leaf Node with no Data)\n");
        }
        result.append("End of: " + this.theType + " " + DagBuilder.CLASS_NAMES[this.theType] + "\n");
        result.append("*********************\n");
        return result.toString();
    }
}

