/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.ArrayData;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.RtableData;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;

public class RtableDoubleData
extends RtableData {
    double[] theData;
    int[] theDimensions;
    int[] theMultipliers;
    String theName;

    public double[] getDoubleData() {
        return this.theData;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RtableDoubleData)) {
            return false;
        }
        RtableDoubleData d = (RtableDoubleData)o;
        if (this.theData != d.theData && this.theData != null) {
            if (this.theData.length != d.theData.length) {
                return false;
            }
            int i = 0;
            while (i < this.theData.length) {
                if (this.theData[i] != d.theData[i]) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    void setDoubleData(double[] data) {
        this.theDimensions = new int[1];
        this.theDimensions[0] = data.length;
        this.theMultipliers = new int[0];
        this.theData = data;
    }

    @Override
    public void readDotm(WmiByteArrayInputStream bs, int[] size, int[] dims) throws IOException {
        int j;
        int i;
        super.readDotm(bs, size, dims);
        this.theData = new double[size[0]];
        this.theDimensions = dims;
        byte[] din = bs.getData();
        int p = bs.getPos();
        long tmpL = 0L;
        int j2 = 0;
        while (j2 < size[0]) {
            tmpL = 0L;
            i = 0;
            while (i < 16) {
                int ch;
                if ((ch = din[p++]) <= 57) {
                    ch -= 48;
                } else {
                    ch -= 65;
                    ch += 10;
                }
                tmpL = (tmpL << 4) + (long)ch;
                ++i;
            }
            this.theData[j2] = Double.longBitsToDouble(tmpL);
            ++j2;
        }
        bs.setPos(p);
        if (dims.length == 3) {
            double[][][] n_dim_data = new double[dims[0]][dims[1]][dims[2]];
            i = 0;
            while (i < dims[0]) {
                j = 0;
                while (j < dims[1]) {
                    int k = 0;
                    while (k < dims[2]) {
                        int pos = this.getPosition(i, j, k);
                        n_dim_data[i][j][k] = this.theData[pos];
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            this.theName = ArrayData.put(n_dim_data);
        } else if (dims.length == 4) {
            double[][][][] n_dim_data = new double[dims[0]][dims[1]][dims[2]][dims[3]];
            i = 0;
            while (i < dims[0]) {
                j = 0;
                while (j < dims[1]) {
                    int k = 0;
                    while (k < dims[2]) {
                        int l = 0;
                        while (l < dims[3]) {
                            int pos = this.getPosition(i, j, k, l);
                            n_dim_data[i][j][k][l] = this.theData[pos];
                            ++l;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            this.theName = ArrayData.put(n_dim_data);
        } else if (dims.length == 2) {
            double[][] n_dim_data = new double[dims[0]][dims[1]];
            i = 0;
            while (i < dims[0]) {
                j = 0;
                while (j < dims[1]) {
                    int pos = this.getPosition(i, j);
                    n_dim_data[i][j] = this.theData[pos];
                    ++j;
                }
                ++i;
            }
            this.theName = ArrayData.put(n_dim_data);
        } else {
            this.theName = ArrayData.put(this.theData);
        }
    }

    @Override
    public StringBuffer writeDotm() {
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < this.theData.length) {
            DagBuilder.doubleToHex(this.theData[i], sb);
            ++i;
        }
        return sb;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("{ ");
        int numDims = this.theDimensions.length;
        int[] counts = new int[numDims];
        Arrays.fill(counts, 1);
        int i = 0;
        while (i < this.theData.length) {
            if (this.theData[i] != 0.0) {
                sb.append("(");
                int ii = 0;
                while (ii < numDims) {
                    sb.append(counts[ii]);
                    if (ii < numDims - 1) {
                        sb.append(", ");
                    }
                    ++ii;
                }
                sb.append(") = ");
                sb.append(this.theData[i]);
                if (i < this.theData.length - 1) {
                    sb.append(",");
                }
            }
            counts = this.updateCounts(this.theDimensions, counts, numDims - 1);
            counts = this.checkCounts(this.theDimensions, counts);
            ++i;
        }
        sb.append(" }");
        return sb.toString();
    }

    private int[] updateCounts(int[] dims, int[] counts, int whichCount) {
        int n = whichCount;
        counts[n] = counts[n] + 1;
        if (counts[whichCount] % dims[whichCount] == 1) {
            counts[whichCount] = 1;
            if (whichCount > 0) {
                counts = this.updateCounts(dims, counts, whichCount - 1);
            }
        }
        return counts;
    }

    private int[] checkCounts(int[] dims, int[] counts) {
        int i = 0;
        while (i < counts.length) {
            if (counts[i] > dims[i]) {
                counts[i] = 0;
            }
            ++i;
        }
        return counts;
    }

    @Override
    public int[] getDimensions() {
        return this.theDimensions;
    }

    @Override
    public int getIntegerAt(int[] positions) {
        return (int)this.theData[0];
    }

    @Override
    public double getDoubleAt(int[] positions) {
        int pos = this.getPosition(positions);
        return this.theData[pos];
    }

    @Override
    public Dag getDagAt(int x, int y) {
        return null;
    }

    @Override
    public float getFloatAt(int[] positions) {
        return (float)this.theData[0];
    }

    @Override
    public Dag getDagAt(int[] positons) {
        return null;
    }

    @Override
    public int getIntegerAt(int pos) {
        return (int)this.theData[pos];
    }

    @Override
    public double getDoubleAt(int pos) {
        return this.theData[pos];
    }

    @Override
    public float getFloatAt(int pos) {
        return (float)this.theData[pos];
    }

    @Override
    public Dag getDagAt(int pos) {
        return DagUtil.createDoubleDag(this.theData[pos]);
    }

    @Override
    public String getNamedArray() {
        return this.theName;
    }
}

