/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.RtableData;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class RtableShortData
extends RtableData {
    int[] theData;
    int[] theDimensions;
    String theName;

    public boolean equals(Object o) {
        if (!(o instanceof RtableShortData)) {
            return false;
        }
        RtableShortData d = (RtableShortData)o;
        if (this.theData != d.theData && this.theData != null) {
            if (this.theData.length != d.theData.length) {
                return false;
            }
            int i = 0;
            while (i < this.theData.length) {
                if (this.theData[i] != d.theData[i]) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public void readDotm(WmiByteArrayInputStream bs, int[] size, int[] dims) throws IOException {
        super.readDotm(bs, size, dims);
        this.theData = new int[size[0]];
        this.theDimensions = dims;
        int i = 0;
        while (i < size[0]) {
            this.theData[i] = DagBuilder.parseShortInteger(bs);
            ++i;
        }
    }

    @Override
    public StringBuffer writeDotm() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.theData.length) {
            DagBuilder.writeShortInteger(sb, this.theData[i]);
            ++i;
        }
        return sb;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("[ ");
        int i = 0;
        while (i < this.theData.length) {
            sb.append(this.theData[i]);
            sb.append(" ");
            ++i;
        }
        sb.append("]\n");
        return sb.toString();
    }

    @Override
    public int[] getDimensions() {
        return this.theDimensions;
    }

    @Override
    public int getIntegerAt(int[] positions) {
        return this.theData[0];
    }

    @Override
    public double getDoubleAt(int[] positions) {
        return this.theData[0];
    }

    @Override
    public Dag getDagAt(int x, int y) {
        return null;
    }

    @Override
    public float getFloatAt(int[] positions) {
        return this.theData[0];
    }

    @Override
    public Dag getDagAt(int[] positons) {
        return null;
    }

    @Override
    public int getIntegerAt(int position) {
        return this.theData[position];
    }

    @Override
    public double getDoubleAt(int position) {
        return this.theData[position];
    }

    @Override
    public float getFloatAt(int position) {
        return this.theData[position];
    }

    @Override
    public Dag getDagAt(int position) {
        return DagUtil.createIntDag(this.theData[position]);
    }

    @Override
    public String getNamedArray() {
        return this.theName;
    }
}

