/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.MapleNumbers;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.TextDagFactory;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.encoder.KernelEncoder;

public class StringDagFactory
extends TextDagFactory {
    public StringDagFactory() {
        super(7);
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        String quote;
        String string = quote = options.isDropStringQuotes() ? "" : "\"";
        if (!options.isQuoteResult()) {
            result.append(quote);
            super.linePrint(result, dag, options);
            result.append(quote);
        } else {
            result.append(quote);
            String data = dag.getData();
            int i = 0;
            while (i < data.length()) {
                char c = data.charAt(i);
                if (c == '\"' || c == '\\') {
                    result.append('\\');
                }
                if (c == '\n') {
                    result.append("\\n");
                } else {
                    result.append(c);
                }
                ++i;
            }
            result.append(quote);
        }
    }

    @Override
    public void writeDotm(StringBuffer sb, Dag dag) {
        Dag attributes = dag.getAttributes();
        char ch = '\u0000';
        int backrefPosition = StringDagFactory.isABackref(dag, this.type);
        if (backrefPosition > 0) {
            this.writeBackref(sb, backrefPosition);
            return;
        }
        if (attributes == null || attributes.getType() == 57) {
            ch = (char)(MapleNumbers.dotMOutputTable[this.type] + 33 - 1);
        } else {
            ch = (char)(MapleNumbers.dotMOutputTable[this.type + 57] + 33 - 1);
            if (ch == ' ') {
                ch = (char)(MapleNumbers.dotMOutputTable[this.type] + 33 - 1);
            }
        }
        sb.append(ch);
        String name = dag.getDataOnly();
        KernelEncoder encoder = RuntimeLocale.getKernelEncoder();
        if (encoder != null) {
            name = encoder.fromUnicode(name, false);
        }
        int calculatedLength = name.length();
        DagBuilder.writeShortInteger(sb, calculatedLength);
        DagBuilder.writeNameAsDotm(sb, name);
        if (attributes == null) {
            DagBuilder.writeDotm(sb, DagConstants.EMPTY);
        } else {
            DagBuilder.writeDotm(sb, attributes);
        }
    }
}

