/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractElisionDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.ProdDagFactory;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreaker;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.BinaryOperationTemplate;
import com.maplesoft.client.prettyprinter.template.UnaryOperationTemplate;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class SumDagFactory
extends AbstractElisionDagFactory {
    public static Dag create(Dag dag1, int sgn1, Dag dag2, int sgn2) {
        Dag[] kids = new Dag[]{dag1, sgn1 == 1 ? DagConstants.ONE : DagConstants.MINUS_ONE, dag2, sgn2 == 1 ? DagConstants.ONE : DagConstants.MINUS_ONE};
        return Dag.createDag(16, kids, null, false);
    }

    public static Dag addTerm(Dag sum, int sign, Dag term) {
        Dag dSign = DagConstants.MINUS_ONE;
        if (sign == 1) {
            dSign = DagConstants.ONE;
        }
        sum.addChild(term);
        sum.addChild(dSign);
        return sum;
    }

    public static Dag sumDagToIntegerDag(Dag dag) {
        Dag value = null;
        int dagType = dag.getType();
        if (dagType == 2 || dagType == 1) {
            value = dag;
        } else if (dagType == 16 && dag.getLength() == 2) {
            Dag argOne = dag.getChild(0);
            Dag argTwo = dag.getChild(1);
            try {
                int val = Integer.parseInt(argOne.getData());
                int type = argTwo.getType();
                value = Dag.createDag(type, null, Integer.toString(val), false);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    public static Dag create(Dag[] dag) {
        return Dag.createDag(16, dag, null, false);
    }

    @Override
    public Dag readDotm(WmiByteArrayInputStream is) throws IOException {
        return this.readDotm(is, 16, DagBuilder.parseShortInteger(is));
    }

    @Override
    public void writeDotm(StringBuffer sb, Dag dag) {
        this.writeDotm(sb, dag, 16, true);
    }

    @Override
    public int getPrecedence() {
        return 6;
    }

    @Override
    public int getPrecedence(Dag dag, WmiLPrintOptions options) {
        Dag scale;
        int precedence = 6;
        if (dag.getLength() == 2 && !DagUtil.isMinusOne(scale = dag.getChild(1))) {
            precedence = DagUtil.isOne(scale) ? DagBuilder.getPrecedence(dag.getChild(0), options) : 4;
        }
        return precedence;
    }

    @Override
    public StringBuffer toMathML(Dag dag) {
        return new StringBuffer();
    }

    private void prefixLinePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        int length = dag.getLength();
        result.append("`+`(");
        int i = 0;
        while (i < length) {
            if (i != 0) {
                result.append(", ");
            }
            Dag term = dag.getChild(i);
            Dag scale = dag.getChild(i + 1);
            if (scale.getType() == 1) {
                result.append("`-`(");
            }
            DagBuilder.linePrint(result, term, options);
            if (scale.getType() == 1) {
                result.append(")");
            }
            i += 2;
        }
        result.append(")");
    }

    private void infixLinePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        int length = dag.getLength();
        int size = 0;
        int i = 0;
        while (i < length) {
            int precedence;
            boolean addBrackets;
            boolean positive;
            Dag term = dag.getChild(i);
            Dag scale = dag.getChild(i + 1);
            boolean bl = positive = scale.getType() == 2;
            if (positive) {
                if (size > 0) {
                    result.append("+");
                }
            } else {
                result.append("-");
            }
            boolean bl2 = addBrackets = (precedence = DagBuilder.getPrecedence(term, options)) > 6;
            if (precedence == 6) {
                Dag leadingScale;
                int sumLength;
                if (scale.getType() == 2 && term.getType() == 16 && (sumLength = term.getLength()) > 2 && DagUtil.isNegative(leadingScale = term.getChild(1))) {
                    addBrackets = true;
                }
                if (scale.getType() == 1) {
                    addBrackets = true;
                }
            }
            if (addBrackets) {
                result.append("(");
            }
            DagBuilder.linePrint(result, term, options);
            if (addBrackets) {
                result.append(")");
            }
            ++size;
            i += 2;
        }
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        if (options.isInLineIfPossible()) {
            this.infixLinePrint(result, dag, options);
        } else {
            this.prefixLinePrint(result, dag, options);
        }
    }

    @Override
    public Dag normalize(Dag dag) {
        Dag result = null;
        if (dag != null && dag.getType() == 16) {
            if (!dag.isNormalized()) {
                int length = dag.getLength();
                result = dag.copy();
                int i = 0;
                while (i < length) {
                    Dag child;
                    Dag term = dag.getChild(i);
                    Dag scale = dag.getChild(i + 1);
                    if (term.getType() == 16 && term.getLength() == 2 && DagUtil.isMinusOne(term.getChild(1))) {
                        scale = DagUtil.negate(scale);
                        term = term.getChild(0);
                    }
                    if (term.getType() == 14 && (child = term.getChild(0)).getType() == 6 && DagUtil.isNegative(child)) {
                        term = DagUtil.negate(term);
                        scale = DagUtil.negate(scale);
                    }
                    if (DagUtil.isNegative(scale)) {
                        if (DagUtil.isMinusOne(scale)) {
                            result.setChild(i, term);
                            result.setChild(i + 1, scale);
                        } else {
                            result.setChild(i, ProdDagFactory.create(DagUtil.negate(scale), term));
                            result.setChild(i + 1, DagConstants.MINUS_ONE);
                        }
                    } else if (DagUtil.isOne(scale)) {
                        if (DagUtil.isNegative(term)) {
                            result.setChild(i, DagUtil.negate(term));
                            result.setChild(i + 1, DagConstants.MINUS_ONE);
                        } else {
                            result.setChild(i, term);
                            result.setChild(i + 1, scale);
                        }
                    } else {
                        result.setChild(i, ProdDagFactory.create(scale, term));
                        result.setChild(i + 1, DagConstants.ONE);
                    }
                    i += 2;
                }
                dag.setNormalized(result);
            } else {
                result = dag.getNormalized();
            }
        }
        return result;
    }

    @Override
    protected String getElisionThresholdProperty() {
        return "elisiontermsthreshold";
    }

    @Override
    protected String getElisionAfterProperty() {
        return "elisiontermsafter";
    }

    @Override
    protected String getElisionBeforeProperty() {
        return "elisiontermsbefore";
    }

    @Override
    protected int getDefaultElideThreshold() {
        return 1000;
    }

    @Override
    public LayoutBox createLayout(LayoutFormatter f, Dag dag) {
        int length = dag.getLength();
        String boxName = DagBuilder.ELEMENT_NAME[16];
        SumLayoutBox box = new SumLayoutBox(boxName, length + 1);
        if (length == 2) {
            Dag term = dag.getChild(0);
            Dag scale = dag.getChild(1);
            if (scale.getType() == 1) {
                NotationLayoutBox notation = term.getType() == 3 || ProdDagFactory.isQuotient(term) ? NotationLayoutBox.createNotationBox(f, 111) : NotationLayoutBox.createNotationBox(f, 24);
                box.addChild(notation);
            }
            LayoutBox child = DagBuilder.createLayout(f, term);
            box.addChild(child);
        } else {
            boolean useElision = false;
            if (this.elideThreshold >= 0 && this.elideThreshold < Integer.MAX_VALUE) {
                useElision = length > 2 * this.elideThreshold && length > 2 * (this.leftSample + this.rightSample) && 2 * (this.leftSample + this.rightSample) > 0 && 2 * this.leftSample < Integer.MAX_VALUE && 2 * this.rightSample < Integer.MAX_VALUE && 2 * this.rightSample > 0 && 2 * this.leftSample > 0;
            }
            int i = 0;
            while (i < length) {
                if (useElision && i == this.leftSample * 2) {
                    int elisionSize = length / 2 - this.leftSample - this.rightSample;
                    String elisionMarkerText = elisionSize > 1 ? " terms...]" : " term...]";
                    NotationLayoutBox elide = NotationLayoutBox.createCustomBox(f, "[..." + elisionSize + elisionMarkerText);
                    box.addChild(NotationLayoutBox.createNotationBox(f, 1));
                    box.addChild(elide);
                    i = length - this.rightSample * 2;
                    if (i == length) break;
                }
                Dag term = dag.getChild(i);
                Dag scale = dag.getChild(i + 1);
                if (scale.getType() == 2) {
                    BinaryOperationTemplate.apply(f, (LayoutBox)box, 1, term, this.getPrecedence(dag), 0);
                } else if (box.numChildren() == 0) {
                    int notation = term.getType() == 3 || ProdDagFactory.isQuotient(term) ? 111 : 24;
                    box.addChild(UnaryOperationTemplate.apply(f, notation, term, this.getPrecedence(dag), 0));
                } else {
                    BinaryOperationTemplate.apply(f, (LayoutBox)box, 2, term, this.getPrecedence(dag), 0);
                }
                i += 2;
            }
        }
        StandardSelectionData sd = new StandardSelectionData(1);
        box.setSelectionData(sd);
        return box;
    }

    static class SumLayoutBox
    extends InlineLayoutBox {
        private static LineBreaker lb = LineBreakerFactory.newLineBreaker(7);

        public SumLayoutBox(String s, int i) {
            super(s, i);
        }

        public SumLayoutBox() {
        }

        @Override
        public void setLineBreaker(LineBreaker l) {
        }

        @Override
        public LineBreaker getLineBreaker() {
            return lb;
        }
    }
}

