/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.AbstractLayoutBox;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.linebreaker.StringLineBreaker;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.util.WmiByteArrayInputStream;
import com.maplesoft.util.encoder.UnicodeEscapeEncoder;
import java.io.IOException;

public abstract class TextDagFactory
extends AbstractDagFactory {
    protected int type;

    public TextDagFactory(int dagType) {
        this.type = dagType;
    }

    @Override
    public int getPrecedence() {
        return 1;
    }

    @Override
    public Dag readDotm(WmiByteArrayInputStream sr) throws IOException {
        String name = "";
        int cnt = DagBuilder.dagCountPlus();
        int len = DagBuilder.parseShortInteger(sr);
        name = len > 0 ? DagBuilder.getName(sr, len) : "";
        Dag attributes = null;
        boolean attributed = true;
        if (this.type == 8 || this.type == 7) {
            attributes = DagBuilder.create(sr);
            if (this.type == 8 && attributes == null) {
                attributed = false;
            }
        }
        Dag dag = Dag.createDag(this.type, null, name, attributed);
        dag.setAttributes(attributes);
        DagBuilder.putDag(dag, cnt);
        return dag;
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        StringBuffer data = new StringBuffer(dag.getData());
        result.append(data.toString());
    }

    static void debug(Object message) {
    }

    protected LayoutBox createBox(LayoutFormatter f, String value) {
        AbstractLayoutBox b = null;
        int index = (value = UnicodeEscapeEncoder.convertEscapeSequenceToUnicode(value)).indexOf(10);
        if (index < 0) {
            b = NotationLayoutBox.createCustomBox(f, value);
        } else {
            String substr;
            b = new InlineLayoutBox();
            int offset = 0;
            while (index >= 0) {
                substr = value.substring(offset, index);
                b.addChild(NotationLayoutBox.createCustomBox(f, substr));
                offset = index + 1;
                index = value.indexOf(10, offset);
            }
            if (offset < value.length()) {
                substr = value.substring(offset);
                b.addChild(NotationLayoutBox.createCustomBox(f, substr));
            }
            b.addChild(new StringLineBreaker.LinebrokenStringTerminatorBox());
        }
        return b;
    }

    @Override
    public LayoutBox createLayout(LayoutFormatter f, Dag dag) {
        String label = dag.getType() == 8 ? dag.getData() : "\"" + dag.getData() + "\"";
        LayoutBox b = null;
        b = this.createBox(f, label);
        b.setLineBreaker(LineBreakerFactory.newLineBreaker(8));
        SelectionData sd = new SelectionData(2);
        sd.setStandardEastWestArray(b);
        sd.setStandardNorthSouthArray();
        b.setSelectionData(sd);
        return b;
    }

    @Override
    public LayoutBox createLayout(LayoutFormatter f, int layoutType, String value) {
        LayoutBox b = super.createLayout(f, layoutType, value);
        b.setLineBreaker(LineBreakerFactory.newLineBreaker(8));
        SelectionData sd = new SelectionData(2);
        sd.setStandardEastWestArray(b);
        sd.setStandardNorthSouthArray();
        b.setSelectionData(sd);
        return b;
    }
}

